/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.subtile;

import ab.common.lib.register.RecipeListAB;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.entities.EntityAspectOrb;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.block.ModBlocks;

public class SubTilePureGladiolus
extends SubTileFunctional {
    private static final int MAX_MANA = 10000;
    private static final String COOLDOWN_TAG = "Cooldown";
    private static final Aspect[] PRIMALS = new Aspect[]{Aspect.AIR, Aspect.WATER, Aspect.EARTH, Aspect.ENTROPY, Aspect.ORDER, Aspect.FIRE};
    private int cooldown = 180;
    protected static int manaRequare = 1000;

    public void onUpdate() {
        super.onUpdate();
        int tick = 1;
        World world = this.supertile.func_145831_w();
        int x = this.supertile.field_145851_c;
        int y = this.supertile.field_145848_d;
        int z = this.supertile.field_145849_e;
        List players = world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)1.9f, (double)1.2f, (double)1.9f));
        if (world.func_147439_a(x, y + 1, z).func_149688_o() != Material.field_151579_a) {
            return;
        }
        if (world.func_147439_a(x, y - 1, z) == ModBlocks.enchantedSoil) {
            tick = 2;
        }
        if (players.isEmpty()) {
            return;
        }
        if (this.cooldown > 0) {
            this.cooldown -= tick;
        } else if (this.mana >= manaRequare && this.cooldown <= 0) {
            this.mana -= manaRequare;
            this.cooldown = 180;
            this.spawnAspectOrbs(world, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
        }
    }

    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toChunkCoordinates(), 1);
    }

    public LexiconEntry getEntry() {
        return RecipeListAB.gladious;
    }

    public void spawnAspectOrbs(World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            for (int i = 0; i < 3 + world.field_73012_v.nextInt(3); ++i) {
                EntityAspectOrb orb = new EntityAspectOrb(world, x, y, z, PRIMALS[world.field_73012_v.nextInt(6)], 2 + world.field_73012_v.nextInt(3));
                orb.field_70159_w = 0.05 - Math.random() * 0.1;
                orb.field_70181_x = 0.07;
                orb.field_70179_y = 0.05 - Math.random() * 0.1;
                world.func_72838_d((Entity)orb);
            }
            this.sync();
        }
    }

    public int getColor() {
        return 0xFF00FF;
    }

    public int getMaxMana() {
        return 10000;
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(COOLDOWN_TAG, this.cooldown);
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.func_74762_e(COOLDOWN_TAG);
    }
}

