/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.subtile;

import ab.common.core.handler.ConfigABHandler;
import ab.common.lib.register.RecipeListAB;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.block.tile.TileSpecialFlower;

public class SubTileDictarius
extends SubTileGenerating {
    private static final int workMana = 480;
    int cooldown;

    public void onUpdate() {
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K) {
            return;
        }
        int posX = this.supertile.field_145851_c;
        int posY = this.supertile.field_145848_d;
        int posZ = this.supertile.field_145849_e;
        World world = this.supertile.func_145831_w();
        if (world.func_82737_E() % 1200L == 0L) {
            this.checkNearDictarius();
        }
        if (this.mana != this.getMaxMana() && this.cooldown == 0) {
            List livs = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)posX, (double)posY, (double)posZ, (double)(posX + 1), (double)(posY + 1), (double)(posZ + 1)).func_72314_b(2.0, 1.0, 2.0));
            int workMana = 0;
            int villagers = 0;
            if (!livs.isEmpty()) {
                for (int i = 0; i < Math.min(livs.size(), 16); ++i) {
                    EntityLivingBase liv = (EntityLivingBase)livs.get(i);
                    if (liv instanceof EntityPlayer) {
                        workMana += 480;
                        continue;
                    }
                    if (world.field_72995_K || !(liv instanceof EntityVillager)) continue;
                    workMana += 80;
                    if (villagers > 15 && world.field_73012_v.nextInt(100) <= 4) {
                        liv.func_70106_y();
                    }
                    ++villagers;
                }
            }
            if (workMana > 0) {
                this.cooldown = 200;
                workMana = (int)((double)workMana * Math.random());
                this.mana = Math.min(this.getMaxMana(), this.mana + workMana);
                this.sync();
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toChunkCoordinates(), 2);
    }

    public void checkNearDictarius() {
        int findedFlower = 0;
        for (int z = -4; z < 4; ++z) {
            for (int x = -4; x < 4; ++x) {
                for (int y = -4; y < 4; ++y) {
                    int posX = this.supertile.field_145851_c + x;
                    int posY = this.supertile.field_145848_d + y;
                    int posZ = this.supertile.field_145849_e + z;
                    TileEntity tile = this.supertile.func_145831_w().func_147438_o(posX, posY, posZ);
                    if (tile == null || !(tile instanceof TileSpecialFlower)) continue;
                    TileSpecialFlower tileFlower = (TileSpecialFlower)tile;
                    if (!tileFlower.subTileName.equals("dictarius")) continue;
                    if (findedFlower >= ConfigABHandler.maxDictariusCount) {
                        this.supertile.func_145831_w().func_72926_e(2001, this.supertile.field_145851_c, this.supertile.field_145848_d, this.supertile.field_145849_e, Block.func_149682_b((Block)this.supertile.func_145838_q()));
                        if (this.supertile.func_145831_w().func_147439_a(this.supertile.field_145851_c, this.supertile.field_145848_d - 1, this.supertile.field_145849_e).isSideSolid((IBlockAccess)this.supertile.func_145831_w(), this.supertile.field_145851_c, this.supertile.field_145848_d - 1, this.supertile.field_145849_e, ForgeDirection.UP)) {
                            this.supertile.func_145831_w().func_147449_b(this.supertile.field_145851_c, this.supertile.field_145848_d, this.supertile.field_145849_e, (Block)Blocks.field_150330_I);
                        } else {
                            this.supertile.func_145831_w().func_147468_f(this.supertile.field_145851_c, this.supertile.field_145848_d, this.supertile.field_145849_e);
                        }
                        return;
                    }
                    ++findedFlower;
                }
            }
        }
    }

    public int getMaxMana() {
        return 8000;
    }

    public int getColor() {
        return 13815218;
    }

    public LexiconEntry getEntry() {
        return RecipeListAB.dictarius;
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a("cooldown", this.cooldown);
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.func_74762_e("cooldown");
    }
}

