/*
 * Decompiled with CFR 0.152.
 */
package com.ae.additions.utils.asm;

import com.ae.additions.utils.asm.ASMUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FieldSetter {
    private final String owner;
    private final String name;
    private final Type type;
    private final boolean isStatic;

    public FieldSetter(String owner, String name, Type type, boolean isStatic) {
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
    }

    public FieldSetter(String owner, String name, Type type) {
        this(owner, name, type, false);
    }

    public FieldInsnNode getNode() {
        return new FieldInsnNode(this.isStatic ? 179 : 181, this.owner, this.name, this.type.getDescriptor());
    }

    public MethodNode generateSetterMethod(String name) {
        MethodNode node = new MethodNode(1 | (this.isStatic ? 8 : 0), name, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{this.type}), null, null);
        InsnList list = node.instructions;
        if (!this.isStatic) {
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        list.add((AbstractInsnNode)new VarInsnNode(ASMUtils.getLoadOpcodeFromType(this.type), this.isStatic ? 0 : 1));
        list.add((AbstractInsnNode)this.getNode());
        list.add((AbstractInsnNode)new InsnNode(177));
        return node;
    }

    public MethodNode generateSetterMethod() {
        return this.generateSetterMethod("set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1));
    }
}

