/*
 * Decompiled with CFR 0.152.
 */
package com.ae.additions.utils;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.TraceClassVisitor;

public class ASMUtils {
    public static AbstractInsnNode findFirstOpCode(InsnList instructions, int opcode) {
        for (int index = 0; index < instructions.size(); ++index) {
            if (instructions.get(index).getOpcode() != opcode) continue;
            return instructions.get(index);
        }
        return null;
    }

    public static AbstractInsnNode findLastOpCode(InsnList instructions, int opcode) {
        for (int index = instructions.size() - 1; index > 0; --index) {
            if (instructions.get(index).getOpcode() != opcode) continue;
            return instructions.get(index);
        }
        return null;
    }

    public static AbstractInsnNode findLastType(InsnList instructions, int type, int skip) {
        for (int index = instructions.size() - 1; index > 0; --index) {
            if (instructions.get(index).getType() != type || --skip >= 0) continue;
            return instructions.get(index);
        }
        return null;
    }

    public static AbstractInsnNode findNextOpCode(AbstractInsnNode fromInstruction, int opcode) {
        AbstractInsnNode nextInsn = fromInstruction;
        do {
            if (nextInsn.getOpcode() != opcode) continue;
            return nextInsn;
        } while ((nextInsn = nextInsn.getNext()) != null);
        return null;
    }

    public static AbstractInsnNode findSequenceLast(InsnList instructions, boolean skipNons, int ... opSequence) {
        int seqIndex = 0;
        AbstractInsnNode insertionPoint = null;
        for (int index = 0; index < instructions.size(); ++index) {
            AbstractInsnNode ins = instructions.get(index);
            if (skipNons && ins.getOpcode() == -1) continue;
            if (ins.getOpcode() == opSequence[seqIndex]) {
                if (++seqIndex != opSequence.length) continue;
                insertionPoint = ins;
                break;
            }
            seqIndex = ins.getOpcode() == opSequence[0] ? 1 : 0;
        }
        return insertionPoint;
    }

    public static AbstractInsnNode findSequence(InsnList instructions, boolean skipNons, int ... opSequence) {
        int seqIndex = 0;
        AbstractInsnNode insertionPoint = null;
        boolean found = false;
        for (int index = 0; index < instructions.size(); ++index) {
            AbstractInsnNode ins = instructions.get(index);
            if (skipNons && ins.getOpcode() == -1) continue;
            if (ins.getOpcode() == opSequence[seqIndex]) {
                if (seqIndex == 0) {
                    insertionPoint = ins;
                }
                if (++seqIndex != opSequence.length) continue;
                found = true;
                break;
            }
            if (ins.getOpcode() == opSequence[0]) {
                insertionPoint = ins;
                seqIndex = 1;
                continue;
            }
            seqIndex = 0;
        }
        return found ? insertionPoint : null;
    }

    public static ClassNode readClass(byte[] basicClass, int flags) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, flags);
        return node;
    }

    public static ClassNode readClass(byte[] basicClass) {
        return ASMUtils.readClass(basicClass, 0);
    }

    public static MethodNode findMethod(ClassNode classNode, String ... names) {
        List<String> list = Arrays.asList(names);
        MethodNode methodNode = null;
        for (MethodNode node : classNode.methods) {
            if (!list.contains(node.name)) continue;
            methodNode = node;
            break;
        }
        return methodNode;
    }

    public static byte[] writeClass(ClassNode node, int flags) {
        ClassWriter writer = new ClassWriter(flags);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] writeClass(ClassNode node) {
        return ASMUtils.writeClass(node, 3);
    }

    public static MethodNode findMethodDesc(ClassNode classNode, String name, String desc) {
        MethodNode methodNode = null;
        for (MethodNode node : classNode.methods) {
            if (!name.equals(node.name) || !desc.equals(node.desc)) continue;
            methodNode = node;
            break;
        }
        return methodNode;
    }

    public static void log(ClassNode classNode, PrintWriter writer) {
        TraceClassVisitor visitor = new TraceClassVisitor(writer);
        classNode.accept((ClassVisitor)visitor);
    }

    public static void log(ClassNode classNode) {
        ASMUtils.log(classNode, new PrintWriter(System.out));
    }

    public static List<AbstractInsnNode> findAllOpcodes(InsnList list, int opcode) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode node : list.toArray()) {
            if (node.getOpcode() != opcode) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static MethodNode generateGetter(String name, String desc, int opcode, String owner, String fieldName, int retOpcode) {
        MethodNode node = new MethodNode(327680, 1, name, "()" + desc, null, null);
        InsnList list = node.instructions;
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(opcode, owner, fieldName, desc));
        list.add((AbstractInsnNode)new InsnNode(retOpcode));
        return node;
    }

    public static InsnList copy(InsnList list) {
        MethodNode node = new MethodNode();
        list.accept((MethodVisitor)node);
        return node.instructions;
    }
}

