/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.xml;

public class EscapeToolkit {
    private EscapeToolkit() {
        throw new Error("Don't");
    }

    public static String escape(String s) {
        StringBuilder result = new StringBuilder(s.length() + 10);
        EscapeToolkit.addEscapedTo(result, s);
        return result.toString();
    }

    public static void addEscapedTo(StringBuilder buffer, CharSequence unescaped) {
        int i = 0;
        while (i < unescaped.length()) {
            EscapeToolkit.addEscapedCharacters(buffer, unescaped.charAt(i));
            ++i;
        }
    }

    private static void addEscapedCharacters(StringBuilder buffer, char c) {
        String replacement = EscapeToolkit.getEscapeSequence(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    private static String getEscapeSequence(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
            case '\r': {
                return "#x0D";
            }
            case '\n': {
                return "#x0A";
            }
            case '\t': {
                return "#x09";
            }
        }
        return null;
    }
}

