/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.steps;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.attach.providers.RemotePackExporter;
import org.netbeans.modules.profiler.attach.spi.AttachStepsProvider;
import org.netbeans.modules.profiler.attach.steps.Bundle;
import org.openide.util.RequestProcessor;

public class BasicAttachStepsProvider
extends AttachStepsProvider {
    protected static final String LINK_CLIPBOARD = "file:/clipboard";
    protected static final String LINK_REMOTEPACK = "file:/remotepack";
    protected static final String LINK_JDK5 = "file:/jdk5";
    protected static final String LINK_JDK6UP = "file:/jdk6up";
    protected static final String LINK_32ARCH = "file:/32arch";
    protected static final String LINK_64ARCH = "file:/64arch";
    protected String currentJDK = "file:/jdk6up";
    protected String currentARCH = "file:/64arch";
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();
    private static final AtomicBoolean exportRunning = new AtomicBoolean(false);

    @Override
    public final synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    @Override
    public final synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected final synchronized void fireChange(ChangeEvent changeEvent) {
        if (changeEvent == null) {
            changeEvent = new ChangeEvent(this);
        }
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public String getSteps(AttachSettings attachSettings) {
        if (attachSettings.isRemote()) {
            return this.remoteDirectSteps(attachSettings);
        }
        if (attachSettings.isDirect()) {
            return this.localDirectSteps(attachSettings);
        }
        return this.localDynamicSteps(attachSettings);
    }

    @Override
    public void handleAction(String string, AttachSettings attachSettings) {
        if (LINK_CLIPBOARD.equals(string)) {
            this.copyParameters(attachSettings);
        } else if (LINK_REMOTEPACK.equals(string)) {
            this.createRemotePack(attachSettings);
        } else if (LINK_JDK5.equals(string)) {
            this.switchToJDK5();
        } else if (LINK_JDK6UP.equals(string)) {
            this.switchToJDK6Up();
        } else if (LINK_32ARCH.equals(string)) {
            this.switchTo32ARCH();
        } else if (LINK_64ARCH.equals(string)) {
            this.switchTo64ARCH();
        }
    }

    protected void switchToJDK5() {
        this.currentJDK = LINK_JDK5;
        this.fireChange(null);
    }

    protected void switchToJDK6Up() {
        this.currentJDK = LINK_JDK6UP;
        this.fireChange(null);
    }

    protected void switchTo32ARCH() {
        this.currentARCH = LINK_32ARCH;
        this.fireChange(null);
    }

    protected void switchTo64ARCH() {
        this.currentARCH = LINK_64ARCH;
        this.fireChange(null);
    }

    protected String localDynamicSteps(AttachSettings attachSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(1));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_MakeSureStarted(System.getProperty("user.name")));
        stringBuilder.append("</div>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(2));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_SubmitSelectProcess());
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    protected String localDirectSteps(AttachSettings attachSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(1));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_EnsureCorrectJava(BasicAttachStepsProvider.getCorrectJavaMsg(this.currentJDK, this.currentARCH)));
        String string = " <a href='";
        string = string + (LINK_JDK6UP.equals(this.currentJDK) ? LINK_JDK5 : LINK_JDK6UP);
        string = string + "'>";
        String string2 = "</a> ";
        stringBuilder.append(LINK_JDK6UP.equals(this.currentJDK) ? Bundle.AttachDialog_Steps_SwitchToJava5(string, string2) : Bundle.AttachDialog_Steps_SwitchToJava6Up(string, string2));
        if (!IntegrationUtils.PLATFORM_MAC_OS.equals(IntegrationUtils.getLocalPlatform((int)-1))) {
            string = " <a href='";
            string = string + (LINK_64ARCH.equals(this.currentARCH) ? LINK_32ARCH : LINK_64ARCH);
            string = string + "'>";
            stringBuilder.append(LINK_64ARCH.equals(this.currentARCH) ? Bundle.AttachDialog_Steps_SwitchTo32BitArch(string, string2) : Bundle.AttachDialog_Steps_SwitchTo64BitArch(string, string2));
        }
        stringBuilder.append("</div>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(2));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_AddParameters());
        stringBuilder.append(" (<a href='");
        stringBuilder.append(LINK_CLIPBOARD);
        stringBuilder.append("'>");
        stringBuilder.append(Bundle.AttachDialog_Steps_CopyToClipboard());
        stringBuilder.append("</a>):");
        stringBuilder.append("</div>");
        stringBuilder.append("<pre>");
        stringBuilder.append(this.parameters(attachSettings));
        stringBuilder.append("</pre>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(3));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_StartApplication());
        stringBuilder.append("</div>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(4));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_SubmitUnblock());
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    protected String remoteDirectSteps(AttachSettings attachSettings) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(1));
        stringBuilder.append("</b> ");
        if (BasicAttachStepsProvider.isCVMJVM(attachSettings)) {
            stringBuilder.append(Bundle.AttachDialog_Steps_EnsureCorrectJava(Bundle.AttachDialog_Steps_JavaCvm()));
        } else if (BasicAttachStepsProvider.isARMJVM(attachSettings)) {
            stringBuilder.append(Bundle.AttachDialog_Steps_EnsureCorrectJava(Bundle.AttachDialog_Steps_JavaSeEmbedded()));
        } else {
            stringBuilder.append(LINK_JDK6UP.equals(this.currentJDK) ? Bundle.AttachDialog_Steps_EnsureCorrectJava(Bundle.AttachDialog_Steps_Java6()) : Bundle.AttachDialog_Steps_EnsureCorrectJava(Bundle.AttachDialog_Steps_Java5()));
            String string = " <a href='";
            string = string + (LINK_JDK6UP.equals(this.currentJDK) ? LINK_JDK5 : LINK_JDK6UP);
            string = string + "'>";
            String string2 = "</a> ";
            stringBuilder.append(LINK_JDK6UP.equals(this.currentJDK) ? Bundle.AttachDialog_Steps_SwitchToJava5(string, string2) : Bundle.AttachDialog_Steps_SwitchToJava6Up(string, string2));
        }
        stringBuilder.append("</div>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(2));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_CreateRemotePack("'file:/remotepack'", "<code>&lt;remote&gt;</code>"));
        stringBuilder.append("</div>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(3));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_RunCalibrateScript("<code>" + IntegrationUtils.getRemoteCalibrateCommandString((String)attachSettings.getHostOS(), (String)BasicAttachStepsProvider.getPlatform(attachSettings, this.currentJDK)) + "</code>"));
        stringBuilder.append("</div>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(4));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_AddParameters());
        stringBuilder.append(" (<a href='");
        stringBuilder.append(LINK_CLIPBOARD);
        stringBuilder.append("'>");
        stringBuilder.append(Bundle.AttachDialog_Steps_CopyToClipboard());
        stringBuilder.append("</a>):");
        stringBuilder.append("</div>");
        stringBuilder.append("<pre>");
        stringBuilder.append(this.parameters(attachSettings));
        stringBuilder.append("</pre>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(5));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_StartApplication());
        stringBuilder.append("</div>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<div>");
        stringBuilder.append("<b>");
        stringBuilder.append(Bundle.AttachDialog_Steps_Step(6));
        stringBuilder.append("</b> ");
        stringBuilder.append(Bundle.AttachDialog_Steps_SubmitUnblock());
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    protected String parameters(AttachSettings attachSettings) {
        return IntegrationUtils.getProfilerAgentCommandLineArgs((String)BasicAttachStepsProvider.getOS(attachSettings, this.currentARCH), (String)BasicAttachStepsProvider.getPlatform(attachSettings, this.currentJDK), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort());
    }

    protected void copyParameters(AttachSettings attachSettings) {
        String string = this.parameters(attachSettings);
        string = string.replace("&lt;", "<").replace("&gt;", ">");
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        ProfilerDialogs.displayInfo((String)Bundle.AttachDialog_CopiedToClipboard());
    }

    protected void createRemotePack(final AttachSettings attachSettings) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser jFileChooser = new JFileChooser();
                File file = new File(System.getProperty("java.io.tmpdir"));
                jFileChooser.setDialogTitle(Bundle.AttachDialog_RemotePackDialogCaption());
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setSelectedFile(file);
                jFileChooser.setCurrentDirectory(file);
                jFileChooser.setMultiSelectionEnabled(false);
                if ((1 & jFileChooser.showSaveDialog(jFileChooser)) == 0) {
                    final String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    final String string2 = BasicAttachStepsProvider.this.currentJDK;
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String string3 = BasicAttachStepsProvider.exportRemotePack(string, attachSettings, string2);
                                ProfilerDialogs.displayInfo((String)Bundle.AttachDialog_RemotePackSaved(string3));
                            }
                            catch (IOException iOException) {
                                System.err.println("Exception creating remote pack: " + iOException);
                            }
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String exportRemotePack(String string, AttachSettings attachSettings, String string2) throws IOException {
        if (exportRunning.compareAndSet(false, true)) {
            try {
                if (string != null && string.endsWith(File.separator)) {
                    string = string.substring(0, string.length() - 1);
                }
                String string3 = RemotePackExporter.getInstance().export(string, BasicAttachStepsProvider.getOS(attachSettings, null), BasicAttachStepsProvider.getPlatform(attachSettings, string2));
                return string3;
            }
            finally {
                exportRunning.compareAndSet(true, false);
            }
        }
        throw new IOException();
    }

    protected static String getOS(AttachSettings attachSettings, String string) {
        if (!attachSettings.isRemote()) {
            return IntegrationUtils.getLocalPlatform((int)(string == LINK_64ARCH ? 64 : 32));
        }
        String string2 = attachSettings.getHostOS();
        if (IntegrationUtils.PLATFORM_WINDOWS_CVM.equals(string2)) {
            return IntegrationUtils.PLATFORM_WINDOWS_OS;
        }
        if (IntegrationUtils.PLATFORM_LINUX_CVM.equals(string2)) {
            return IntegrationUtils.PLATFORM_LINUX_OS;
        }
        return attachSettings.getHostOS();
    }

    protected static String getPlatform(AttachSettings attachSettings, String string) {
        if (attachSettings.isRemote() && BasicAttachStepsProvider.isCVMJVM(attachSettings)) {
            return IntegrationUtils.PLATFORM_JAVA_CVM;
        }
        if (LINK_JDK5.equals(string)) {
            return IntegrationUtils.PLATFORM_JAVA_50;
        }
        return IntegrationUtils.PLATFORM_JAVA_60;
    }

    protected static boolean isCVMJVM(AttachSettings attachSettings) {
        String string = attachSettings.getHostOS();
        return IntegrationUtils.PLATFORM_WINDOWS_CVM.equals(string) || IntegrationUtils.PLATFORM_LINUX_CVM.equals(string);
    }

    protected static boolean isARMJVM(AttachSettings attachSettings) {
        String string = attachSettings.getHostOS();
        return IntegrationUtils.PLATFORM_LINUX_ARM_OS.equals(string);
    }

    protected static String getCorrectJavaMsg(String string, String string2) {
        if (IntegrationUtils.PLATFORM_MAC_OS.equals(IntegrationUtils.getLocalPlatform((int)-1))) {
            return LINK_JDK6UP.equals(string) ? Bundle.AttachDialog_Steps_Java6() : Bundle.AttachDialog_Steps_Java5();
        }
        if (LINK_64ARCH.equals(string2)) {
            return LINK_JDK6UP.equals(string) ? Bundle.AttachDialog_Steps_Java6_64b() : Bundle.AttachDialog_Steps_Java5_64b();
        }
        return LINK_JDK6UP.equals(string) ? Bundle.AttachDialog_Steps_Java6_32b() : Bundle.AttachDialog_Steps_Java5_32b();
    }
}

