/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import javax.crypto.BadPaddingException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import sun.misc.JavaNetAccess;
import sun.misc.SharedSecrets;
import sun.security.ssl.Alerts;
import sun.security.ssl.AppInputStream;
import sun.security.ssl.AppOutputStream;
import sun.security.ssl.Authenticator;
import sun.security.ssl.BaseSSLSocketImpl;
import sun.security.ssl.CipherBox;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.ClientHandshaker;
import sun.security.ssl.Debug;
import sun.security.ssl.Handshaker;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.ServerHandshaker;
import sun.security.ssl.Utilities;

public final class SSLSocketImpl
extends BaseSSLSocketImpl {
    private static final int cs_START = 0;
    private static final int cs_HANDSHAKE = 1;
    private static final int cs_DATA = 2;
    private static final int cs_RENEGOTIATE = 3;
    private static final int cs_ERROR = 4;
    private static final int cs_SENT_CLOSE = 5;
    private static final int cs_CLOSED = 6;
    private static final int cs_APP_CLOSED = 7;
    private volatile int connectionState;
    private boolean expectingFinished;
    private SSLException closeReason;
    private byte doClientAuth;
    private boolean roleIsServer;
    private boolean enableSessionCreation = true;
    private String host;
    private boolean autoClose = true;
    private AccessControlContext acc;
    private CipherSuiteList enabledCipherSuites;
    private String identificationProtocol = null;
    private AlgorithmConstraints algorithmConstraints = null;
    List<SNIServerName> serverNames = Collections.emptyList();
    Collection<SNIMatcher> sniMatchers = Collections.emptyList();
    private boolean noSniExtension = false;
    private boolean noSniMatcher = false;
    String[] applicationProtocols = new String[0];
    String applicationProtocol = null;
    BiFunction<SSLSocket, List<String>, String> applicationProtocolSelector;
    private final Object handshakeLock = new Object();
    final ReentrantLock writeLock = new ReentrantLock();
    private final Object readLock = new Object();
    private InputRecord inrec;
    private Authenticator readAuthenticator;
    private Authenticator writeAuthenticator;
    private CipherBox readCipher;
    private CipherBox writeCipher;
    private boolean secureRenegotiation;
    private byte[] clientVerifyData;
    private byte[] serverVerifyData;
    private SSLContextImpl sslContext;
    private Handshaker handshaker;
    private SSLSessionImpl sess;
    private volatile SSLSessionImpl handshakeSession;
    private HashMap<HandshakeCompletedListener, AccessControlContext> handshakeListeners;
    private InputStream sockInput;
    private OutputStream sockOutput;
    private AppInputStream input;
    private AppOutputStream output;
    private ProtocolList enabledProtocols;
    private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private static final Debug debug = Debug.getInstance("ssl");
    private boolean isFirstAppOutputRecord = true;
    private ByteArrayOutputStream heldRecordBuffer = null;
    private boolean preferLocalCipherSuites = false;
    static final boolean trustNameService = Debug.getBooleanProperty("jdk.tls.trustNameService", false);

    SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n) throws IOException, UnknownHostException {
        this.host = string;
        this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
        this.init(sSLContextImpl, false);
        InetSocketAddress inetSocketAddress = string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n) throws IOException {
        this.init(sSLContextImpl, false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        this.host = string;
        this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
        this.init(sSLContextImpl, false);
        this.bind(new InetSocketAddress(inetAddress, n2));
        InetSocketAddress inetSocketAddress = string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this.init(sSLContextImpl, false);
        this.bind(new InetSocketAddress(inetAddress2, n2));
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.connect(inetSocketAddress, 0);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, boolean bl, CipherSuiteList cipherSuiteList, byte by, boolean bl2, ProtocolList protocolList, String string, AlgorithmConstraints algorithmConstraints, Collection<SNIMatcher> collection, boolean bl3, String[] stringArray) throws IOException {
        this.doClientAuth = by;
        this.enableSessionCreation = bl2;
        this.identificationProtocol = string;
        this.algorithmConstraints = algorithmConstraints;
        this.sniMatchers = collection;
        this.preferLocalCipherSuites = bl3;
        this.applicationProtocols = stringArray;
        this.init(sSLContextImpl, bl);
        this.enabledCipherSuites = cipherSuiteList;
        this.enabledProtocols = protocolList;
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl) {
        this.init(sSLContextImpl, false);
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, Socket socket, String string, int n, boolean bl) throws IOException {
        super(socket);
        if (!socket.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        this.host = string;
        this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
        this.init(sSLContextImpl, false);
        this.autoClose = bl;
        this.doneConnect();
    }

    SSLSocketImpl(SSLContextImpl sSLContextImpl, Socket socket, InputStream inputStream, boolean bl) throws IOException {
        super(socket, inputStream);
        if (!socket.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        this.init(sSLContextImpl, true);
        this.autoClose = bl;
        this.doneConnect();
    }

    private void init(SSLContextImpl sSLContextImpl, boolean bl) {
        this.sslContext = sSLContextImpl;
        this.sess = new SSLSessionImpl();
        this.handshakeSession = null;
        this.roleIsServer = bl;
        this.connectionState = 0;
        this.readCipher = CipherBox.NULL;
        this.readAuthenticator = MAC.NULL;
        this.writeCipher = CipherBox.NULL;
        this.writeAuthenticator = MAC.NULL;
        this.secureRenegotiation = false;
        this.clientVerifyData = new byte[0];
        this.serverVerifyData = new byte[0];
        this.enabledCipherSuites = this.sslContext.getDefaultCipherSuiteList(this.roleIsServer);
        this.enabledProtocols = this.sslContext.getDefaultProtocolList(this.roleIsServer);
        this.inrec = null;
        this.acc = AccessController.getContext();
        this.input = new AppInputStream(this);
        this.output = new AppOutputStream(this);
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        if (this.isLayered()) {
            throw new SocketException("Already connected");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new SocketException("Cannot handle non-Inet socket addresses.");
        }
        super.connect(socketAddress, n);
        if (this.host == null || this.host.length() == 0) {
            this.useImplicitHost(false);
        }
        this.doneConnect();
    }

    void doneConnect() throws IOException {
        this.sockInput = super.getInputStream();
        this.sockOutput = super.getOutputStream();
        this.initHandshaker();
    }

    private synchronized int getConnectionState() {
        return this.connectionState;
    }

    private synchronized void setConnectionState(int n) {
        this.connectionState = n;
    }

    AccessControlContext getAcc() {
        return this.acc;
    }

    void writeRecord(OutputRecord outputRecord) throws IOException {
        this.writeRecord(outputRecord, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRecord(OutputRecord outputRecord, boolean bl) throws IOException {
        block14: while (outputRecord.contentType() == 23) {
            switch (this.getConnectionState()) {
                case 1: {
                    this.performInitialHandshake();
                    continue block14;
                }
                case 2: 
                case 3: {
                    break block14;
                }
                case 4: {
                    this.fatal((byte)0, "error while writing to socket");
                    continue block14;
                }
                case 5: 
                case 6: 
                case 7: {
                    if (this.closeReason != null) {
                        throw this.closeReason;
                    }
                    throw new SocketException("Socket closed");
                }
                default: {
                    throw new SSLProtocolException("State error, send app data");
                }
            }
        }
        if (!outputRecord.isEmpty()) {
            if (outputRecord.isAlert((byte)0) && this.getSoLinger() >= 0) {
                boolean bl2;
                block24: {
                    bl2 = Thread.interrupted();
                    try {
                        if (this.writeLock.tryLock(this.getSoLinger(), TimeUnit.SECONDS)) {
                            try {
                                this.writeRecordInternal(outputRecord, bl);
                                break block24;
                            }
                            finally {
                                this.writeLock.unlock();
                            }
                        }
                        SSLException sSLException = new SSLException("SO_LINGER timeout, close_notify message cannot be sent.");
                        if (this.isLayered() && !this.autoClose) {
                            this.fatal((byte)-1, sSLException);
                        } else if (debug != null && Debug.isOn("ssl")) {
                            System.out.println(Thread.currentThread().getName() + ", received Exception: " + sSLException);
                        }
                        this.sess.invalidate();
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.writeLock.lock();
                try {
                    this.writeRecordInternal(outputRecord, bl);
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
    }

    private void writeRecordInternal(OutputRecord outputRecord, boolean bl) throws IOException {
        outputRecord.encrypt(this.writeAuthenticator, this.writeCipher);
        if (bl) {
            if (this.getTcpNoDelay()) {
                bl = false;
            } else if (this.heldRecordBuffer == null) {
                this.heldRecordBuffer = new ByteArrayOutputStream(40);
            }
        }
        outputRecord.write(this.sockOutput, bl, this.heldRecordBuffer);
        if (this.connectionState < 4) {
            this.checkSequenceNumber(this.writeAuthenticator, outputRecord.contentType());
        }
        if (this.isFirstAppOutputRecord && outputRecord.contentType() == 23) {
            this.isFirstAppOutputRecord = false;
        }
    }

    boolean needToSplitPayload() {
        this.writeLock.lock();
        try {
            boolean bl = this.protocolVersion.v <= ProtocolVersion.TLS10.v && this.writeCipher.isCBCMode() && !this.isFirstAppOutputRecord && Record.enableCBCProtection;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void readDataRecord(InputRecord inputRecord) throws IOException {
        if (this.getConnectionState() == 1) {
            this.performInitialHandshake();
        }
        this.readRecord(inputRecord, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecord(InputRecord inputRecord, boolean bl) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            int n;
            block19: while ((n = this.getConnectionState()) != 6 && n != 4 && n != 7) {
                try {
                    inputRecord.setAppDataValid(false);
                    inputRecord.read(this.sockInput, this.sockOutput);
                }
                catch (SSLProtocolException sSLProtocolException) {
                    try {
                        this.fatal((byte)10, sSLProtocolException);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw sSLProtocolException;
                }
                catch (EOFException eOFException) {
                    boolean bl2;
                    boolean bl3 = this.getConnectionState() <= 1;
                    boolean bl4 = bl2 = requireCloseNotify || bl3;
                    if (debug != null && Debug.isOn("ssl")) {
                        System.out.println(Thread.currentThread().getName() + ", received EOFException: " + (bl2 ? "error" : "ignored"));
                    }
                    if (bl2) {
                        SSLException sSLException = bl3 ? new SSLHandshakeException("Remote host closed connection during handshake") : new SSLProtocolException("Remote host closed connection incorrectly");
                        sSLException.initCause(eOFException);
                        throw sSLException;
                    }
                    this.closeInternal(false);
                    continue;
                }
                try {
                    inputRecord.decrypt(this.readAuthenticator, this.readCipher);
                }
                catch (BadPaddingException badPaddingException) {
                    byte by = inputRecord.contentType() == 22 ? (byte)40 : 20;
                    this.fatal(by, badPaddingException.getMessage(), badPaddingException);
                }
                SSLSocketImpl sSLSocketImpl = this;
                synchronized (sSLSocketImpl) {
                    switch (inputRecord.contentType()) {
                        case 22: {
                            this.initHandshaker();
                            if (!this.handshaker.activated()) {
                                if (this.connectionState == 3) {
                                    this.handshaker.activate(this.protocolVersion);
                                } else {
                                    this.handshaker.activate(null);
                                }
                            }
                            this.handshaker.process_record(inputRecord, this.expectingFinished);
                            this.expectingFinished = false;
                            if (this.handshaker.invalidated) {
                                this.handshaker = null;
                                this.inrec.setHandshakeHash(null);
                                if (this.connectionState == 3) {
                                    this.connectionState = 2;
                                }
                            } else if (this.handshaker.isDone()) {
                                this.secureRenegotiation = this.handshaker.isSecureRenegotiation();
                                this.clientVerifyData = this.handshaker.getClientVerifyData();
                                this.serverVerifyData = this.handshaker.getServerVerifyData();
                                this.applicationProtocol = this.handshaker.getHandshakeApplicationProtocol();
                                this.sess = this.handshaker.getSession();
                                this.handshakeSession = null;
                                this.handshaker = null;
                                this.connectionState = 2;
                                if (this.handshakeListeners != null) {
                                    HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, this.sess);
                                    NotifyHandshakeThread notifyHandshakeThread = new NotifyHandshakeThread(this.handshakeListeners.entrySet(), handshakeCompletedEvent);
                                    notifyHandshakeThread.start();
                                }
                            }
                            if (!bl && this.connectionState == 2) break;
                            continue block19;
                        }
                        case 23: {
                            if (this.connectionState != 2 && this.connectionState != 3 && this.connectionState != 5) {
                                throw new SSLProtocolException("Data received in non-data state: " + this.connectionState);
                            }
                            if (this.expectingFinished) {
                                throw new SSLProtocolException("Expecting finished message, received data");
                            }
                            if (!bl) {
                                throw new SSLException("Discarding app data");
                            }
                            inputRecord.setAppDataValid(true);
                            break;
                        }
                        case 21: {
                            this.recvAlert(inputRecord);
                            continue block19;
                        }
                        case 20: {
                            if (this.connectionState != 1 && this.connectionState != 3) {
                                this.fatal((byte)10, "illegal change cipher spec msg, conn state = " + this.connectionState);
                            } else if (inputRecord.available() != 1 || inputRecord.read() != 1) {
                                this.fatal((byte)10, "Malformed change cipher spec msg");
                            }
                            this.handshaker.receiveChangeCipherSpec();
                            this.changeReadCiphers();
                            this.expectingFinished = true;
                            continue block19;
                        }
                        default: {
                            if (debug != null && Debug.isOn("ssl")) {
                                System.out.println(Thread.currentThread().getName() + ", Received record type: " + inputRecord.contentType());
                            }
                            continue block19;
                        }
                    }
                    if (this.connectionState < 4) {
                        this.checkSequenceNumber(this.readAuthenticator, inputRecord.contentType());
                    }
                    return;
                }
            }
            inputRecord.close();
            return;
        }
    }

    private void checkSequenceNumber(Authenticator authenticator, byte by) throws IOException {
        if (this.connectionState >= 4 || authenticator == MAC.NULL) {
            return;
        }
        if (authenticator.seqNumOverflow()) {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(Thread.currentThread().getName() + ", sequence number extremely close to overflow (2^64-1 packets). Closing connection.");
            }
            this.fatal((byte)40, "sequence number overflow");
        }
        if (by != 22 && authenticator.seqNumIsHuge()) {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(Thread.currentThread().getName() + ", request renegotiation to avoid sequence number overflow");
            }
            this.startHandshake();
        }
    }

    AppInputStream getAppInputStream() {
        return this.input;
    }

    AppOutputStream getAppOutputStream() {
        return this.output;
    }

    private void initHandshaker() {
        switch (this.connectionState) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                return;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        this.connectionState = this.connectionState == 0 ? 1 : 3;
        if (this.roleIsServer) {
            this.handshaker = new ServerHandshaker(this, this.sslContext, this.enabledProtocols, this.doClientAuth, this.protocolVersion, this.connectionState == 1, this.secureRenegotiation, this.clientVerifyData, this.serverVerifyData);
            this.handshaker.setSNIMatchers(this.sniMatchers);
            this.handshaker.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
        } else {
            this.handshaker = new ClientHandshaker(this, this.sslContext, this.enabledProtocols, this.protocolVersion, this.connectionState == 1, this.secureRenegotiation, this.clientVerifyData, this.serverVerifyData);
            this.handshaker.setSNIServerNames(this.serverNames);
        }
        this.handshaker.setEnabledCipherSuites(this.enabledCipherSuites);
        this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        this.handshaker.setApplicationProtocols(this.applicationProtocols);
        this.handshaker.setApplicationProtocolSelectorSSLSocket(this.applicationProtocolSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInitialHandshake() throws IOException {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.getConnectionState() == 1) {
                this.kickstartHandshake();
                if (this.inrec == null) {
                    this.inrec = new InputRecord();
                    this.inrec.setHandshakeHash(this.input.r.getHandshakeHash());
                    this.inrec.setHelloVersion(this.input.r.getHelloVersion());
                    this.inrec.enableFormatChecks();
                }
                this.readRecord(this.inrec, false);
                this.inrec = null;
            }
        }
    }

    @Override
    public void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    private void startHandshake(boolean bl) throws IOException {
        this.checkWrite();
        try {
            if (this.getConnectionState() == 1) {
                this.performInitialHandshake();
            } else {
                this.kickstartHandshake();
            }
        }
        catch (Exception exception) {
            this.handleException(exception, bl);
        }
    }

    private synchronized void kickstartHandshake() throws IOException {
        switch (this.connectionState) {
            case 1: {
                break;
            }
            case 2: {
                if (!this.secureRenegotiation && !Handshaker.allowUnsafeRenegotiation) {
                    throw new SSLHandshakeException("Insecure renegotiation is not allowed");
                }
                if (!this.secureRenegotiation && debug != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: Using insecure renegotiation");
                }
                this.initHandshaker();
                break;
            }
            case 3: {
                return;
            }
            case 0: {
                throw new SocketException("handshaking attempted on unconnected socket");
            }
            default: {
                throw new SocketException("connection is closed");
            }
        }
        if (!this.handshaker.activated()) {
            if (this.connectionState == 3) {
                this.handshaker.activate(this.protocolVersion);
            } else {
                this.handshaker.activate(null);
            }
            if (this.handshaker instanceof ClientHandshaker) {
                this.handshaker.kickstart();
            } else if (this.connectionState != 1) {
                this.handshaker.kickstart();
                this.handshaker.handshakeHash.reset();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.connectionState == 7;
    }

    boolean checkEOF() throws IOException {
        switch (this.getConnectionState()) {
            case 0: {
                throw new SocketException("Socket is not connected");
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
            case 7: {
                throw new SocketException("Socket is closed");
            }
        }
        if (this.closeReason == null) {
            return true;
        }
        SSLException sSLException = new SSLException("Connection has been shutdown: " + this.closeReason);
        sSLException.initCause(this.closeReason);
        throw sSLException;
    }

    void checkWrite() throws IOException {
        if (this.checkEOF() || this.getConnectionState() == 5) {
            throw new SocketException("Connection closed by remote host");
        }
    }

    protected void closeSocket() throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", called closeSocket()");
        }
        super.close();
    }

    private void closeSocket(boolean bl) throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", called closeSocket(" + bl + ")");
        }
        if (!this.isLayered() || this.autoClose) {
            super.close();
        } else if (bl) {
            this.waitForClose(false);
        }
    }

    @Override
    public void close() throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", called close()");
        }
        this.closeInternal(true);
        this.setConnectionState(7);
    }

    /*
     * Exception decompiling
     */
    private void closeInternal(boolean var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 25[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void waitForClose(boolean bl) throws IOException {
        block9: {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(Thread.currentThread().getName() + ", waiting for close_notify or alert: state " + this.getConnectionState());
            }
            try {
                int n;
                while ((n = this.getConnectionState()) != 6 && n != 4 && n != 7) {
                    if (this.inrec == null) {
                        this.inrec = new InputRecord();
                    }
                    try {
                        this.readRecord(this.inrec, true);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        if (debug != null && Debug.isOn("ssl")) {
                            System.out.println(Thread.currentThread().getName() + ", received Exception: " + socketTimeoutException);
                        }
                        this.fatal((byte)-1, "Did not receive close_notify from peer", socketTimeoutException);
                    }
                }
                this.inrec = null;
            }
            catch (IOException iOException) {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(Thread.currentThread().getName() + ", Exception while waiting for close " + iOException);
                }
                if (!bl) break block9;
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeCiphers() {
        Object object = this.readLock;
        synchronized (object) {
            this.readCipher.dispose();
        }
        this.writeLock.lock();
        try {
            this.writeCipher.dispose();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void handleException(Exception exception) throws IOException {
        this.handleException(exception, true);
    }

    private synchronized void handleException(Exception exception, boolean bl) throws IOException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", handling exception: " + exception.toString());
        }
        if (exception instanceof InterruptedIOException && bl) {
            throw (IOException)exception;
        }
        if (this.closeReason != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw Alerts.getSSLException((byte)80, exception, "Unexpected exception");
        }
        boolean bl2 = exception instanceof SSLException;
        if (!bl2 && exception instanceof IOException) {
            try {
                this.fatal((byte)10, exception);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw (IOException)exception;
        }
        byte by = bl2 ? (exception instanceof SSLHandshakeException ? (byte)40 : 10) : (byte)80;
        this.fatal(by, exception);
    }

    void warning(byte by) {
        this.sendAlert((byte)1, by);
    }

    synchronized void fatal(byte by, String string) throws IOException {
        this.fatal(by, string, null);
    }

    synchronized void fatal(byte by, Throwable throwable) throws IOException {
        this.fatal(by, null, throwable);
    }

    synchronized void fatal(byte by, String string, Throwable throwable) throws IOException {
        if (this.input != null && this.input.r != null) {
            this.input.r.close();
        }
        this.sess.invalidate();
        if (this.handshakeSession != null) {
            this.handshakeSession.invalidate();
        }
        int n = this.connectionState;
        if (this.connectionState < 4) {
            this.connectionState = 4;
        }
        if (this.closeReason == null) {
            if (n == 1) {
                this.sockInput.skip(this.sockInput.available());
            }
            if (by != -1) {
                this.sendAlert((byte)2, by);
            }
            this.closeReason = throwable instanceof SSLException ? (SSLException)throwable : Alerts.getSSLException(by, throwable, string);
        }
        this.closeSocket();
        if (this.connectionState < 6) {
            this.connectionState = n == 7 ? 7 : 6;
            this.readCipher.dispose();
            this.writeCipher.dispose();
        }
        throw this.closeReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recvAlert(InputRecord inputRecord) throws IOException {
        Object object;
        byte by = (byte)inputRecord.read();
        byte by2 = (byte)inputRecord.read();
        if (by2 == -1) {
            this.fatal((byte)47, "Short alert message");
        }
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake"))) {
            object = System.out;
            synchronized (object) {
                System.out.print(Thread.currentThread().getName());
                System.out.print(", RECV " + this.protocolVersion + " ALERT:  ");
                if (by == 2) {
                    System.out.print("fatal, ");
                } else if (by == 1) {
                    System.out.print("warning, ");
                } else {
                    System.out.print("<level " + (0xFF & by) + ">, ");
                }
                System.out.println(Alerts.alertDescription(by2));
            }
        }
        if (by == 1) {
            if (by2 == 0) {
                if (this.connectionState == 1) {
                    this.fatal((byte)10, "Received close_notify during handshake");
                } else {
                    this.closeInternal(false);
                }
            } else if (this.handshaker != null) {
                this.handshaker.handshakeAlert(by2);
            }
        } else {
            object = "Received fatal alert: " + Alerts.alertDescription(by2);
            if (this.closeReason == null) {
                this.closeReason = Alerts.getSSLException(by2, (String)object);
            }
            this.fatal((byte)10, (String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlert(byte by, byte by2) {
        block12: {
            boolean bl;
            if (this.connectionState >= 5) {
                return;
            }
            if (!(this.connectionState != 1 || this.handshaker != null && this.handshaker.started())) {
                return;
            }
            OutputRecord outputRecord = new OutputRecord(21);
            outputRecord.setVersion(this.protocolVersion);
            boolean bl2 = bl = debug != null && Debug.isOn("ssl");
            if (bl) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.print(Thread.currentThread().getName());
                    System.out.print(", SEND " + this.protocolVersion + " ALERT:  ");
                    if (by == 2) {
                        System.out.print("fatal, ");
                    } else if (by == 1) {
                        System.out.print("warning, ");
                    } else {
                        System.out.print("<level = " + (0xFF & by) + ">, ");
                    }
                    System.out.println("description = " + Alerts.alertDescription(by2));
                }
            }
            outputRecord.write(by);
            outputRecord.write(by2);
            try {
                this.writeRecord(outputRecord);
            }
            catch (IOException iOException) {
                if (!bl) break block12;
                System.out.println(Thread.currentThread().getName() + ", Exception sending alert: " + iOException);
            }
        }
    }

    private void changeReadCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        CipherBox cipherBox = this.readCipher;
        try {
            this.readCipher = this.handshaker.newReadCipher();
            this.readAuthenticator = this.handshaker.newReadAuthenticator();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SSLException("Algorithm missing:  ", generalSecurityException);
        }
        cipherBox.dispose();
    }

    void changeWriteCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        CipherBox cipherBox = this.writeCipher;
        try {
            this.writeCipher = this.handshaker.newWriteCipher();
            this.writeAuthenticator = this.handshaker.newWriteAuthenticator();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SSLException("Algorithm missing:  ", generalSecurityException);
        }
        cipherBox.dispose();
        this.isFirstAppOutputRecord = true;
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.output.r.setVersion(protocolVersion);
    }

    synchronized String getHost() {
        if (this.host == null || this.host.length() == 0) {
            this.useImplicitHost(true);
        }
        return this.host;
    }

    private synchronized void useImplicitHost(boolean bl) {
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress == null) {
            return;
        }
        JavaNetAccess javaNetAccess = SharedSecrets.getJavaNetAccess();
        String string = javaNetAccess.getOriginalHostName(inetAddress);
        if (string != null && string.length() != 0) {
            this.host = string;
            if (!bl && this.serverNames.isEmpty() && !this.noSniExtension) {
                this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
                if (!this.roleIsServer && this.handshaker != null && !this.handshaker.started()) {
                    this.handshaker.setSNIServerNames(this.serverNames);
                }
            }
            return;
        }
        this.host = !trustNameService ? inetAddress.getHostAddress() : this.getInetAddress().getHostName();
    }

    public synchronized void setHost(String string) {
        this.host = string;
        this.serverNames = Utilities.addToSNIServerNameList(this.serverNames, this.host);
        if (!this.roleIsServer && this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setSNIServerNames(this.serverNames);
        }
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.input;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.connectionState == 0) {
            throw new SocketException("Socket is not connected");
        }
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLSession getSession() {
        block6: {
            if (this.getConnectionState() == 1) {
                try {
                    this.startHandshake(false);
                }
                catch (IOException iOException) {
                    if (debug == null || !Debug.isOn("handshake")) break block6;
                    System.out.println(Thread.currentThread().getName() + ", IOException in getSession():  " + iOException);
                }
            }
        }
        SSLSocketImpl sSLSocketImpl = this;
        synchronized (sSLSocketImpl) {
            return this.sess;
        }
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    synchronized void setHandshakeSession(SSLSessionImpl sSLSessionImpl) {
        this.handshakeSession = sSLSessionImpl;
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        }
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean bl) {
        this.doClientAuth = (byte)(bl ? 2 : 0);
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.activated()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    @Override
    public synchronized void setWantClientAuth(boolean bl) {
        byte by = this.doClientAuth = bl ? (byte)1 : 0;
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.activated()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    @Override
    public synchronized void setUseClientMode(boolean bl) {
        switch (this.connectionState) {
            case 0: {
                if (this.roleIsServer != !bl) {
                    if (this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
                        this.enabledProtocols = this.sslContext.getDefaultProtocolList(!bl);
                    }
                    if (this.sslContext.isDefaultCipherSuiteList(this.enabledCipherSuites)) {
                        this.enabledCipherSuites = this.sslContext.getDefaultCipherSuiteList(!bl);
                    }
                }
                this.roleIsServer = !bl;
                break;
            }
            case 1: {
                assert (this.handshaker != null);
                if (!this.handshaker.activated()) {
                    if (this.roleIsServer != !bl && this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
                        this.enabledProtocols = this.sslContext.getDefaultProtocolList(!bl);
                    }
                    this.roleIsServer = !bl;
                    this.connectionState = 0;
                    this.initHandshaker();
                    break;
                }
            }
            default: {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(Thread.currentThread().getName() + ", setUseClientMode() invoked in state = " + this.connectionState);
                }
                throw new IllegalArgumentException("Cannot change mode after SSL traffic has started");
            }
        }
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return !this.roleIsServer;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslContext.getSupportedCipherSuiteList().toStringArray();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = new CipherSuiteList(stringArray);
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnabledCipherSuites(this.enabledCipherSuites);
        }
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.sslContext.getSuportedProtocolList().toStringArray();
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = new ProtocolList(stringArray);
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setEnabledProtocols(this.enabledProtocols);
        }
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(Thread.currentThread().getName() + ", setSoTimeout(" + n + ") called");
        }
        super.setSoTimeout(n);
    }

    @Override
    public synchronized void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (handshakeCompletedListener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (this.handshakeListeners == null) {
            this.handshakeListeners = new HashMap(4);
        }
        this.handshakeListeners.put(handshakeCompletedListener, AccessController.getContext());
    }

    @Override
    public synchronized void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.handshakeListeners == null) {
            throw new IllegalArgumentException("no listeners");
        }
        if (this.handshakeListeners.remove(handshakeCompletedListener) == null) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (this.handshakeListeners.isEmpty()) {
            this.handshakeListeners = null;
        }
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        sSLParameters.setEndpointIdentificationAlgorithm(this.identificationProtocol);
        sSLParameters.setAlgorithmConstraints(this.algorithmConstraints);
        if (this.sniMatchers.isEmpty() && !this.noSniMatcher) {
            sSLParameters.setSNIMatchers(null);
        } else {
            sSLParameters.setSNIMatchers(this.sniMatchers);
        }
        if (this.serverNames.isEmpty() && !this.noSniExtension) {
            sSLParameters.setServerNames(null);
        } else {
            sSLParameters.setServerNames(this.serverNames);
        }
        sSLParameters.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
        sSLParameters.setApplicationProtocols(this.applicationProtocols);
        return sSLParameters;
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        Collection<SNIMatcher> collection;
        super.setSSLParameters(sSLParameters);
        this.identificationProtocol = sSLParameters.getEndpointIdentificationAlgorithm();
        this.algorithmConstraints = sSLParameters.getAlgorithmConstraints();
        this.preferLocalCipherSuites = sSLParameters.getUseCipherSuitesOrder();
        List<SNIServerName> list = sSLParameters.getServerNames();
        if (list != null) {
            this.noSniExtension = list.isEmpty();
            this.serverNames = list;
        }
        if ((collection = sSLParameters.getSNIMatchers()) != null) {
            this.noSniMatcher = collection.isEmpty();
            this.sniMatchers = collection;
        }
        this.applicationProtocols = sSLParameters.getApplicationProtocols();
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setIdentificationProtocol(this.identificationProtocol);
            this.handshaker.setAlgorithmConstraints(this.algorithmConstraints);
            this.handshaker.setApplicationProtocols(this.applicationProtocols);
            if (this.roleIsServer) {
                this.handshaker.setSNIMatchers(this.sniMatchers);
                this.handshaker.setUseCipherSuitesOrder(this.preferLocalCipherSuites);
            } else {
                this.handshaker.setSNIServerNames(this.serverNames);
            }
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return this.applicationProtocol;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        if (this.handshaker != null && this.handshaker.started()) {
            return this.handshaker.getHandshakeApplicationProtocol();
        }
        return null;
    }

    @Override
    public synchronized void setHandshakeApplicationProtocolSelector(BiFunction<SSLSocket, List<String>, String> biFunction) {
        this.applicationProtocolSelector = biFunction;
        if (this.handshaker != null && !this.handshaker.activated()) {
            this.handshaker.setApplicationProtocolSelectorSSLSocket(biFunction);
        }
    }

    @Override
    public synchronized BiFunction<SSLSocket, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return this.applicationProtocolSelector;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        stringBuffer.append("[");
        stringBuffer.append(this.sess.getCipherSuite());
        stringBuffer.append(": ");
        stringBuffer.append(super.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static class NotifyHandshakeThread
    extends Thread {
        private Set<Map.Entry<HandshakeCompletedListener, AccessControlContext>> targets;
        private HandshakeCompletedEvent event;

        NotifyHandshakeThread(Set<Map.Entry<HandshakeCompletedListener, AccessControlContext>> set, HandshakeCompletedEvent handshakeCompletedEvent) {
            super("HandshakeCompletedNotify-Thread");
            this.targets = new HashSet<Map.Entry<HandshakeCompletedListener, AccessControlContext>>(set);
            this.event = handshakeCompletedEvent;
        }

        @Override
        public void run() {
            for (Map.Entry<HandshakeCompletedListener, AccessControlContext> entry : this.targets) {
                final HandshakeCompletedListener handshakeCompletedListener = entry.getKey();
                AccessControlContext accessControlContext = entry.getValue();
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        handshakeCompletedListener.handshakeCompleted(event);
                        return null;
                    }
                }, accessControlContext);
            }
        }
    }
}

