/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.design.SupportedControl;
import com.jrockit.mc.components.ui.messages.internal.Messages;

public enum LayoutItemType {
    ROWS("mc.flr.rows", Messages.LAYOUT_ITEM_TYPE_ROWS_TEXT, false, false, SupportedControl.MAX_SIZE, SupportedControl.MIN_SIZE, SupportedControl.WEIGHT),
    ROWS_WITH_PADDING("mc.flr.rows.with.padding", Messages.LAYOUT_ITEM_TYPE_ROWS_WITH_PAD_SEPARATION_TEXT, false, true, SupportedControl.MAX_SIZE, SupportedControl.MIN_SIZE, SupportedControl.WEIGHT),
    ROWS_WITH_SASH_SEPARATOR("mc.flr.rows.with.sash", Messages.LAYOUT_ITEM_TYPE_ROWS_WITH_SASH_SEPARATION_TEXT, false, false, SupportedControl.WEIGHT),
    COLUMNS("mc.flr.columns", Messages.LAYOUT_ITEM_TYPE_COLUMNS_TEXT, true, false, SupportedControl.MAX_SIZE, SupportedControl.MIN_SIZE, SupportedControl.WEIGHT),
    COLUMNS_WITHOUT_PADDING("mc.flr.columns.with.padding", Messages.LAYOUT_ITEM_TYPE_COLUMNS_WITH_PAD_SEPARATION_TEXT, true, true, SupportedControl.MAX_SIZE, SupportedControl.MIN_SIZE, SupportedControl.WEIGHT),
    COLUMNS_WITH_SASH_SEPARATOR("mc.flr.columns.with.sash", Messages.LAYOUT_ITEM_TYPE_COLUMNS_WITH_SASH_SEPARATION_TEXT, true, false, SupportedControl.WEIGHT),
    FOLDERS("mc.flr.folders", Messages.LAYOUT_ITEM_TYPE_FOLDERS_TEXT, false, false, new SupportedControl[0]);

    private final String m_identifier;
    private final String m_name;
    private final SupportedControl[] m_supportedControls;
    private final boolean m_horizontal;
    private final boolean m_padding;

    private LayoutItemType(String identifier, String name, boolean horizontal, boolean padding, SupportedControl ... supportedControls) {
        this.m_padding = padding;
        this.m_horizontal = horizontal;
        this.m_identifier = identifier;
        this.m_name = name;
        this.m_supportedControls = supportedControls;
    }

    public SupportedControl[] getSupportedControls() {
        return this.m_supportedControls;
    }

    public boolean getHorizontal() {
        return this.m_horizontal;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public String getName() {
        return this.m_name;
    }

    public static LayoutItemType lookup(String typeIdentifier) {
        LayoutItemType[] layoutItemTypeArray = LayoutItemType.values();
        int n = layoutItemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutItemType type = layoutItemTypeArray[n2];
            if (type.getIdentifier().equals(typeIdentifier)) {
                return type;
            }
            ++n2;
        }
        return ROWS;
    }

    public String toString() {
        return this.m_name;
    }

    public boolean supportsControl(SupportedControl control) {
        SupportedControl[] supportedControlArray = this.m_supportedControls;
        int n = this.m_supportedControls.length;
        int n2 = 0;
        while (n2 < n) {
            SupportedControl sc = supportedControlArray[n2];
            if (sc == control) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean getPadding() {
        return this.m_padding;
    }
}

