/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.accesswidener;

import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.accesswidener.EntryTriple;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public final class AccessWidenerVisitor
extends ClassVisitor {
    private final AccessWidener accessWidener;
    private String className;
    private int classAccess;

    AccessWidenerVisitor(int api, ClassVisitor classVisitor, AccessWidener accessWidener) {
        super(api, classVisitor);
        this.accessWidener = accessWidener;
    }

    public static ClassVisitor createClassVisitor(int api, ClassVisitor visitor, AccessWidener accessWidener) {
        return new AccessWidenerVisitor(api, visitor, accessWidener);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.classAccess = access;
        super.visit(version, this.accessWidener.getClassAccess(name).apply(access, name, this.classAccess), name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, this.accessWidener.getClassAccess(name).apply(access, name, this.classAccess));
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        return super.visitField(this.accessWidener.getFieldAccess(new EntryTriple(this.className, name, descriptor)).apply(access, name, this.classAccess), name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return new AccessWidenerMethodVisitor(super.visitMethod(this.accessWidener.getMethodAccess(new EntryTriple(this.className, name, descriptor)).apply(access, name, this.classAccess), name, descriptor, signature, exceptions));
    }

    private class AccessWidenerMethodVisitor
    extends MethodVisitor {
        AccessWidenerMethodVisitor(MethodVisitor methodVisitor) {
            super(AccessWidenerVisitor.this.api, methodVisitor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            AccessWidener.Access methodAccess;
            if (opcode == 183 && owner.equals(AccessWidenerVisitor.this.className) && !name.equals("<init>") && (methodAccess = AccessWidenerVisitor.this.accessWidener.getMethodAccess(new EntryTriple(owner, name, descriptor))) != AccessWidener.MethodAccess.DEFAULT) {
                opcode = 182;
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }
}

