/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.util.sat4j.core.ASolverFactory;
import net.fabricmc.loader.util.sat4j.core.VecInt;
import net.fabricmc.loader.util.sat4j.specs.ContradictionException;
import net.fabricmc.loader.util.sat4j.specs.ISolver;
import net.fabricmc.loader.util.sat4j.specs.IVecInt;
import net.fabricmc.loader.util.sat4j.specs.TimeoutException;
import net.fabricmc.loader.util.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMUSSolutionListener
implements SolutionFoundListener {
    private List<IVecInt> clauses = new ArrayList<IVecInt>();
    private String explain;
    private final ASolverFactory<? extends ISolver> factory;

    public CheckMUSSolutionListener(ASolverFactory<? extends ISolver> factory) {
        this.factory = factory;
    }

    public void addOriginalClause(IVecInt clause) {
        VecInt newClause = new VecInt(clause.size());
        if (this.clauses == null) {
            this.clauses = new ArrayList<IVecInt>();
        }
        clause.copyTo(newClause);
        this.clauses.add(newClause);
    }

    public boolean checkThatItIsAMUS(IVecInt mus) {
        int i;
        boolean result = false;
        ISolver solver = this.factory.defaultSolver();
        try {
            for (i = 0; i < mus.size(); ++i) {
                solver.addClause(this.clauses.get(mus.get(i) - 1));
            }
            boolean bl = result = !solver.isSatisfiable();
            if (!result) {
                this.explain = "The set of clauses in the MUS is SAT : " + Arrays.toString(solver.model());
                return result;
            }
        }
        catch (ContradictionException e) {
            result = true;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        try {
            for (i = 0; i < mus.size(); ++i) {
                solver = this.factory.defaultSolver();
                for (int j = 0; j < mus.size(); ++j) {
                    if (j == i) continue;
                    solver.addClause(this.clauses.get(mus.get(j) - 1));
                }
                boolean bl = result = result && solver.isSatisfiable();
                if (result) continue;
                this.explain = "The subset of clauses in the MUS not containing clause " + (i + 1) + " is SAT : " + Arrays.toString(solver.model());
                return result;
            }
        }
        catch (ContradictionException e) {
            result = false;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void onSolutionFound(int[] solution) {
    }

    @Override
    public void onSolutionFound(IVecInt solution) {
        if (this.checkThatItIsAMUS(solution)) {
            System.out.println(solution + " is a MUS");
        } else {
            System.out.println(solution + " is not a MUS \n" + this.explain);
        }
    }

    @Override
    public void onUnsatTermination() {
    }
}

