/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.minisat.restarts;

import net.fabricmc.loader.util.sat4j.minisat.core.Constr;
import net.fabricmc.loader.util.sat4j.minisat.core.RestartStrategy;
import net.fabricmc.loader.util.sat4j.minisat.core.SearchParams;
import net.fabricmc.loader.util.sat4j.minisat.core.SolverStats;

public final class MiniSATRestarts
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private double nofConflicts;
    private SearchParams params;
    private int conflictcount;

    public void init(SearchParams theParams, SolverStats stats) {
        this.params = theParams;
        this.nofConflicts = theParams.getInitConflictBound();
        this.conflictcount = 0;
    }

    public long nextRestartNumberOfConflict() {
        return Math.round(this.nofConflicts);
    }

    public void onRestart() {
        this.nofConflicts *= this.params.getConflictBoundIncFactor();
    }

    public String toString() {
        return "MiniSAT restarts strategy";
    }

    public boolean shouldRestart() {
        return (double)this.conflictcount >= this.nofConflicts;
    }

    public void onBackjumpToRootLevel() {
        this.conflictcount = 0;
    }

    public void reset() {
        this.conflictcount = 0;
    }

    public void newConflict() {
        ++this.conflictcount;
    }

    public void newLearnedClause(Constr learned, int trailLevel) {
    }
}

