/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.util.SizeToolkit;
import com.jrockit.mc.common.util.TimeRangeToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRepositoryFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.VolatileStorageDelegate;
import com.jrockit.mc.rjmx.services.flr.EventOptionID;
import com.jrockit.mc.rjmx.services.flr.EventTypeID;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IEventTypeInfo;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IOptionDescriptor;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.services.flr.RecordingOptionsBuilder;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class RecordingWizardModel
extends Observable {
    private static final String DEFAULT_SELECTED_TEMPLATE = "Profiling";
    public static final long DEFAULT_DURATION_MILLIS = 60000L;
    public static final String DEFAULT_DURATION_STRING = TimeRangeToolkit.convertMillisToNormalizedString((long)60000L, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.LOCALIZED);
    public static final long DEFAULT_DELAY_MILLIS = 0L;
    public static final String DEFAULT_DELAY_STRING = TimeRangeToolkit.convertMillisToNormalizedString((long)0L, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.LOCALIZED);
    public static final String NO_MAX_SIZE_STRING = "";
    public static final String NO_MAX_AGE_STRING = "";
    public static final long NO_MAX_SIZE_BYTES = 0L;
    public static final long NO_MAX_AGE_MILLIS = 0L;
    private static final Pattern NOT_ALLOWED_IN_NAME = Pattern.compile("[=:;,]");
    private static final long SECOND_IN_MILLIS = 1000L;
    private final boolean m_editing;
    private final RecordingTemplateRepository m_templateRepository;
    private MCFile m_path;
    private String m_name;
    protected boolean m_fixedRecording;
    private String m_durationString;
    private String m_delayString;
    private String m_maxSizeString;
    private String m_maxAgeString;
    private final Map<String, IOptionDescriptor> m_recordingOptions;
    private final IEventSettingsHolder m_initiallyActiveEventSettings;
    private final Map<EventTypeID, IEventTypeInfo> m_eventTypeInfos;
    private final List<IRecordingConfiguration> m_activeConfigStack = new ArrayList<IRecordingConfiguration>();
    private static final long INVALID_DURATION = Long.MIN_VALUE;
    private static final long INVALID_DELAY = Long.MIN_VALUE;
    private static final long INVALID_MAX_SIZE = Long.MIN_VALUE;
    private static final long INVALID_MAX_AGE = Long.MIN_VALUE;

    private RecordingWizardModel(IFlightRecorderService flrService, boolean editing, MCFile path) {
        Map recordingOptions = Collections.emptyMap();
        Map eventTypeInfos = Collections.emptyMap();
        IEventSettingsHolder settingsHolder = null;
        try {
            recordingOptions = flrService.getAvailableRecordingOptions();
            eventTypeInfos = flrService.getEventTypeInfoMapByID();
            settingsHolder = flrService.getCurrentEventTypeSettings();
        }
        catch (FlightRecorderException e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not get initial state from flight recorder", e);
        }
        this.m_eventTypeInfos = eventTypeInfos;
        this.m_initiallyActiveEventSettings = settingsHolder;
        this.m_recordingOptions = recordingOptions;
        this.m_templateRepository = this.createRepository(flrService);
        this.m_editing = editing;
        this.m_path = path;
    }

    public RecordingWizardModel(IFlightRecorderService flrService, MCFile filename) {
        this(flrService, false, filename);
        this.m_name = this.getDefaultName(flrService);
        this.m_durationString = DEFAULT_DURATION_STRING;
        this.m_delayString = DEFAULT_DELAY_STRING;
        this.m_maxSizeString = "";
        this.m_maxAgeString = "";
        this.m_fixedRecording = this.getDuration() > 0L;
        this.initActive();
    }

    private void initActive() {
        if (!this.m_templateRepository.isEmpty()) {
            List<IRecordingConfiguration> templates = this.m_templateRepository.getAllTemplates();
            IRecordingConfiguration best = templates.get(0);
            for (IRecordingConfiguration config : templates) {
                if (!DEFAULT_SELECTED_TEMPLATE.equals(config.getName()) || !Messages.VOLATILE_CONFIGURATION_ON_SERVER.equals(config.getLocationInfo())) continue;
                best = config;
                break;
            }
            for (IRecordingConfiguration config : templates) {
                if (!Messages.VOLATILE_CONFIGURATION_LAST_STARTED.equals(config.getLocationInfo())) continue;
                best = config;
            }
            this.setActiveConfigurationTemplate(best);
        }
    }

    public RecordingWizardModel(IFlightRecorderService flrService, IRecordingDescriptor recordingDescriptor, MCFile filename) {
        this(flrService, true, filename);
        this.setActiveConfigurationTemplate(this.createRunningConfig(flrService, recordingDescriptor));
        this.m_templateRepository.notifyObservers();
        this.m_name = recordingDescriptor.getName();
        this.setDuration(recordingDescriptor.getDuration());
        this.setMaxSize(recordingDescriptor.getMaxSize());
        this.setMaxAge(recordingDescriptor.getMaxAge());
        this.m_fixedRecording = this.getDuration() > 0L;
    }

    private IRecordingConfiguration createRunningConfig(IFlightRecorderService flrService, IRecordingDescriptor recordingDescriptor) {
        IRecordingConfiguration config = RecordingTemplate.createEmpty(VolatileStorageDelegate.getRunningRecordingDelegate());
        try {
            IEventSettingsHolder settings = flrService.getEventSettings(recordingDescriptor);
            for (Map.Entry entry : settings.getEventOptions().entrySet()) {
                config.setOption((EventOptionID)entry.getKey(), ((IConvertibleValue)entry.getValue()).toConfigString());
            }
            config.setName(recordingDescriptor.getName());
        }
        catch (FlightRecorderException flightRecorderException) {
            // empty catch block
        }
        config.setDescription(Messages.EDIT_RECORDING_WIZARD_RUNNING_CONFIGURATION_DESCRIPTION);
        this.m_templateRepository.add(config);
        return config;
    }

    private RecordingTemplateRepository createRepository(IFlightRecorderService flrService) {
        RecordingTemplateRepository repo = this.createRepository();
        try {
            for (String templateXML : flrService.getServerTemplates()) {
                try {
                    repo.add(new RecordingTemplate(RecordingTemplate.createModel(templateXML), VolatileStorageDelegate.getOnServerDelegate()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FlightRecorderException e) {
            e.printStackTrace();
        }
        repo.notifyObservers();
        return repo;
    }

    protected RecordingTemplateRepository createRepository() {
        RecordingTemplateRepository repo = TemplateRepositoryFactory.create();
        repo.setPrototypeTemplate(RecordingTemplate.createEmpty(VolatileStorageDelegate.getWorkingCopyDelegate()));
        return repo;
    }

    public IEventSettingsHolder getInitialEventTypeSettings() {
        return this.m_initiallyActiveEventSettings;
    }

    public Map<EventTypeID, IEventTypeInfo> getEventTypeInfoMap() {
        return this.m_eventTypeInfos;
    }

    private String getDefaultName(IFlightRecorderService flrService) {
        boolean hasFoundUniqueName = false;
        String name = Messages.RECORDING_DESCRIPTOR_DEFAULT_NAME;
        List<IRecordingDescriptor> descriptors = this.getDescriptors(flrService);
        if (descriptors == null) {
            return name;
        }
        int count = 2;
        while (!hasFoundUniqueName) {
            try {
                boolean exists = this.existsRecordingName(descriptors, name);
                if (exists) {
                    name = String.valueOf(Messages.RECORDING_DESCRIPTOR_DEFAULT_NAME) + ' ' + count++;
                    continue;
                }
                hasFoundUniqueName = true;
            }
            catch (Exception e) {
                break;
            }
        }
        return name;
    }

    private boolean existsRecordingName(List<IRecordingDescriptor> descriptors, String name) {
        for (IRecordingDescriptor descriptor : descriptors) {
            if (!name.equals(descriptor.getName())) continue;
            return true;
        }
        return false;
    }

    private List<IRecordingDescriptor> getDescriptors(IFlightRecorderService flrService) {
        try {
            return flrService.getAvailableRecordings();
        }
        catch (FlightRecorderException e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not retrieve recording descriptors!", e);
            return null;
        }
    }

    public MCFile getPath() {
        return this.m_path;
    }

    public boolean isFixedRecording() {
        return this.m_fixedRecording;
    }

    public boolean isContinuous() {
        return !this.isFixedRecording();
    }

    private void setDuration(long millis) {
        this.setDuration(TimeRangeToolkit.convertMillisToNormalizedString((long)millis, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.LOCALIZED));
    }

    public String getDurationString() {
        return this.m_durationString;
    }

    public long getDuration() {
        try {
            return TimeRangeToolkit.parseMillis((String)this.m_durationString);
        }
        catch (QuantityConversionException e) {
            return Long.MIN_VALUE;
        }
    }

    public long getDelay() {
        try {
            return TimeRangeToolkit.parseMillis((String)this.m_delayString);
        }
        catch (QuantityConversionException e) {
            return Long.MIN_VALUE;
        }
    }

    public String getDelayString() {
        return this.m_delayString;
    }

    public long getMaxSize() {
        try {
            return this.m_maxSizeString.length() > 0 ? SizeToolkit.parseBytes((String)this.m_maxSizeString) : 0L;
        }
        catch (QuantityConversionException e) {
            return Long.MIN_VALUE;
        }
    }

    public String getMaxAgeString() {
        return this.m_maxAgeString;
    }

    public long getMaxAge() {
        try {
            return this.m_maxAgeString.length() > 0 ? TimeRangeToolkit.parseMillis((String)this.m_maxAgeString) : 0L;
        }
        catch (QuantityConversionException e) {
            return Long.MIN_VALUE;
        }
    }

    public String getMaxSizeString() {
        return this.m_maxSizeString;
    }

    public Map<String, Object> buildOptions() {
        RecordingOptionsBuilder builder = new RecordingOptionsBuilder().name(this.getName());
        if (this.isFixedRecording()) {
            builder.duration(this.getDuration()).maxSize(0L).maxAge(0L).toDisk(true);
        } else {
            builder.duration(0L);
            if (this.hasMaxSize()) {
                builder.maxSize(this.getMaxSize());
            }
            if (this.hasMaxAge()) {
                builder.maxAge(this.getMaxAge());
            }
        }
        return builder.build();
    }

    public IRecordingConfiguration getAndSaveActiveConfiguration() {
        IRecordingConfiguration config = this.getActiveConfiguration();
        if (config != null) {
            IRecordingConfiguration lastStarted = config.createWorkingCopy();
            if (this.getName() != null) {
                String name = NLS.bind((String)Messages.RECORDING_WIZARD_LAST_STARTED_SETTINGS_FOR_NAME_MSG, (Object)this.getName());
                lastStarted.setName(name);
            }
            if (this.getPath() != null) {
                String desc = NLS.bind((String)Messages.RECORDING_WIZARD_LAST_STARTED_DESCRIPTION_MSG, (Object)this.getPath().getPath());
                lastStarted.setDescription(desc);
            }
            TemplateRepositoryFactory.saveAsLastStarted(lastStarted);
        }
        return config;
    }

    public void setActiveConfigurationTemplate(IRecordingConfiguration template) {
        if (template != null) {
            this.m_activeConfigStack.clear();
            this.m_activeConfigStack.add(template);
            this.onChange();
        }
    }

    public IRecordingConfiguration getActiveConfiguration() {
        if (!this.m_activeConfigStack.isEmpty()) {
            return this.m_activeConfigStack.get(this.m_activeConfigStack.size() - 1);
        }
        return null;
    }

    public IRecordingConfiguration getCurrentConfigurationAt(int wizardStage) {
        if (this.m_activeConfigStack.size() > wizardStage) {
            return this.m_activeConfigStack.get(wizardStage);
        }
        if (this.m_activeConfigStack.isEmpty()) {
            return null;
        }
        if (wizardStage > 0) {
            IRecordingConfiguration base = this.getCurrentConfigurationAt(wizardStage - 1);
            assert (this.m_activeConfigStack.size() == wizardStage);
            IRecordingConfiguration derived = base.createWorkingCopy();
            this.m_activeConfigStack.add(derived);
            return derived;
        }
        return null;
    }

    public void flushConfigurationsBeyond(int wizardStage) {
        int maxSize = wizardStage + 1;
        while (this.m_activeConfigStack.size() > maxSize) {
            this.m_activeConfigStack.remove(maxSize);
        }
    }

    public boolean isEditing() {
        return this.m_editing;
    }

    private void setMaxSize(long maxSize) {
        this.setMaxSize(maxSize == 0L ? "" : SizeToolkit.convertBytesToString((long)maxSize, (SizeToolkit.Format)SizeToolkit.Format.LOCALIZED));
    }

    public void setMaxSize(String maxSizeText) {
        this.m_maxSizeString = maxSizeText;
        this.onChange();
    }

    private void setMaxAge(long maxAge) {
        this.setMaxAge(maxAge == 0L ? "" : TimeRangeToolkit.convertMillisToNormalizedString((long)maxAge, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.LOCALIZED));
    }

    public void setMaxAge(String maxAgeText) {
        this.m_maxAgeString = maxAgeText;
        this.onChange();
    }

    public String getName() {
        return this.m_name;
    }

    public RecordingTemplateRepository getTemplateRepository() {
        return this.m_templateRepository;
    }

    public void setPath(MCFile path) {
        this.m_path = path;
        this.onChange();
    }

    public void setName(String name) {
        this.m_name = name;
        this.onChange();
    }

    public void setFixedRecording(boolean fixedRecording) {
        this.m_fixedRecording = fixedRecording;
        this.onChange();
    }

    public boolean hasMaxSize() {
        return this.getMaxSize() > 0L;
    }

    public boolean hasMaxAge() {
        return this.getMaxAge() > 0L;
    }

    public void setDuration(String durationText) {
        this.m_durationString = durationText;
        this.onChange();
    }

    public void setDelay(String delayText) {
        this.m_delayString = delayText;
        this.onChange();
    }

    public Map<String, IOptionDescriptor> getAvailableRecordingOptions() {
        return this.m_recordingOptions;
    }

    protected void onChange() {
        this.setChanged();
        this.notifyObservers();
    }

    protected String checkForErrors() {
        IStatus validation;
        if (this.m_fixedRecording && this.m_delayString != null) {
            try {
                long delay = TimeRangeToolkit.parseMillis((String)this.m_delayString);
                if (delay == Long.MIN_VALUE) {
                    return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_DELAY_TIME_ERROR_MSG, (Object)this.m_delayString);
                }
                if (delay != 0L && delay < 1000L) {
                    return Messages.RECORDING_WIZARD_PAGE_DELAY_TIME_MIN_1_SECOND;
                }
            }
            catch (QuantityConversionException e) {
                return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_DELAY_TIME_ERROR_MSG, (Object)e.getLocalizedMessage());
            }
        }
        if (this.m_fixedRecording && this.m_durationString != null) {
            try {
                long duration = TimeRangeToolkit.parseMillis((String)this.m_durationString);
                if (duration == Long.MIN_VALUE) {
                    return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_RECORDING_TIME_ERROR_MSG, (Object)this.m_durationString);
                }
                if (duration < 1000L) {
                    return Messages.RECORDING_WIZARD_PAGE_RECORDING_TIME_GTEQ_ONE_SECOND;
                }
            }
            catch (QuantityConversionException e) {
                return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_RECORDING_TIME_ERROR_MSG, (Object)e.getLocalizedMessage());
            }
        }
        if (this.m_name.length() == 0) {
            return Messages.RECORDING_WIZARD_PAGE_RECORDING_NAME_ERROR_MSG;
        }
        if (NOT_ALLOWED_IN_NAME.matcher(this.m_name).find()) {
            return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_RECORDING_NAME_INVALID_CHARS, (Object)NOT_ALLOWED_IN_NAME);
        }
        if (this.getActiveConfiguration() == null) {
            return Messages.RECORDING_WIZARD_PAGE_NO_TEMPLATE_SELECTED_ERROR_MSG;
        }
        if (!this.m_fixedRecording && this.m_maxSizeString != null && this.m_maxSizeString.length() != 0) {
            try {
                long maxSize = SizeToolkit.parseBytes((String)this.m_maxSizeString);
                if (maxSize == Long.MIN_VALUE) {
                    return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_SIZE_ERROR_MSG, (Object)this.m_maxSizeString);
                }
                if (maxSize < 0L) {
                    return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_SIZE_ERROR_MSG, (Object)(String.valueOf(maxSize) + " < 0"));
                }
            }
            catch (QuantityConversionException e) {
                return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_SIZE_ERROR_MSG, (Object)e.getLocalizedMessage());
            }
        }
        if (!this.m_fixedRecording && this.m_maxAgeString != null && this.m_maxAgeString.length() != 0) {
            try {
                long maxAge = TimeRangeToolkit.parseMillis((String)this.m_maxAgeString);
                if (maxAge == Long.MIN_VALUE) {
                    return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_AGE_ERROR_MSG, (Object)this.m_maxAgeString);
                }
                if (maxAge < 0L) {
                    return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_AGE_ERROR_MSG, (Object)(String.valueOf(maxAge) + " < 0"));
                }
            }
            catch (QuantityConversionException e) {
                return NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_AGE_ERROR_MSG, (Object)e.getLocalizedMessage());
            }
        }
        if ((validation = IDESupportToolkit.validateFileResourcePath((String)this.m_path.getPath())).getSeverity() == 4) {
            return validation.getMessage();
        }
        return null;
    }

    public String getWarningMessage() {
        IStatus validation = IDESupportToolkit.validateFileResourcePath((String)this.m_path.getPath());
        return ControlPanel.getRecordingFileValidationMessage(validation);
    }
}

