/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.tinyremapper.AsmClassRemapper;
import net.fabricmc.tinyremapper.AsmRemapper;
import net.fabricmc.tinyremapper.ClassInstance;
import net.fabricmc.tinyremapper.FileSystemHandler;
import net.fabricmc.tinyremapper.IMappingProvider;
import net.fabricmc.tinyremapper.InputTag;
import net.fabricmc.tinyremapper.MemberInstance;
import net.fabricmc.tinyremapper.SourceNameRebuildVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;

public class TinyRemapper {
    private final boolean check = false;
    private final boolean keepInputData;
    final Set<String> forcePropagation;
    final boolean propagatePrivate;
    private final boolean removeFrames;
    private final boolean ignoreConflicts;
    private final boolean resolveMissing;
    private final boolean checkPackageAccess;
    private final boolean fixPackageAccess;
    private final boolean rebuildSourceFilenames;
    private final boolean skipLocalMapping;
    private final boolean renameInvalidLocals;
    private final ClassVisitor extraAnalyzeVisitor;
    final Remapper extraRemapper;
    final AtomicReference<Map<InputTag, InputTag[]>> singleInputTags = new AtomicReference(Collections.emptyMap());
    final List<CompletableFuture<?>> pendingReads = new ArrayList();
    final Map<String, ClassInstance> readClasses = new ConcurrentHashMap<String, ClassInstance>();
    final Map<String, String> classMap = new HashMap<String, String>();
    final Map<String, String> methodMap = new HashMap<String, String>();
    final Map<String, String> methodArgMap = new HashMap<String, String>();
    final Map<String, String> fieldMap = new HashMap<String, String>();
    final Map<String, ClassInstance> classes = new HashMap<String, ClassInstance>();
    final Map<MemberInstance, Set<String>> conflicts = new ConcurrentHashMap<MemberInstance, Set<String>>();
    final Set<ClassInstance> classesToMakePublic = Collections.newSetFromMap(new ConcurrentHashMap());
    final Set<MemberInstance> membersToMakePublic = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<IMappingProvider> mappingProviders;
    final boolean ignoreFieldDesc;
    private final int threadCount;
    private final ExecutorService threadPool;
    private final AsmRemapper remapper = new AsmRemapper(this);
    private boolean dirty = true;
    private Map<ClassInstance, byte[]> outputBuffer;

    private TinyRemapper(Collection<IMappingProvider> mappingProviders, boolean ignoreFieldDesc, int threadCount, boolean keepInputData, Set<String> forcePropagation, boolean propagatePrivate, boolean removeFrames, boolean ignoreConflicts, boolean resolveMissing, boolean checkPackageAccess, boolean fixPackageAccess, boolean rebuildSourceFilenames, boolean skipLocalMapping, boolean renameInvalidLocals, ClassVisitor extraAnalyzeVisitor, Remapper extraRemapper) {
        this.mappingProviders = mappingProviders;
        this.ignoreFieldDesc = ignoreFieldDesc;
        this.threadCount = threadCount > 0 ? threadCount : Math.max(Runtime.getRuntime().availableProcessors(), 2);
        this.keepInputData = keepInputData;
        this.threadPool = Executors.newFixedThreadPool(this.threadCount);
        this.forcePropagation = forcePropagation;
        this.propagatePrivate = propagatePrivate;
        this.removeFrames = removeFrames;
        this.ignoreConflicts = ignoreConflicts;
        this.resolveMissing = resolveMissing;
        this.checkPackageAccess = checkPackageAccess;
        this.fixPackageAccess = fixPackageAccess;
        this.rebuildSourceFilenames = rebuildSourceFilenames;
        this.skipLocalMapping = skipLocalMapping;
        this.renameInvalidLocals = renameInvalidLocals;
        this.extraAnalyzeVisitor = extraAnalyzeVisitor;
        this.extraRemapper = extraRemapper;
    }

    public static Builder newRemapper() {
        return new Builder();
    }

    public void finish() {
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.outputBuffer = null;
        this.classes.clear();
    }

    public InputTag createInputTag() {
        IdentityHashMap<InputTag, InputTag[]> newTags;
        Map<InputTag, InputTag[]> oldTags;
        InputTag ret = new InputTag();
        InputTag[] array = new InputTag[]{ret};
        do {
            oldTags = this.singleInputTags.get();
            newTags = new IdentityHashMap<InputTag, InputTag[]>(oldTags.size() + 1);
            newTags.putAll(oldTags);
            newTags.put(ret, array);
        } while (!this.singleInputTags.compareAndSet(oldTags, newTags));
        return ret;
    }

    public void readInputs(Path ... inputs) {
        this.readInputs((InputTag)null, inputs);
    }

    public void readInputs(InputTag tag, Path ... inputs) {
        this.read(inputs, true, tag).join();
    }

    public CompletableFuture<?> readInputsAsync(Path ... inputs) {
        return this.readInputsAsync((InputTag)null, inputs);
    }

    public CompletableFuture<?> readInputsAsync(InputTag tag, Path ... inputs) {
        CompletableFuture<List<ClassInstance>> ret = this.read(inputs, true, tag);
        if (!ret.isDone()) {
            this.pendingReads.add(ret);
        }
        return ret;
    }

    public void readClassPath(Path ... inputs) {
        this.read(inputs, false, null).join();
    }

    public CompletableFuture<?> readClassPathAsync(Path ... inputs) {
        CompletableFuture<List<ClassInstance>> ret = this.read(inputs, false, null);
        if (!ret.isDone()) {
            this.pendingReads.add(ret);
        }
        return ret;
    }

    private CompletableFuture<List<ClassInstance>> read(Path[] inputs, boolean isInput, InputTag tag) {
        InputTag[] tags = this.singleInputTags.get().get(tag);
        ArrayList<CompletableFuture<List<ClassInstance>>> futures = new ArrayList<CompletableFuture<List<ClassInstance>>>();
        List<FileSystem> fsToClose = Collections.synchronizedList(new ArrayList());
        for (Path input : inputs) {
            futures.addAll(this.read(input, isInput, tags, true, fsToClose));
        }
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletionStage ret = futures.size() == 1 ? (CompletableFuture)futures.get(0) : CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignore -> futures.stream().flatMap(f -> ((List)f.join()).stream()).collect(Collectors.toList()));
        this.dirty = true;
        return ret.whenComplete((res, exc) -> {
            for (FileSystem fs : fsToClose) {
                try {
                    FileSystemHandler.close(fs);
                }
                catch (IOException iOException) {}
            }
            for (ClassInstance node : res) {
                TinyRemapper.addClass(node, this.readClasses);
            }
        });
    }

    private static void addClass(ClassInstance cls, Map<String, ClassInstance> out) {
        ClassInstance prev;
        block2: {
            String name = cls.getName();
            do {
                if ((prev = out.putIfAbsent(name, cls)) == null) {
                    return;
                }
                if (!cls.isInput) break block2;
                if (!prev.isInput) continue;
                System.out.printf("duplicate input class %s, from %s and %s%n", name, prev.srcPath, cls.srcPath);
                prev.addInputTags(cls.getInputTags());
                return;
            } while (!out.replace(name, prev, cls));
            cls.addInputTags(prev.getInputTags());
            return;
        }
        prev.addInputTags(cls.getInputTags());
    }

    private List<CompletableFuture<List<ClassInstance>>> read(Path file, boolean isInput, InputTag[] tags, boolean saveData, List<FileSystem> fsToClose) {
        try {
            return this.read(file, isInput, tags, file, saveData, fsToClose);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<CompletableFuture<List<ClassInstance>>> read(Path file, final boolean isInput, final InputTag[] tags, final Path srcPath, final boolean saveData, final List<FileSystem> fsToClose) throws IOException {
        final ArrayList<CompletableFuture<List<ClassInstance>>> ret = new ArrayList<CompletableFuture<List<ClassInstance>>>();
        Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(final Path file, BasicFileAttributes attrs) throws IOException {
                String name = file.getFileName().toString();
                if (name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".class")) {
                    ret.add(CompletableFuture.supplyAsync(new Supplier<List<ClassInstance>>(){

                        @Override
                        public List<ClassInstance> get() {
                            try {
                                return TinyRemapper.this.readFile(file, isInput, tags, srcPath, saveData, fsToClose);
                            }
                            catch (URISyntaxException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IOException e) {
                                System.out.println(file.toAbsolutePath());
                                e.printStackTrace();
                                return Collections.emptyList();
                            }
                        }
                    }, TinyRemapper.this.threadPool));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return ret;
    }

    private List<ClassInstance> readFile(Path file, final boolean isInput, final InputTag[] tags, final Path srcPath, final boolean saveData, List<FileSystem> fsToClose) throws IOException, URISyntaxException {
        final ArrayList<ClassInstance> ret = new ArrayList<ClassInstance>();
        if (file.toString().endsWith(".class")) {
            ClassInstance res = this.analyze(isInput, tags, srcPath, Files.readAllBytes(file), saveData);
            if (res != null) {
                ret.add(res);
            }
        } else {
            URI uri = new URI("jar:" + file.toUri().toString());
            FileSystem fs = FileSystemHandler.open(uri);
            fsToClose.add(fs);
            Files.walkFileTree(fs.getPath("/", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    ClassInstance res;
                    if (file.toString().endsWith(".class") && (res = TinyRemapper.this.analyze(isInput, tags, srcPath, Files.readAllBytes(file), saveData)) != null) {
                        ret.add(res);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return ret;
    }

    private ClassInstance analyze(boolean isInput, InputTag[] tags, Path srcPath, byte[] data, boolean saveData) {
        ClassReader reader = new ClassReader(data);
        if ((reader.getAccess() & 0x8000) != 0) {
            return null;
        }
        final ClassInstance ret = new ClassInstance(this, isInput, tags, srcPath, (byte[])(saveData ? data : null));
        reader.accept(new ClassVisitor(524288, this.extraAnalyzeVisitor){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                ret.init(name, superName, access, interfaces);
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MemberInstance prev = ret.addMember(new MemberInstance(MemberInstance.MemberType.METHOD, ret, name, desc, access));
                if (prev != null) {
                    throw new RuntimeException(String.format("duplicate method %s/%s%s in inputs", ret.getName(), name, desc));
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                MemberInstance prev = ret.addMember(new MemberInstance(MemberInstance.MemberType.FIELD, ret, name, desc, access));
                if (prev != null) {
                    throw new RuntimeException(String.format("duplicate field %s/%s;;%s in inputs", ret.getName(), name, desc));
                }
                return super.visitField(access, name, desc, signature, value);
            }
        }, 7);
        return ret;
    }

    String mapClass(String className) {
        return this.remapper.map(className);
    }

    private void loadMappings() {
        IMappingProvider.MappingAcceptor acceptor = new IMappingProvider.MappingAcceptor(){

            @Override
            public void acceptClass(String srcName, String dstName) {
                if (srcName == null) {
                    throw new NullPointerException("null src name");
                }
                if (dstName == null) {
                    throw new NullPointerException("null dst name");
                }
                TinyRemapper.this.classMap.put(srcName, dstName);
            }

            @Override
            public void acceptMethod(IMappingProvider.Member method, String dstName) {
                if (method == null) {
                    throw new NullPointerException("null src method");
                }
                if (method.owner == null) {
                    throw new NullPointerException("null src method owner");
                }
                if (method.name == null) {
                    throw new NullPointerException("null src method name");
                }
                if (method.desc == null) {
                    throw new NullPointerException("null src method desc");
                }
                if (dstName == null) {
                    throw new NullPointerException("null dst name");
                }
                TinyRemapper.this.methodMap.put(method.owner + "/" + MemberInstance.getMethodId(method.name, method.desc), dstName);
            }

            @Override
            public void acceptMethodArg(IMappingProvider.Member method, int lvIndex, String dstName) {
                if (method == null) {
                    throw new NullPointerException("null src method");
                }
                if (method.owner == null) {
                    throw new NullPointerException("null src method owner");
                }
                if (method.name == null) {
                    throw new NullPointerException("null src method name");
                }
                if (method.desc == null) {
                    throw new NullPointerException("null src method desc");
                }
                if (dstName == null) {
                    throw new NullPointerException("null dst name");
                }
                TinyRemapper.this.methodArgMap.put(method.owner + "/" + MemberInstance.getMethodId(method.name, method.desc) + lvIndex, dstName);
            }

            @Override
            public void acceptMethodVar(IMappingProvider.Member method, int lvIndex, int startOpIdx, int asmIndex, String dstName) {
                if (method == null) {
                    throw new NullPointerException("null src method");
                }
                if (method.owner == null) {
                    throw new NullPointerException("null src method owner");
                }
                if (method.name == null) {
                    throw new NullPointerException("null src method name");
                }
                if (method.desc == null) {
                    throw new NullPointerException("null src method desc");
                }
                if (dstName == null) {
                    throw new NullPointerException("null dst name");
                }
            }

            @Override
            public void acceptField(IMappingProvider.Member field, String dstName) {
                if (field == null) {
                    throw new NullPointerException("null src field");
                }
                if (field.owner == null) {
                    throw new NullPointerException("null src field owner");
                }
                if (field.name == null) {
                    throw new NullPointerException("null src field name");
                }
                if (field.desc == null && !TinyRemapper.this.ignoreFieldDesc) {
                    throw new NullPointerException("null src field desc");
                }
                if (dstName == null) {
                    throw new NullPointerException("null dst name");
                }
                TinyRemapper.this.fieldMap.put(field.owner + "/" + MemberInstance.getFieldId(field.name, field.desc, TinyRemapper.this.ignoreFieldDesc), dstName);
            }
        };
        for (IMappingProvider provider : this.mappingProviders) {
            provider.load(acceptor);
        }
    }

    private void checkClassMappings() {
        HashSet<String> testSet = new HashSet<String>(this.classMap.values());
        if (testSet.size() != this.classMap.size()) {
            HashSet<String> duplicates = new HashSet<String>();
            for (String name : this.classMap.values()) {
                if (testSet.remove(name)) continue;
                duplicates.add(name);
            }
            System.out.println("non-unique class target name mappings:");
            for (String target : duplicates) {
                System.out.print("  [");
                boolean first = true;
                for (Map.Entry<String, String> e : this.classMap.entrySet()) {
                    if (!e.getValue().equals(target)) continue;
                    if (first) {
                        first = false;
                    } else {
                        System.out.print(", ");
                    }
                    System.out.print(e.getKey());
                }
                System.out.printf("] -> %s%n", target);
            }
            throw new RuntimeException("duplicate class target name mappings detected");
        }
    }

    private void merge() {
        for (ClassInstance node : this.classes.values()) {
            assert (node.getSuperName() != null);
            ClassInstance parent = this.classes.get(node.getSuperName());
            if (parent != null) {
                node.parents.add(parent);
                parent.children.add(node);
            }
            for (String iface : node.getInterfaces()) {
                parent = this.classes.get(iface);
                if (parent == null) continue;
                node.parents.add(parent);
                parent.children.add(node);
            }
        }
    }

    private void propagate() {
        ArrayList futures = new ArrayList();
        ArrayList<Map.Entry<String, String>> tasks = new ArrayList<Map.Entry<String, String>>();
        int maxTasks = this.methodMap.size() / this.threadCount / 4;
        for (Map.Entry<String, String> entry : this.methodMap.entrySet()) {
            tasks.add(entry);
            if (tasks.size() < maxTasks) continue;
            futures.add(this.threadPool.submit(new Propagation(MemberInstance.MemberType.METHOD, tasks)));
            tasks.clear();
        }
        futures.add(this.threadPool.submit(new Propagation(MemberInstance.MemberType.METHOD, tasks)));
        tasks.clear();
        for (Map.Entry<String, String> entry : this.fieldMap.entrySet()) {
            tasks.add(entry);
            if (tasks.size() < maxTasks) continue;
            futures.add(this.threadPool.submit(new Propagation(MemberInstance.MemberType.FIELD, tasks)));
            tasks.clear();
        }
        futures.add(this.threadPool.submit(new Propagation(MemberInstance.MemberType.FIELD, tasks)));
        tasks.clear();
        TinyRemapper.waitForAll(futures);
        this.handleConflicts();
    }

    private void handleConflicts() {
        HashSet<String> testSet = new HashSet<String>();
        boolean targetNameCheckFailed = false;
        for (ClassInstance cls : this.classes.values()) {
            for (MemberInstance memberInstance : cls.getMembers()) {
                String name = memberInstance.getNewName();
                if (name == null) {
                    name = memberInstance.name;
                }
                testSet.add(MemberInstance.getId(memberInstance.type, name, memberInstance.desc, this.ignoreFieldDesc));
            }
            if (testSet.size() != cls.getMembers().size()) {
                if (!targetNameCheckFailed) {
                    targetNameCheckFailed = true;
                    System.out.println("Mapping target name conflicts detected:");
                }
                HashMap<String, List> duplicates = new HashMap<String, List>();
                for (MemberInstance member3 : cls.getMembers()) {
                    String name = member3.getNewName();
                    if (name == null) {
                        name = member3.name;
                    }
                    duplicates.computeIfAbsent(MemberInstance.getId(member3.type, name, member3.desc, this.ignoreFieldDesc), ignore -> new ArrayList()).add(member3);
                }
                for (Map.Entry e : duplicates.entrySet()) {
                    String nameDesc = (String)e.getKey();
                    List members = (List)e.getValue();
                    if (members.size() < 2) continue;
                    MemberInstance anyMember = (MemberInstance)members.get(0);
                    System.out.printf("  %ss %s/[", new Object[]{anyMember.type, cls.getName()});
                    for (int i = 0; i < members.size(); ++i) {
                        if (i != 0) {
                            System.out.print(", ");
                        }
                        MemberInstance member4 = (MemberInstance)members.get(i);
                        if (member4.newNameOriginatingCls != null && !member4.newNameOriginatingCls.equals(cls.getName())) {
                            System.out.print(member4.newNameOriginatingCls);
                            System.out.print('/');
                        }
                        System.out.print(member4.name);
                    }
                    System.out.printf("]%s -> %s%n", MemberInstance.getId(anyMember.type, "", anyMember.desc, this.ignoreFieldDesc), MemberInstance.getNameFromId(anyMember.type, nameDesc, this.ignoreFieldDesc));
                }
            }
            testSet.clear();
        }
        boolean unfixableConflicts = false;
        if (!this.conflicts.isEmpty()) {
            System.out.println("Mapping source name conflicts detected:");
            for (Map.Entry<MemberInstance, Set<String>> entry : this.conflicts.entrySet()) {
                MemberInstance memberInstance = entry.getKey();
                String newName = memberInstance.getNewName();
                Set<String> names = entry.getValue();
                names.add(memberInstance.cls.getName() + "/" + newName);
                System.out.printf("  %s %s %s (%s) -> %s%n", memberInstance.cls.getName(), memberInstance.type.name(), memberInstance.name, memberInstance.desc, names);
                if (!this.ignoreConflicts) continue;
                Map<String, String> mappings = memberInstance.type == MemberInstance.MemberType.METHOD ? this.methodMap : this.fieldMap;
                String mappingName = mappings.get(memberInstance.cls.getName() + "/" + memberInstance.getId());
                if (mappingName == null) {
                    ClassInstance cls;
                    ArrayDeque<ClassInstance> queue = new ArrayDeque<ClassInstance>(memberInstance.cls.parents);
                    while ((cls = (ClassInstance)queue.poll()) != null && (mappingName = mappings.get(cls.getName() + "/" + memberInstance.getId())) == null) {
                        queue.addAll(cls.parents);
                    }
                }
                if (mappingName == null) {
                    unfixableConflicts = true;
                    continue;
                }
                memberInstance.forceSetNewName(mappingName);
                System.out.println("    fixable: replaced with " + mappingName);
            }
        }
        if (!this.conflicts.isEmpty() && !this.ignoreConflicts || unfixableConflicts || targetNameCheckFailed) {
            if (this.ignoreConflicts || targetNameCheckFailed) {
                System.out.println("There were unfixable conflicts.");
            }
            System.exit(1);
        }
    }

    public void apply(BiConsumer<String, byte[]> outputConsumer) {
        this.apply(outputConsumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void apply(BiConsumer<String, byte[]> outputConsumer, InputTag ... inputTags) {
        boolean hasInputTags = !this.singleInputTags.get().isEmpty();
        TinyRemapper tinyRemapper = this;
        synchronized (tinyRemapper) {
            this.refresh();
            if (this.outputBuffer == null) {
                boolean needsFixes;
                if (this.fixPackageAccess || hasInputTags) {
                    this.outputBuffer = new ConcurrentHashMap<ClassInstance, byte[]>();
                    BiConsumer<ClassInstance, byte[]> biConsumer = this.outputBuffer::put;
                } else {
                    BiConsumer<ClassInstance, byte[]> biConsumer = (cls, data) -> outputConsumer.accept(this.mapClass(cls.getName()), (byte[])data);
                }
                ArrayList futures = new ArrayList();
                for (ClassInstance cls2 : this.classes.values()) {
                    void var5_7;
                    if (!cls2.isInput) continue;
                    if (cls2.data == null) {
                        if (!hasInputTags && !this.keepInputData) {
                            throw new IllegalStateException("invoking apply multiple times without input tags or hasInputData");
                        }
                        throw new IllegalStateException("data for input class " + cls2 + " is missing?!");
                    }
                    futures.add(this.threadPool.submit(() -> this.lambda$apply$5((BiConsumer)var5_7, cls2)));
                }
                TinyRemapper.waitForAll(futures);
                boolean bl = needsFixes = !this.classesToMakePublic.isEmpty() || !this.membersToMakePublic.isEmpty();
                if (this.fixPackageAccess) {
                    if (needsFixes) {
                        System.out.printf("Fixing access for %d classes and %d members.%n", this.classesToMakePublic.size(), this.membersToMakePublic.size());
                    }
                    for (Map.Entry<ClassInstance, byte[]> entry : this.outputBuffer.entrySet()) {
                        ClassInstance cls3 = entry.getKey();
                        byte[] data2 = entry.getValue();
                        if (needsFixes) {
                            data2 = this.fixClass(cls3, data2);
                        }
                        if (hasInputTags) {
                            entry.setValue(data2);
                            continue;
                        }
                        outputConsumer.accept(this.mapClass(cls3.getName()), data2);
                    }
                    if (!hasInputTags) {
                        this.outputBuffer = null;
                    }
                    this.classesToMakePublic.clear();
                    this.membersToMakePublic.clear();
                } else if (needsFixes) {
                    throw new RuntimeException(String.format("%d classes and %d members need access fixes", this.classesToMakePublic.size(), this.membersToMakePublic.size()));
                }
            }
        }
        assert (hasInputTags == (this.outputBuffer != null));
        if (this.outputBuffer != null) {
            for (Map.Entry entry : this.outputBuffer.entrySet()) {
                ClassInstance cls4 = (ClassInstance)entry.getKey();
                if (inputTags != null && !cls4.hasAnyInputTag(inputTags)) continue;
                outputConsumer.accept(this.mapClass(cls4.getName()), (byte[])entry.getValue());
            }
        }
    }

    private void refresh() {
        if (!this.dirty) {
            return;
        }
        this.outputBuffer = null;
        if (!this.pendingReads.isEmpty()) {
            for (CompletableFuture<?> future : this.pendingReads) {
                future.join();
            }
            this.pendingReads.clear();
        }
        if (!this.readClasses.isEmpty()) {
            for (ClassInstance cls : this.readClasses.values()) {
                TinyRemapper.addClass(cls, this.classes);
            }
            this.readClasses.clear();
        }
        this.loadMappings();
        this.checkClassMappings();
        this.merge();
        this.propagate();
        this.dirty = false;
    }

    private byte[] apply(ClassInstance cls) {
        ClassReader reader = new ClassReader(cls.data);
        ClassWriter writer = new ClassWriter(0);
        int flags = this.removeFrames ? 4 : 8;
        Object visitor = writer;
        if (this.rebuildSourceFilenames) {
            visitor = new SourceNameRebuildVisitor(524288, (ClassVisitor)visitor);
        }
        reader.accept((ClassVisitor)new AsmClassRemapper((ClassVisitor)visitor, this.remapper, this.checkPackageAccess, this.skipLocalMapping, this.renameInvalidLocals), flags);
        if (!this.keepInputData) {
            cls.data = null;
        }
        return writer.toByteArray();
    }

    private byte[] fixClass(ClassInstance cls, byte[] data) {
        final boolean makeClsPublic = this.classesToMakePublic.contains(cls);
        HashSet<String> clsMembersToMakePublic = null;
        for (MemberInstance member : cls.getMembers()) {
            String mappedDesc;
            String mappedName;
            if (!this.membersToMakePublic.contains(member)) continue;
            if (clsMembersToMakePublic == null) {
                clsMembersToMakePublic = new HashSet<String>();
            }
            if (member.type == MemberInstance.MemberType.FIELD) {
                mappedName = this.remapper.mapFieldName(cls.getName(), member.name, member.desc);
                mappedDesc = this.remapper.mapDesc(member.desc);
            } else {
                mappedName = this.remapper.mapMethodName(cls.getName(), member.name, member.desc);
                mappedDesc = this.remapper.mapMethodDesc(member.desc);
            }
            clsMembersToMakePublic.add(MemberInstance.getId(member.type, mappedName, mappedDesc, this.ignoreFieldDesc));
        }
        if (!makeClsPublic && clsMembersToMakePublic == null) {
            return data;
        }
        final HashSet<String> finalClsMembersToMakePublic = clsMembersToMakePublic;
        ClassReader reader = new ClassReader(data);
        ClassWriter writer = new ClassWriter(0);
        reader.accept(new ClassVisitor(524288, (ClassVisitor)writer){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (makeClsPublic) {
                    access = access & 0xFFFFFFF9 | 1;
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                if (finalClsMembersToMakePublic != null && finalClsMembersToMakePublic.contains(MemberInstance.getFieldId(name, descriptor, TinyRemapper.this.ignoreFieldDesc))) {
                    access = access & 0xFFFFFFF9 | 1;
                }
                return super.visitField(access, name, descriptor, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                if (finalClsMembersToMakePublic != null && finalClsMembersToMakePublic.contains(MemberInstance.getMethodId(name, descriptor))) {
                    access = access & 0xFFFFFFF9 | 1;
                }
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
        }, 0);
        return writer.toByteArray();
    }

    public AsmRemapper getRemapper() {
        this.refresh();
        return this.remapper;
    }

    private static void waitForAll(Iterable<Future<?>> futures) {
        try {
            for (Future<?> future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getClassName(String nameDesc, MemberInstance.MemberType type) {
        int descStart = TinyRemapper.getDescStart(nameDesc, type);
        int nameStart = nameDesc.lastIndexOf(47, descStart - 1);
        if (nameStart == -1) {
            nameStart = 0;
        }
        return nameDesc.substring(0, nameStart);
    }

    private static String stripClassName(String nameDesc, MemberInstance.MemberType type) {
        int descStart = TinyRemapper.getDescStart(nameDesc, type);
        int nameStart = nameDesc.lastIndexOf(47, descStart - 1);
        if (nameStart == -1) {
            nameStart = 0;
        }
        return nameDesc.substring(nameStart + 1);
    }

    private static int getDescStart(String nameDesc, MemberInstance.MemberType type) {
        int ret = type == MemberInstance.MemberType.METHOD ? nameDesc.indexOf(40) : nameDesc.indexOf(";;");
        if (ret == -1) {
            ret = nameDesc.length();
        }
        return ret;
    }

    class Propagation
    implements Runnable {
        private final MemberInstance.MemberType type;
        private final List<Map.Entry<String, String>> tasks = new ArrayList<Map.Entry<String, String>>();

        Propagation(MemberInstance.MemberType type, List<Map.Entry<String, String>> tasks) {
            this.type = type;
            this.tasks.addAll(tasks);
        }

        @Override
        public void run() {
            Set<ClassInstance> visitedUp = Collections.newSetFromMap(new IdentityHashMap());
            Set<ClassInstance> visitedDown = Collections.newSetFromMap(new IdentityHashMap());
            for (Map.Entry<String, String> entry : this.tasks) {
                MemberInstance member;
                String className = TinyRemapper.getClassName(entry.getKey(), this.type);
                ClassInstance cls = TinyRemapper.this.classes.get(className);
                if (cls == null) continue;
                String idSrc = TinyRemapper.stripClassName(entry.getKey(), this.type);
                String nameDst = entry.getValue();
                assert (nameDst.indexOf(47) < 0);
                if (MemberInstance.getNameFromId(this.type, idSrc, TinyRemapper.this.ignoreFieldDesc).equals(nameDst)) continue;
                MemberInstance memberInstance = member = TinyRemapper.this.resolveMissing ? cls.resolve(this.type, idSrc) : cls.getMember(this.type, idSrc);
                if (member == null) continue;
                cls = member.cls;
                boolean isVirtual = member.isVirtual();
                visitedUp.add(cls);
                visitedDown.add(cls);
                cls.propagate(TinyRemapper.this, this.type, className, idSrc, nameDst, isVirtual ? Direction.ANY : Direction.DOWN, isVirtual, true, visitedUp, visitedDown);
                visitedUp.clear();
                visitedDown.clear();
            }
        }
    }

    static enum Direction {
        ANY,
        UP,
        DOWN;

    }

    public static class Builder {
        private final Set<IMappingProvider> mappingProviders = new HashSet<IMappingProvider>();
        private boolean ignoreFieldDesc;
        private int threadCount;
        private final Set<String> forcePropagation = new HashSet<String>();
        private boolean keepInputData = false;
        private boolean propagatePrivate = false;
        private boolean removeFrames = false;
        private boolean ignoreConflicts = false;
        private boolean resolveMissing = false;
        private boolean checkPackageAccess = false;
        private boolean fixPackageAccess = false;
        private boolean rebuildSourceFilenames = false;
        private boolean skipLocalMapping = false;
        private boolean renameInvalidLocals = false;
        private ClassVisitor extraAnalyzeVisitor;
        private Remapper extraRemapper;

        private Builder() {
        }

        public Builder withMappings(IMappingProvider provider) {
            this.mappingProviders.add(provider);
            return this;
        }

        public Builder ignoreFieldDesc(boolean value) {
            this.ignoreFieldDesc = value;
            return this;
        }

        public Builder threads(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public Builder keepInputData(boolean value) {
            this.keepInputData = value;
            return this;
        }

        public Builder withForcedPropagation(Set<String> entries) {
            this.forcePropagation.addAll(entries);
            return this;
        }

        public Builder propagatePrivate(boolean value) {
            this.propagatePrivate = value;
            return this;
        }

        public Builder removeFrames(boolean value) {
            this.removeFrames = value;
            return this;
        }

        public Builder ignoreConflicts(boolean value) {
            this.ignoreConflicts = value;
            return this;
        }

        public Builder resolveMissing(boolean value) {
            this.resolveMissing = value;
            return this;
        }

        public Builder checkPackageAccess(boolean value) {
            this.checkPackageAccess = value;
            return this;
        }

        public Builder fixPackageAccess(boolean value) {
            this.fixPackageAccess = value;
            return this;
        }

        public Builder rebuildSourceFilenames(boolean value) {
            this.rebuildSourceFilenames = value;
            return this;
        }

        public Builder skipLocalVariableMapping(boolean value) {
            this.skipLocalMapping = value;
            return this;
        }

        public Builder renameInvalidLocals(boolean value) {
            this.renameInvalidLocals = value;
            return this;
        }

        public Builder extraAnalyzeVisitor(ClassVisitor visitor) {
            this.extraAnalyzeVisitor = visitor;
            return this;
        }

        public Builder extraRemapper(Remapper remapper) {
            this.extraRemapper = remapper;
            return this;
        }

        public TinyRemapper build() {
            TinyRemapper remapper = new TinyRemapper(this.mappingProviders, this.ignoreFieldDesc, this.threadCount, this.keepInputData, this.forcePropagation, this.propagatePrivate, this.removeFrames, this.ignoreConflicts, this.resolveMissing, this.checkPackageAccess || this.fixPackageAccess, this.fixPackageAccess, this.rebuildSourceFilenames, this.skipLocalMapping, this.renameInvalidLocals, this.extraAnalyzeVisitor, this.extraRemapper);
            return remapper;
        }
    }
}

