/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper;

import java.util.Locale;
import net.fabricmc.tinyremapper.ClassInstance;
import net.fabricmc.tinyremapper.MemberInstance;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.objectweb.asm.commons.Remapper;

class AsmRemapper
extends Remapper {
    private final TinyRemapper remapper;

    public AsmRemapper(TinyRemapper remapper) {
        this.remapper = remapper;
    }

    public String map(String typeName) {
        String ret = this.remapper.classMap.get(typeName);
        if (ret != null) {
            return ret;
        }
        return this.remapper.extraRemapper != null ? this.remapper.extraRemapper.map(typeName) : typeName;
    }

    public String mapFieldName(String owner, String name, String desc) {
        String newName;
        ClassInstance cls = this.getClass(owner);
        if (cls == null) {
            return name;
        }
        MemberInstance member = cls.resolve(MemberInstance.MemberType.FIELD, MemberInstance.getFieldId(name, desc, this.remapper.ignoreFieldDesc));
        if (member != null && (newName = member.getNewName()) != null) {
            return newName;
        }
        assert ((newName = this.remapper.fieldMap.get(owner + "/" + MemberInstance.getFieldId(name, desc, this.remapper.ignoreFieldDesc))) == null || newName.equals(name));
        return this.remapper.extraRemapper != null ? this.remapper.extraRemapper.mapFieldName(owner, name, desc) : name;
    }

    public String mapMethodName(String owner, String name, String desc) {
        String newName;
        ClassInstance cls = this.getClass(owner);
        if (cls == null) {
            return name;
        }
        MemberInstance member = cls.resolve(MemberInstance.MemberType.METHOD, MemberInstance.getMethodId(name, desc));
        if (member != null && (newName = member.getNewName()) != null) {
            return newName;
        }
        assert ((newName = this.remapper.methodMap.get(owner + "/" + MemberInstance.getMethodId(name, desc))) == null || newName.equals(name));
        return this.remapper.extraRemapper != null ? this.remapper.extraRemapper.mapMethodName(owner, name, desc) : name;
    }

    public String mapMethodNamePrefixDesc(String owner, String name, String descPrefix) {
        String newName;
        ClassInstance cls = this.getClass(owner);
        if (cls == null) {
            return name;
        }
        MemberInstance member = cls.resolvePartial(MemberInstance.MemberType.METHOD, name, descPrefix);
        if (member != null && (newName = member.getNewName()) != null) {
            return newName;
        }
        return name;
    }

    public String mapLambdaInvokeDynamicMethodName(String owner, String name, String desc) {
        return this.mapMethodName(owner, name, desc);
    }

    public String mapArbitraryInvokeDynamicMethodName(String owner, String name) {
        return this.mapMethodNamePrefixDesc(owner, name, null);
    }

    public String mapMethodArg(String methodOwner, String methodName, String methodDesc, int lvIndex, String name) {
        String newName = this.remapper.methodArgMap.get(methodOwner + "/" + MemberInstance.getMethodId(methodName, methodDesc) + lvIndex);
        if (newName != null) {
            return newName;
        }
        ClassInstance cls = this.getClass(methodOwner);
        if (cls == null) {
            return name;
        }
        MemberInstance originatingMethod = cls.resolve(MemberInstance.MemberType.METHOD, MemberInstance.getMethodId(methodName, methodDesc));
        if (originatingMethod == null) {
            return name;
        }
        String originatingNewName = this.remapper.methodArgMap.get(originatingMethod.newNameOriginatingCls + "/" + MemberInstance.getMethodId(originatingMethod.name, originatingMethod.desc) + lvIndex);
        return originatingNewName != null ? originatingNewName : name;
    }

    public String mapMethodVar(String methodOwner, String methodName, String methodDesc, int lvIndex, int startOpIdx, int asmIndex, String name) {
        return name;
    }

    public void checkPackageAccess(String accessingOwner, String owner, String name, String desc, MemberInstance.MemberType type) {
        String mappedDesc;
        String mappedName;
        boolean memberAccessible;
        ClassInstance cls = this.getClass(owner);
        if (cls == null) {
            return;
        }
        String id = MemberInstance.getId(type, name, desc, this.remapper.ignoreFieldDesc);
        MemberInstance member = cls.resolve(type, id);
        if (member == null) {
            return;
        }
        boolean clsAccessible = cls.isPublicOrPrivate() || accessingOwner.equals(owner);
        boolean bl = memberAccessible = member.isPublicOrPrivate() || accessingOwner.equals(member.cls.getName());
        if (clsAccessible && memberAccessible) {
            return;
        }
        String mappedAccessor = this.map(accessingOwner);
        int pkgEnd = mappedAccessor.lastIndexOf(47);
        if (!clsAccessible && this.isSamePackage(mappedAccessor, pkgEnd, this.map(owner))) {
            if (memberAccessible || owner.equals(member.cls.getName())) {
                return;
            }
            clsAccessible = true;
        }
        if (!memberAccessible && this.isSamePackage(mappedAccessor, pkgEnd, this.map(member.cls.getName()))) {
            if (clsAccessible) {
                return;
            }
            memberAccessible = true;
        }
        if (member.isProtected() && this.hasSuperCls(accessingOwner, member.cls.getName()) && (member.isStatic() || owner.equals(accessingOwner) || owner.equals(member.cls.getName()) || this.hasSuperCls(owner, accessingOwner) || this.hasSuperCls(accessingOwner, owner))) {
            return;
        }
        assert (!clsAccessible || !memberAccessible);
        if (type == MemberInstance.MemberType.FIELD) {
            mappedName = this.mapFieldName(owner, name, desc);
            mappedDesc = this.mapDesc(desc);
        } else {
            mappedName = this.mapMethodName(owner, name, desc);
            mappedDesc = this.mapMethodDesc(desc);
        }
        String inaccessible = null;
        if (!clsAccessible) {
            inaccessible = String.format("package-private class %s", this.map(owner));
        }
        if (!memberAccessible) {
            String memberMsg = String.format("%s %s %s/%s", member.isProtected() ? "protected" : "package-private", type.name().toLowerCase(Locale.ENGLISH), this.map(member.cls.getName()), MemberInstance.getId(type, mappedName, mappedDesc, this.remapper.ignoreFieldDesc));
            inaccessible = inaccessible == null ? memberMsg : String.format("%s, %s", inaccessible, memberMsg);
        }
        System.out.printf("Invalid access from %s to %s after remapping.%n", mappedAccessor, inaccessible);
        if (!clsAccessible) {
            this.remapper.classesToMakePublic.add(cls);
        }
        if (!memberAccessible) {
            this.remapper.membersToMakePublic.add(member);
        }
    }

    private boolean isSamePackage(String clsA, int pkgEnd, String clsB) {
        return pkgEnd < 0 && clsB.indexOf(47) < 0 || pkgEnd >= 0 && pkgEnd < clsB.length() && clsB.charAt(pkgEnd) == '/' && clsB.indexOf(47, pkgEnd + 1) < 0 && clsA.regionMatches(0, clsB, 0, pkgEnd - 1);
    }

    private boolean hasSuperCls(String cls, String reqSuperCls) {
        ClassInstance c;
        assert (!cls.equals(reqSuperCls));
        while ((c = this.getClass(cls)) != null && (cls = c.getSuperName()) != null) {
            if (!cls.equals(reqSuperCls)) continue;
            return true;
        }
        return false;
    }

    private ClassInstance getClass(String owner) {
        return this.remapper.classes.get(owner);
    }
}

