/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.jar.JarFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.launch.common.FabricLauncher;
import net.fabricmc.loader.launch.common.MappingConfiguration;
import net.fabricmc.loader.util.Arguments;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.fabricmc.loader.util.mappings.TinyRemapperMappingsHelper;
import net.fabricmc.mapping.tree.TinyTree;
import net.fabricmc.tinyremapper.OutputConsumerPath;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;

public abstract class FabricLauncherBase
implements FabricLauncher {
    public static Path minecraftJar;
    protected static Logger LOGGER;
    private static boolean mixinReady;
    private static Map<String, Object> properties;
    private static FabricLauncher launcher;
    private static MappingConfiguration mappingConfiguration;
    private static boolean emittedInfo;

    protected FabricLauncherBase() {
        FabricLauncherBase.setLauncher(this);
    }

    public static File getLaunchDirectory(Arguments argMap) {
        return new File(argMap.getOrDefault("gameDir", "."));
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, FabricLauncherBase.getLauncher().getTargetClassLoader());
    }

    @Override
    public MappingConfiguration getMappingConfiguration() {
        return mappingConfiguration;
    }

    protected static Path deobfuscate(String gameId, String gameVersion, Path gameDir, Path jarFile, FabricLauncher launcher) {
        Path resultJarFile = jarFile;
        LOGGER.debug("Requesting deobfuscation of " + jarFile.getFileName());
        TinyTree mappings = launcher.isDevelopment() ? null : mappingConfiguration.getMappings();
        String targetNamespace = mappingConfiguration.getTargetNamespace();
        if (mappings != null && mappings.getMetadata().getNamespaces().contains(targetNamespace)) {
            LOGGER.debug("Fabric mapping file detected, applying...");
            try {
                if (!Files.exists(jarFile, new LinkOption[0])) {
                    throw new RuntimeException("Could not locate Minecraft: " + jarFile + " not found");
                }
                Path deobfJarDir = gameDir.resolve(".fabric").resolve("remappedJars");
                if (!gameId.isEmpty()) {
                    String versionedId = gameVersion.isEmpty() ? gameId : String.format("%s-%s", gameId, gameVersion);
                    deobfJarDir = deobfJarDir.resolve(versionedId);
                }
                if (!Files.exists(deobfJarDir, new LinkOption[0])) {
                    Files.createDirectories(deobfJarDir, new FileAttribute[0]);
                }
                String deobfJarFilename = mappingConfiguration.getTargetNamespace() + "-" + jarFile.getFileName();
                Path deobfJarFile = deobfJarDir.resolve(deobfJarFilename);
                Path deobfJarFileTmp = deobfJarDir.resolve(deobfJarFilename + ".tmp");
                if (Files.exists(deobfJarFileTmp, new LinkOption[0])) {
                    LOGGER.warn("Incomplete remapped file found! This means that the remapping process failed on the previous launch. If this persists, make sure to let us at Fabric know!");
                    Files.deleteIfExists(deobfJarFile);
                    Files.deleteIfExists(deobfJarFileTmp);
                }
                if (!Files.exists(deobfJarFile, new LinkOption[0])) {
                    boolean found = false;
                    while (!found) {
                        if (!emittedInfo) {
                            LOGGER.info("Fabric is preparing JARs on first launch, this may take a few seconds...");
                            emittedInfo = true;
                        }
                        TinyRemapper remapper = TinyRemapper.newRemapper().withMappings(TinyRemapperMappingsHelper.create(mappings, "official", targetNamespace)).rebuildSourceFilenames(true).build();
                        HashSet<Path> depPaths = new HashSet<Path>();
                        for (URL uRL : launcher.getLoadTimeDependencies()) {
                            try {
                                Path path = UrlUtil.asPath(uRL);
                                if (!Files.exists(path, new LinkOption[0])) {
                                    throw new RuntimeException("Path does not exist: " + path);
                                }
                                if (path.equals(jarFile)) continue;
                                depPaths.add(path);
                            }
                            catch (UrlConversionException e2) {
                                throw new RuntimeException("Failed to convert '" + uRL + "' to path!", e2);
                            }
                        }
                        try (OutputConsumerPath outputConsumer = new OutputConsumerPath.Builder(deobfJarFileTmp).assumeArchive(true).filter(clsName -> !clsName.startsWith("com/google/common/") && !clsName.startsWith("com/google/gson/") && !clsName.startsWith("com/google/thirdparty/") && !clsName.startsWith("org/apache/logging/log4j/")).build();){
                            for (Path path : depPaths) {
                                LOGGER.debug("Appending '" + path + "' to remapper classpath");
                                remapper.readClassPath(new Path[]{path});
                            }
                            remapper.readInputs(new Path[]{jarFile});
                            remapper.apply((BiConsumer)outputConsumer);
                        }
                        catch (IOException e3) {
                            throw new RuntimeException("Failed to remap '" + jarFile + "'!", e3);
                        }
                        finally {
                            remapper.finish();
                        }
                        depPaths.add(deobfJarFileTmp);
                        for (Path path : depPaths) {
                            try {
                                path.getFileSystem().close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                FileSystems.getFileSystem(new URI("jar:" + path.toUri())).close();
                            }
                            catch (Exception exception) {}
                        }
                        try (JarFile jar = new JarFile(deobfJarFileTmp.toFile());){
                            found = jar.stream().anyMatch(e -> e.getName().endsWith(".class"));
                        }
                        if (!found) {
                            LOGGER.error("Generated deobfuscated JAR contains no classes! Trying again...");
                            Files.delete(deobfJarFileTmp);
                            continue;
                        }
                        Files.move(deobfJarFileTmp, deobfJarFile, new CopyOption[0]);
                    }
                }
                if (!Files.exists(deobfJarFile, new LinkOption[0])) {
                    throw new RuntimeException("Remapped .JAR file does not exist after remapping! Cannot continue!");
                }
                resultJarFile = deobfJarFile;
            }
            catch (IOException e4) {
                throw new RuntimeException(e4);
            }
        }
        try {
            launcher.propose(UrlUtil.asUrl(resultJarFile));
        }
        catch (UrlConversionException e5) {
            throw new RuntimeException(e5);
        }
        if (minecraftJar == null) {
            minecraftJar = resultJarFile;
        }
        return resultJarFile;
    }

    public static void processArgumentMap(Arguments argMap, EnvType envType) {
        switch (envType) {
            case CLIENT: {
                if (!argMap.containsKey("accessToken")) {
                    argMap.put("accessToken", "FabricMC");
                }
                if (!argMap.containsKey("version")) {
                    argMap.put("version", "Fabric");
                }
                String versionType = "";
                if (argMap.containsKey("versionType") && !argMap.get("versionType").equalsIgnoreCase("release")) {
                    versionType = argMap.get("versionType") + "/";
                }
                argMap.put("versionType", versionType + "Fabric");
                if (argMap.containsKey("gameDir")) break;
                argMap.put("gameDir", FabricLauncherBase.getLaunchDirectory(argMap).getAbsolutePath());
                break;
            }
            case SERVER: {
                argMap.remove("version");
                argMap.remove("gameDir");
                argMap.remove("assetsDir");
            }
        }
    }

    protected static void setProperties(Map<String, Object> propertiesA) {
        if (properties != null && properties != propertiesA) {
            throw new RuntimeException("Duplicate setProperties call!");
        }
        properties = propertiesA;
    }

    private static void setLauncher(FabricLauncher launcherA) {
        if (launcher != null && launcher != launcherA) {
            throw new RuntimeException("Duplicate setLauncher call!");
        }
        launcher = launcherA;
    }

    public static FabricLauncher getLauncher() {
        return launcher;
    }

    public static Map<String, Object> getProperties() {
        return properties;
    }

    protected static void finishMixinBootstrapping() {
        if (mixinReady) {
            throw new RuntimeException("Must not call FabricLauncherBase.finishMixinBootstrapping() twice!");
        }
        try {
            Method m = MixinEnvironment.class.getDeclaredMethod("gotoPhase", MixinEnvironment.Phase.class);
            m.setAccessible(true);
            m.invoke(null, MixinEnvironment.Phase.INIT);
            m.invoke(null, MixinEnvironment.Phase.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        mixinReady = true;
    }

    public static boolean isMixinReady() {
        return mixinReady;
    }

    static {
        LOGGER = LogManager.getFormatterLogger((String)"FabricLoader");
        mappingConfiguration = new MappingConfiguration();
        emittedInfo = false;
    }
}

