/*
 * Decompiled with CFR 0.152.
 */
package two.graves.util;

public class TimeCounter {
    final String what;
    long timeStart;
    double calls;
    double timeTotal;
    double timeMax;
    double timeMin;

    public TimeCounter(String what) {
        this.what = what;
        this.timeMax = -1.0;
        this.timeMin = -1.0;
    }

    public void start() {
        this.timeStart = System.nanoTime();
    }

    public void stop() {
        this.calls += 1.0;
        double timeTaken = (double)(System.nanoTime() - this.timeStart) / 1000000.0;
        this.timeTotal += timeTaken;
        this.timeMax = this.timeMax == -1.0 ? timeTaken : Math.max(timeTaken, this.timeMax);
        this.timeMin = this.timeMin == -1.0 ? timeTaken : Math.min(timeTaken, this.timeMin);
    }

    public String toString() {
        return String.format("[%s]: Time [avg]: %3.2f ms, [min]: %3.2f ms, [max]: %3.2f ms", this.what, this.timeTotal / this.calls, this.timeMin, this.timeMax);
    }
}

