/*
 * Decompiled with CFR 0.152.
 */
package two.graves.util;

import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class ItemUtil {
    public static final FMLControlledNamespacedRegistry<Item> registry = GameData.getItemRegistry();
    protected static final Map<String, String> tooltipCache = new HashMap<String, String>();

    public static boolean isSameItem(ItemStack itemStack, ItemStack other) {
        if (itemStack == other) {
            return true;
        }
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77969_a(other) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)other);
    }

    public static boolean isSameItem(Item item, Item other) {
        return item == other;
    }

    public static boolean isStackHolding(ItemStack itemStack, Item item) {
        return itemStack != null && ItemUtil.isSameItem(itemStack.func_77973_b(), item) && !itemStack.func_77942_o();
    }

    public static boolean isSameBaseType(ItemStack itemStack, Item item) {
        return itemStack != null && ItemUtil.isSameItem(itemStack.func_77973_b(), item);
    }

    public static Item findByName(String name) {
        return (Item)registry.func_82594_a(name);
    }

    public static ItemStack getSmeltingResult(ItemStack ingredients) {
        if (ingredients == null || ingredients.func_77973_b() == null) {
            return null;
        }
        ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(ingredients);
        if (smeltingResult == null || smeltingResult.func_77973_b() == null) {
            return null;
        }
        return smeltingResult.func_77946_l();
    }

    public static boolean canSmelt(ItemStack ingredients) {
        if (ingredients == null || ingredients.func_77973_b() == null) {
            return false;
        }
        ItemStack smeltingResult = FurnaceRecipes.func_77602_a().func_151395_a(ingredients);
        return smeltingResult != null && smeltingResult.func_77973_b() != null;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getCachedTooltip(String key) {
        String result = tooltipCache.get(key);
        if (result == null) {
            result = LanguageRegistry.instance().getStringLocalization(key);
            if (result == null) {
                result = "";
            }
            tooltipCache.put(key, result);
        }
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public static void clearCachedTooltips() {
        tooltipCache.clear();
    }
}

