/*
 * Decompiled with CFR 0.152.
 */
package two.graves.tiles;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.Level;
import two.graves.API.IInventoryHandler;
import two.graves.API.InventoryContent;
import two.graves.API.InventoryHandlerRegistry;
import two.graves.Graves;
import two.graves.GravesAssets;
import two.graves.network.PacketForceEquipItems;

public class TileGrave
extends TileEntity {
    protected static final String KEY_OWNER = "GraveOwner";
    protected static final String KEY_INVENTORY = "GraveInventory";
    protected static final String KEY_LOCALIZATION_NOTYOURGRAVE = "notyourgrave";
    protected final LinkedList<InventoryContent> inventoryContent = new LinkedList();
    protected String ownerName;

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.ownerName = tagCompound.func_74779_i(KEY_OWNER);
        this.inventoryContent.clear();
        NBTTagList inventoryList = tagCompound.func_150295_c(KEY_INVENTORY, 10);
        for (int tagCount = inventoryList.func_74745_c() - 1; tagCount >= 0; --tagCount) {
            NBTTagCompound inventoryEntry = inventoryList.func_150305_b(tagCount);
            try {
                InventoryContent content = InventoryContent.readFromNBT(inventoryEntry);
                this.inventoryContent.add(content);
                continue;
            }
            catch (Exception e) {
                FMLLog.log((String)"TwoGraves", (Level)Level.ERROR, (String)"Unable to load inventory content entry: %s\n%s", (Object[])new Object[]{e.toString(), inventoryEntry == null ? "null" : inventoryEntry.toString()});
            }
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74778_a(KEY_OWNER, this.ownerName);
        NBTTagList inventoryList = new NBTTagList();
        for (InventoryContent content : this.inventoryContent) {
            NBTTagCompound inventoryEntry = new NBTTagCompound();
            content.writeToNBT(inventoryEntry);
            inventoryList.func_74742_a((NBTBase)inventoryEntry);
        }
        tagCompound.func_74782_a(KEY_INVENTORY, (NBTBase)inventoryList);
    }

    public void takePlayerInventory(EntityPlayer player) {
        this.ownerName = player.getDisplayName();
        for (IInventoryHandler handler : InventoryHandlerRegistry.getAllHandlers()) {
            this.inventoryContent.addAll(handler.removeAllItems(player, this.field_145850_b.field_72995_K));
            handler.markDirty(player, this.field_145850_b.field_72995_K);
        }
        if (this.inventoryContent.isEmpty()) {
            this.destroyThisGrave();
        } else {
            this.func_70296_d();
        }
    }

    public void giveItemsToPlayer(EntityPlayer player) {
        if (this.ownerName.equals(player.getDisplayName())) {
            if (player instanceof EntityPlayerMP) {
                PacketForceEquipItems packet = new PacketForceEquipItems(this.inventoryContent);
                Graves.networkChannel.sendTo((IMessage)packet, (EntityPlayerMP)player);
            }
            if (TileGrave.giveItemsToPlayer(player, this.inventoryContent, true)) {
                this.destroyThisGrave();
            } else {
                this.func_70296_d();
            }
            for (IInventoryHandler handler : InventoryHandlerRegistry.getAllHandlers()) {
                handler.markDirty(player, true);
            }
        } else {
            String message = String.format(LanguageRegistry.instance().getStringLocalization(KEY_LOCALIZATION_NOTYOURGRAVE), this.ownerName);
            player.func_146105_b((IChatComponent)new ChatComponentText(message));
        }
    }

    public static boolean giveItemsToPlayer(EntityPlayer player, Deque<InventoryContent> inventoryList, boolean remote) {
        InventoryContent content;
        int count;
        int n = count = GravesAssets.itemsPerTick >= 0 ? GravesAssets.itemsPerTick : Integer.MAX_VALUE;
        if (count == 0) {
            return true;
        }
        LinkedList<InventoryContent> notAdded = new LinkedList<InventoryContent>();
        while (count-- > 0 && (content = inventoryList.poll()) != null) {
            try {
                IInventoryHandler handler = InventoryHandlerRegistry.getHandlerForID(content.getHandlerID());
                if (handler != null) {
                    if (handler.set(player, content.getSlot(), content.getItemStack(), remote)) continue;
                    notAdded.add(content);
                    continue;
                }
                FMLLog.log((String)"TwoGraves", (Level)Level.WARN, (String)"No handler registered for ID '%s'. The item '%s' is lost.", (Object[])new Object[]{content.getHandlerID(), content.getItemStack().func_82833_r()});
            }
            catch (Exception e) {
                FMLLog.log((String)"TwoGraves", (Level)Level.ERROR, (String)"Failed to add item to inventory: %s\n%s", (Object[])new Object[]{e.toString(), content.toString()});
            }
        }
        IInventoryHandler vanillaHandler = InventoryHandlerRegistry.getHandlerForID("");
        for (InventoryContent leftOverContent : notAdded) {
            IInventoryHandler handler = InventoryHandlerRegistry.getHandlerForID(leftOverContent.getHandlerID());
            if (handler != null) {
                if (handler.add(player, leftOverContent.getItemStack(), remote) || handler != vanillaHandler && vanillaHandler.add(player, leftOverContent.getItemStack(), remote)) continue;
                inventoryList.add(leftOverContent);
                continue;
            }
            FMLLog.log((String)"TwoGraves", (Level)Level.WARN, (String)"No handler registered for ID '%s'. The item '%s' is lost.", (Object[])new Object[]{leftOverContent.getHandlerID(), leftOverContent.getItemStack().func_82833_r()});
        }
        return inventoryList.isEmpty();
    }

    public void spillOutInventory() {
        for (InventoryContent content : this.inventoryContent) {
            this.spillOutItem(content.getItemStack());
        }
        this.inventoryContent.clear();
        this.func_70296_d();
    }

    public void spillOutItem(ItemStack itemstack) {
        if (itemstack != null) {
            float modX = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float modY = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float modZ = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int stackSplit = this.field_145850_b.field_73012_v.nextInt(21) + 10;
                if (stackSplit > itemstack.field_77994_a) {
                    stackSplit = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= stackSplit;
                EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + modX), (double)((float)this.field_145848_d + modY), (double)((float)this.field_145849_e + modZ), new ItemStack(itemstack.func_77973_b(), stackSplit, itemstack.func_77960_j()));
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                float baseVelocity = 0.05f;
                entityitem.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * 0.05f;
                entityitem.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * 0.05f + 0.2f;
                entityitem.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * 0.05f;
                this.field_145850_b.func_72838_d((Entity)entityitem);
            }
        }
    }

    protected void destroyThisGrave() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

