/*
 * Decompiled with CFR 0.152.
 */
package two.graves;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import two.graves.API.InventoryHandlerRegistry;
import two.graves.Graves;
import two.graves.GravesAssets;
import two.graves.InitializableModContent;
import two.graves.blocks.BlockGrave;
import two.graves.inventoryhandlers.InventoryHandlerBaubles;
import two.graves.inventoryhandlers.InventoryHandlerTConstruct;
import two.graves.network.PacketForceEquipItems;
import two.graves.tiles.TileGrave;

public class ProxyBase {
    public final String KEY_ITEMS_PER_SECOND = "Items a player can take each tick";
    public final String KEY_PLAYER_CAN_DESTROY_GRAVE = "Players can destroy graves";
    public final String KEY_HANDLE_BAUBLES = "Handle Baubles items";
    public final String KEY_HANDLE_TCONSTRUCT = "Handle Tinker's Construct items";
    protected ArrayList<InitializableModContent> pendingInitialization = new ArrayList();
    protected final AtomicInteger networkID = new AtomicInteger(0);
    final int graveChannelID = this.networkID.getAndIncrement();

    protected void loadGlobalConfigValues() {
        GravesAssets.itemsPerTick = Graves.config.getMiscInteger("Items a player can take each tick", -1);
        GravesAssets.playerCanDestroyGave = Graves.config.getMiscBoolean("Players can destroy graves", true);
        GravesAssets.handleBaubles = Graves.config.getMiscBoolean("Handle Baubles items", true);
        GravesAssets.handleTConstruct = Graves.config.getMiscBoolean("Handle Tinker's Construct items", true);
    }

    protected void registerBlocks() {
        GravesAssets.blockGrave = new BlockGrave();
        this.pendingInitialization.add(GravesAssets.blockGrave);
    }

    protected void registerItems() {
    }

    protected void registerRenderers() {
    }

    protected void registerNetwork() {
        Graves.networkChannel.registerMessage(PacketForceEquipItems.class, PacketForceEquipItems.class, this.graveChannelID, Side.CLIENT);
    }

    protected void registerInventoryHandlers() {
        if (!InventoryHandlerRegistry.isHandlerRegistered("")) {
            throw new IllegalStateException("InventoryHandlerVanilla not registered");
        }
    }

    public void onPreInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onInit() {
        this.loadGlobalConfigValues();
        this.registerBlocks();
        this.registerItems();
        this.registerRenderers();
        this.registerNetwork();
        this.registerInventoryHandlers();
        for (InitializableModContent content : this.pendingInitialization) {
            content.initialize();
        }
        this.pendingInitialization.clear();
    }

    public void onPostInit() {
        if (GravesAssets.handleBaubles && Loader.isModLoaded((String)"Baubles")) {
            InventoryHandlerRegistry.registerHandler(new InventoryHandlerBaubles());
        }
        if (GravesAssets.handleTConstruct && Loader.isModLoaded((String)"TConstruct")) {
            InventoryHandlerRegistry.registerHandler(new InventoryHandlerTConstruct());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=false)
    public void OnDeath(LivingDeathEvent event) {
        ChunkCoordinates deathChestPos;
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer && (player = (EntityPlayer)event.entityLiving) != null && !player.field_70170_p.field_72995_K && (deathChestPos = ProxyBase.findNearestAirBlock(player)) != null) {
            if (player.field_70170_p.func_147465_d(deathChestPos.field_71574_a, deathChestPos.field_71572_b, deathChestPos.field_71573_c, (Block)GravesAssets.blockGrave, 0, 3)) {
                TileEntity tileEntity = player.field_70170_p.func_147438_o(deathChestPos.field_71574_a, deathChestPos.field_71572_b, deathChestPos.field_71573_c);
                if (tileEntity instanceof TileGrave) {
                    ((TileGrave)tileEntity).takePlayerInventory(player);
                } else {
                    FMLLog.severe((String)"Placed Grave, expected %s, but got: %s", (Object[])new Object[]{TileGrave.class.getName(), tileEntity == null ? "null" : tileEntity.getClass().getName()});
                }
            } else {
                FMLLog.severe((String)"Unable to place Grave at %s", (Object[])new Object[]{deathChestPos.toString()});
            }
        }
    }

    protected static ChunkCoordinates findNearestAirBlock(EntityPlayer player) {
        return new ChunkCoordinates((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }
}

