/*
 * Decompiled with CFR 0.152.
 */
package two.graves.API;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryContent {
    protected final String handlerID;
    protected final int slot;
    protected final ItemStack itemStack;
    public static String KEY_TARGET = "InventoryTarget";
    public static String KEY_SLOT = "InventorySlot";

    public InventoryContent(String handlerID, int slot, ItemStack itemStack) {
        if (handlerID == null) {
            throw new IllegalArgumentException("HandlerID cannot be null");
        }
        if (itemStack == null) {
            throw new IllegalArgumentException("ItemStack cannot be null");
        }
        this.handlerID = handlerID;
        this.slot = slot;
        this.itemStack = itemStack;
    }

    public String getHandlerID() {
        return this.handlerID;
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public String toString() {
        return (this.itemStack == null ? "null" : this.itemStack.toString()) + " for handler " + this.handlerID + " @Slot " + this.slot;
    }

    public static InventoryContent readFromNBT(NBTTagCompound tagCompound) {
        return new InventoryContent(tagCompound.func_74779_i(KEY_TARGET), tagCompound.func_74762_e(KEY_SLOT), ItemStack.func_77949_a((NBTTagCompound)tagCompound));
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a(KEY_TARGET, this.handlerID);
        tagCompound.func_74768_a(KEY_SLOT, this.slot);
        this.itemStack.func_77955_b(tagCompound);
    }

    public void toBytes(ByteBuf buffer) throws Exception {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.handlerID);
        buffer.writeInt(this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.itemStack);
    }

    public static InventoryContent fromBytes(ByteBuf buffer) throws Exception {
        String handlerID = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        int slot = buffer.readInt();
        ItemStack itemStack = ByteBufUtils.readItemStack((ByteBuf)buffer);
        return new InventoryContent(handlerID, slot, itemStack);
    }
}

