/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class WorldEditor
implements IWorldEditor {
    World world;
    private Map<Block, Integer> stats;
    private TreasureManager chests;

    public WorldEditor(World world) {
        this.world = world;
        this.stats = new HashMap<Block, Integer>();
        this.chests = new TreasureManager();
    }

    @Override
    public boolean setBlock(Coord pos, MetaBlock block, boolean fillAir, boolean replaceSolid) {
        MetaBlock currentBlock = this.getBlock(pos);
        if (currentBlock.getBlock() == Blocks.field_150486_ae) {
            return false;
        }
        if (currentBlock.getBlock() == Blocks.field_150447_bR) {
            return false;
        }
        if (currentBlock.getBlock() == Blocks.field_150474_ac) {
            return false;
        }
        boolean isAir = this.world.func_147437_c(pos.getX(), pos.getY(), pos.getZ());
        if (!fillAir && isAir) {
            return false;
        }
        if (!replaceSolid && !isAir) {
            return false;
        }
        try {
            this.world.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), block.getBlock(), block.getMeta(), block.getFlag());
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        Block type = block.getBlock();
        Integer count = this.stats.get(type);
        if (count == null) {
            this.stats.put(type, 1);
        } else {
            this.stats.put(type, count + 1);
        }
        return true;
    }

    @Override
    public boolean isAirBlock(Coord pos) {
        return this.world.func_147437_c(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public long getSeed() {
        return this.world.func_72905_C();
    }

    @Override
    public BiomeGenBase getBiome(Coord pos) {
        return this.world.func_72807_a(pos.getX(), pos.getZ());
    }

    @Override
    public int getDimension() {
        return this.world.field_73011_w.field_76574_g;
    }

    @Override
    public Random getSeededRandom(int a, int b, int c) {
        return this.world.func_72843_D(a, b, c);
    }

    @Override
    public void spiralStairStep(Random rand, Coord origin, IStair stair, IBlockFactory fill) {
        MetaBlock air = new MetaBlock(Blocks.field_150350_a);
        Coord start = new Coord(origin);
        start.add(new Coord(-1, 0, -1));
        Coord end = new Coord(origin);
        end.add(new Coord(1, 0, 1));
        RectSolid.fill(this, rand, start, end, air);
        fill.set(this, rand, origin);
        Cardinal dir = Cardinal.directions[origin.getY() % 4];
        Coord cursor = new Coord(origin);
        cursor.add(dir);
        stair.setOrientation(Cardinal.left(dir), false).set(this, cursor);
        cursor.add(Cardinal.right(dir));
        stair.setOrientation(Cardinal.right(dir), true).set(this, cursor);
        cursor.add(Cardinal.reverse(dir));
        stair.setOrientation(Cardinal.reverse(dir), true).set(this, cursor);
    }

    @Override
    public void fillDown(Random rand, Coord origin, IBlockFactory blocks) {
        Coord cursor = new Coord(origin);
        while (!this.getBlock(cursor).getBlock().func_149662_c() && cursor.getY() > 1) {
            blocks.set(this, rand, cursor);
            cursor.add(Cardinal.DOWN);
        }
    }

    @Override
    public MetaBlock getBlock(Coord pos) {
        return new MetaBlock(this.world.func_147439_a(pos.getX(), pos.getY(), pos.getZ()));
    }

    @Override
    public TileEntity getTileEntity(Coord pos) {
        return this.world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
    }

    @Override
    public boolean validGroundBlock(Coord pos) {
        if (this.isAirBlock(pos)) {
            return false;
        }
        MetaBlock block = this.getBlock(pos);
        if (block.getMaterial() == Material.field_151575_d) {
            return false;
        }
        if (block.getMaterial() == Material.field_151586_h) {
            return false;
        }
        if (block.getMaterial() == Material.field_151570_A) {
            return false;
        }
        if (block.getMaterial() == Material.field_151597_y) {
            return false;
        }
        if (block.getMaterial() == Material.field_151577_b) {
            return false;
        }
        if (block.getMaterial() == Material.field_151572_C) {
            return false;
        }
        if (block.getMaterial() == Material.field_151584_j) {
            return false;
        }
        return block.getMaterial() != Material.field_151585_k;
    }

    public String toString() {
        String toReturn = "";
        for (Map.Entry<Block, Integer> pair : this.stats.entrySet()) {
            toReturn = toReturn + pair.getKey().func_149732_F() + ": " + pair.getValue() + "\n";
        }
        return toReturn;
    }

    @Override
    public int getStat(Block type) {
        if (!this.stats.containsKey(type)) {
            return 0;
        }
        return this.stats.get(type);
    }

    @Override
    public void addChest(ITreasureChest toAdd) {
        this.chests.add(toAdd);
    }

    @Override
    public TreasureManager getTreasure() {
        return this.chests;
    }

    @Override
    public boolean canPlace(MetaBlock block, Coord pos, Cardinal dir) {
        if (!this.isAirBlock(pos)) {
            return false;
        }
        Coord cursor = new Coord(pos);
        cursor.add(dir);
        Material m = this.getBlock(cursor).getMaterial();
        return m.func_76222_j();
    }

    @Override
    public void setBlockMetadata(Coord pos, int meta) {
        this.world.func_72921_c(pos.getX(), pos.getY(), pos.getZ(), meta, 2);
    }
}

