/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.armour;

import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.api.spell.APISpellHelper;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.items.armour.BoundArmour;
import WayofTime.alchemicalWizardry.common.omega.OmegaParadigm;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class OmegaArmour
extends BoundArmour {
    public OmegaParadigm paradigm;
    public Reagent reagent;
    protected boolean storeBiomeID = false;
    protected boolean storeDimensionID = false;
    protected boolean storeYLevel = false;
    protected boolean storeSeesSky = false;
    protected List<Enchantment> illegalEnchantmentList = new LinkedList<Enchantment>();
    public float reagentDrainPerDamage = 0.1f;
    @SideOnly(value=Side.CLIENT)
    ModelBiped model1 = null;
    @SideOnly(value=Side.CLIENT)
    ModelBiped model2 = null;
    @SideOnly(value=Side.CLIENT)
    ModelBiped model = null;

    public OmegaArmour(int armorType) {
        super(armorType);
    }

    public void setParadigm(OmegaParadigm paradigm) {
        this.paradigm = paradigm;
    }

    public OmegaParadigm getOmegaParadigm() {
        return this.paradigm;
    }

    public void setReagent(Reagent reagent) {
        this.reagent = reagent;
    }

    @Override
    public boolean isAffectedBySoulHarden() {
        return false;
    }

    @Override
    public double getBaseArmourReduction() {
        return 0.9;
    }

    @Override
    public double getArmourPenetrationReduction() {
        return 0.5;
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (world.func_72820_D() % 50L == 0L) {
            int zCoord;
            int xCoord;
            BiomeGenBase biome;
            if (this.storeBiomeID() && (biome = world.func_72807_a(xCoord = (int)Math.floor(player.field_70165_t), zCoord = (int)Math.floor(player.field_70161_v))) != null) {
                this.setBiomeIDStored(itemStack, biome.field_76756_M);
            }
            if (this.storeDimensionID()) {
                this.setDimensionIDStored(itemStack, world.field_73011_w.field_76574_g);
            }
            if (this.storeYLevel()) {
                this.setYLevelStored(itemStack, (int)Math.floor(player.field_70163_u));
            }
        }
        if (this.field_77881_a == 1) {
            this.paradigm.onUpdate(world, player, itemStack);
            int duration = this.getOmegaStallingDuration(itemStack);
            if (duration > 0) {
                this.setOmegaStallingDuration(itemStack, duration - 1);
            }
        }
    }

    @Override
    public void repairArmour(World world, EntityPlayer player, ItemStack itemStack) {
        if (itemStack.func_77960_j() > 0 && !player.field_71075_bZ.field_75098_d && EnergyItems.syphonBatteries(itemStack, player, itemStack.func_77960_j() * 75)) {
            float reagentAmount = APISpellHelper.getPlayerCurrentReagentAmount(player);
            APISpellHelper.setPlayerCurrentReagentAmount(player, Math.max(0.0f, reagentAmount -= (float)itemStack.func_77960_j() * this.reagentDrainPerDamage));
            itemStack.func_77964_b(0);
        }
    }

    public void revertArmour(EntityPlayer player, ItemStack itemStack) {
        ItemStack stack;
        player.field_71071_by.field_70460_b[3 - this.field_77881_a] = stack = this.getContainedArmourStack(itemStack);
    }

    public ItemStack getSubstituteStack(ItemStack boundStack, int stability, int affinity, int enchantability, int enchantmentLevel, Random rand) {
        ItemStack omegaStack = new ItemStack((Item)this);
        if (boundStack != null && boundStack.func_77942_o()) {
            NBTTagCompound tag = (NBTTagCompound)boundStack.func_77978_p().func_74737_b();
            omegaStack.func_77982_d(tag);
        }
        this.setContainedArmourStack(omegaStack, boundStack);
        SoulNetworkHandler.checkAndSetItemOwner(omegaStack, SoulNetworkHandler.getOwnerName(boundStack));
        this.setItemEnchantability(omegaStack, Math.min(enchantability, 70));
        EnchantmentHelper.func_82782_a(new HashMap(), (ItemStack)omegaStack);
        ArrayList enchantList = new ArrayList();
        int adjustedEnchantLevel = Math.min(enchantmentLevel, 30);
        int additionalPasses = enchantmentLevel - adjustedEnchantLevel;
        for (int i = 0; i < 1 + additionalPasses; ++i) {
            List lst = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)omegaStack, (int)adjustedEnchantLevel);
            if (lst == null) continue;
            enchantList.addAll(lst);
        }
        HashMap map = new HashMap();
        for (Object obj : enchantList) {
            Map numMap;
            EnchantmentData enchantmentdata = (EnchantmentData)obj;
            if (!map.containsKey(enchantmentdata.field_76302_b)) {
                map.put(enchantmentdata.field_76302_b, new HashMap());
            }
            if ((numMap = (Map)map.get(enchantmentdata.field_76302_b)).containsKey(enchantmentdata.field_76303_c)) {
                numMap.put(enchantmentdata.field_76303_c, (Integer)numMap.get(enchantmentdata.field_76303_c) + 1);
                continue;
            }
            numMap.put(enchantmentdata.field_76303_c, 1);
        }
        for (Enchantment ench : this.illegalEnchantmentList) {
            if (!map.containsKey(ench)) continue;
            map.remove(ench);
        }
        ArrayList<EnchantmentData> newEnchantList = new ArrayList<EnchantmentData>();
        for (Map.Entry entry : map.entrySet()) {
            Enchantment ench = (Enchantment)entry.getKey();
            Map numMap = (Map)entry.getValue();
            if (numMap.isEmpty()) continue;
            int[] enchantValues = new int[1];
            for (Map.Entry entry1 : numMap.entrySet()) {
                int enchantLevel = (Integer)entry1.getKey();
                int number = (Integer)entry1.getValue();
                if (enchantLevel >= enchantValues.length) {
                    int[] newEnchantValues = new int[enchantLevel + 1];
                    for (int i = 0; i < enchantValues.length; ++i) {
                        newEnchantValues[i] = enchantValues[i];
                    }
                    enchantValues = newEnchantValues;
                }
                int n = enchantLevel;
                enchantValues[n] = enchantValues[n] + number;
            }
            int size = enchantValues.length;
            for (int i = 0; i < size; ++i) {
                int number = enchantValues[i];
                if (number < 2 || i + 1 < size) continue;
                int[] newEnchantValues = new int[i + 2];
                for (int z = 0; z < enchantValues.length; ++z) {
                    newEnchantValues[z] = enchantValues[z];
                }
                enchantValues = newEnchantValues;
                int n = i + 1;
                enchantValues[n] = enchantValues[n] + number / 2;
                size = enchantValues.length;
            }
            newEnchantList.add(new EnchantmentData(ench, enchantValues.length - 1));
        }
        for (EnchantmentData enchantmentdata : newEnchantList) {
            omegaStack.func_77966_a(enchantmentdata.field_76302_b, enchantmentdata.field_76303_c);
        }
        for (int i = 0; i < 1; ++i) {
        }
        return omegaStack;
    }

    public void setContainedArmourStack(ItemStack omegaStack, ItemStack boundStack) {
        if (omegaStack == null || boundStack == null) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        boundStack.func_77955_b(tag);
        NBTTagCompound omegaTag = omegaStack.func_77978_p();
        if (omegaTag == null) {
            omegaTag = new NBTTagCompound();
            omegaStack.func_77982_d(omegaTag);
        }
        omegaTag.func_74782_a("armour", (NBTBase)tag);
    }

    public ItemStack getContainedArmourStack(ItemStack omegaStack) {
        NBTTagCompound omegaTag = omegaStack.func_77978_p();
        if (omegaTag == null) {
            return null;
        }
        NBTTagCompound tag = omegaTag.func_74775_l("armour");
        ItemStack armourStack = ItemStack.func_77949_a((NBTTagCompound)tag);
        return armourStack;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "alchemicalwizardry:models/armor/OmegaWater.png";
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ModelBiped getChestModel();

    @SideOnly(value=Side.CLIENT)
    public abstract ModelBiped getLegsModel();

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (tryComplexRendering) {
            int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
            if (this.model1 == null) {
                this.model1 = this.getChestModel();
            }
            if (this.model2 == null) {
                this.model2 = this.getLegsModel();
            }
            this.model = type == 1 || type == 3 || type == 0 ? this.model1 : this.model2;
            if (this.model != null) {
                this.model.field_78116_c.field_78806_j = type == 0;
                this.model.field_78114_d.field_78806_j = type == 0;
                this.model.field_78115_e.field_78806_j = type == 1 || type == 2;
                this.model.field_78113_g.field_78806_j = type == 1;
                this.model.field_78112_f.field_78806_j = type == 1;
                this.model.field_78124_i.field_78806_j = type == 2 || type == 3;
                this.model.field_78123_h.field_78806_j = type == 2 || type == 3;
                this.model.field_78117_n = entityLiving.func_70093_af();
                this.model.field_78093_q = entityLiving.func_70115_ae();
                this.model.field_78091_s = entityLiving.func_70631_g_();
                this.model.field_78118_o = false;
                int n = this.model.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
                if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
                    EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
                    if (enumaction == EnumAction.block) {
                        this.model.field_78120_m = 3;
                    } else if (enumaction == EnumAction.bow) {
                        this.model.field_78118_o = true;
                    }
                }
            }
            return this.model;
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot);
    }

    public void onOmegaKeyPressed(EntityPlayer player, ItemStack stack) {
        if (this.paradigm != null) {
            this.paradigm.onOmegaKeyPressed(player, stack);
        }
    }

    public void setOmegaStallingDuration(ItemStack stack, int duration) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a("OmegaStallDuration", duration);
    }

    public int getOmegaStallingDuration(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag.func_74762_e("OmegaStallDuration");
    }

    public boolean hasOmegaStalling(ItemStack stack) {
        return this.getOmegaStallingDuration(stack) > 0;
    }

    public boolean storeBiomeID() {
        return this.storeBiomeID;
    }

    public boolean storeDimensionID() {
        return this.storeDimensionID;
    }

    public boolean storeYLevel() {
        return this.storeYLevel;
    }

    public boolean storeSeesSky() {
        return this.storeSeesSky;
    }

    public int getBiomeIDStored(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag.func_74762_e("biomeID");
    }

    public void setBiomeIDStored(ItemStack stack, int id) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a("biomeID", id);
    }

    public int getDimensionIDStored(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag.func_74762_e("dimensionID");
    }

    public void setDimensionIDStored(ItemStack stack, int id) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a("dimensionID", id);
    }

    public int getYLevelStored(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag.func_74762_e("yLevel");
    }

    public void setYLevelStored(ItemStack stack, int level) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a("yLevel", level);
    }
}

