/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities;

import com.brandon3055.draconicevolution.common.container.ContainerPlayerDetector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TilePlayerDetectorAdvanced
extends TileEntity
implements IInventory {
    public String[] names = new String[42];
    private ItemStack[] items;
    public boolean whiteList = false;
    public int range = 10;
    private int tick = 0;
    private int scanRate = 5;
    public boolean output = false;
    public boolean outputInverted = false;
    private List<EntityLiving> EntityList;

    public TilePlayerDetectorAdvanced() {
        for (int i = 0; i < this.names.length; ++i) {
            if (this.names[i] != null) continue;
            this.names[i] = "";
        }
        this.items = new ItemStack[1];
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tick >= this.scanRate) {
            this.tick = 0;
            if (this.shouldEmit()) {
                if (!this.output) {
                    this.setOutput(true);
                }
            } else if (this.output) {
                this.setOutput(false);
            }
        } else {
            ++this.tick;
        }
    }

    public boolean shouldEmit() {
        this.findEntitys();
        boolean b = false;
        for (Entity entity : this.EntityList) {
            if (!(entity instanceof EntityPlayer)) {
                return false;
            }
            String name = ((EntityPlayer)entity).func_70005_c_();
            if (!(this.whiteList ? this.isPlayerListed(name) : !this.isPlayerListed(name))) continue;
            return true;
        }
        return b;
    }

    private void findEntitys() {
        double x1 = (double)this.field_145851_c + 0.5 - (double)this.range;
        double y1 = (double)this.field_145848_d + 0.5 - (double)this.range;
        double z1 = (double)this.field_145849_e + 0.5 - (double)this.range;
        double x2 = (double)this.field_145851_c + 0.5 + (double)this.range;
        double y2 = (double)this.field_145848_d + 0.5 + (double)this.range;
        double z2 = (double)this.field_145849_e + 0.5 + (double)this.range;
        this.EntityList = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    private void setOutput(boolean out) {
        this.output = out;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.updateBlocks();
    }

    public void updateBlocks() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.field_145850_b.func_147459_d(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.field_145850_b.func_147459_d(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public boolean isPlayerListed(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int count) {
        ItemStack itemstack = this.func_70301_a(i);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(i, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
                if (itemstack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.func_70301_a(i);
        if (item != null) {
            this.func_70299_a(i, null);
        }
        return item;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.items[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.4) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer) {
        return new ContainerPlayerDetector(inventoryplayer, this);
    }

    public void func_145841_b(NBTTagCompound compound) {
        int i;
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (i = 0; i < this.items.length; ++i) {
            tag[i] = new NBTTagCompound();
            if (this.items[i] != null) {
                tag[i] = this.items[i].func_77955_b(tag[i]);
            }
            compound.func_74782_a("Item" + i, (NBTBase)tag[i]);
        }
        for (i = 0; i < this.names.length; ++i) {
            String name = this.names[i] != null ? this.names[i] : "";
            compound.func_74778_a("Name_" + i, name);
        }
        compound.func_74757_a("WhiteList", this.whiteList);
        compound.func_74757_a("Output", this.output);
        compound.func_74768_a("Range", this.range);
        compound.func_74757_a("OutputInverted", this.outputInverted);
        super.func_145841_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        int i;
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (i = 0; i < this.items.length; ++i) {
            tag[i] = compound.func_74775_l("Item" + i);
            this.items[i] = ItemStack.func_77949_a((NBTTagCompound)tag[i]);
        }
        for (i = 0; i < this.names.length; ++i) {
            this.names[i] = compound.func_74779_i("Name_" + i);
        }
        this.whiteList = compound.func_74767_n("WhiteList");
        this.range = compound.func_74762_e("Range");
        this.output = compound.func_74767_n("Output");
        this.outputInverted = compound.func_74767_n("OutputInverted");
        super.func_145839_a(compound);
    }
}

