/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.FeatureRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractMultiBlock {
    public final Set<TEBase> getBlocks(TEBase TE, Block block) {
        HashSet<TEBase> set = new HashSet<TEBase>();
        int matchData = this.getMatchingDataPattern(TE);
        ForgeDirection[] dirs = this.getLocateDirs(TE);
        this.addAndLocateBlocks(TE, block, matchData, dirs, set);
        return set;
    }

    private void addAndLocateBlocks(TEBase TE, Block block, int matchData, ForgeDirection[] dirs, Set<TEBase> set) {
        if (set.size() > FeatureRegistry.multiBlockSizeLimit) {
            return;
        }
        if (set.contains(TE)) {
            return;
        }
        set.add(TE);
        for (ForgeDirection dir : dirs) {
            TEBase TE_adj = BlockProperties.getTileEntity(block, TE.func_145831_w(), TE.field_145851_c - dir.offsetX, TE.field_145848_d - dir.offsetY, TE.field_145849_e - dir.offsetZ);
            if (TE_adj == null || (TE_adj.getData() & matchData) != matchData) continue;
            this.addAndLocateBlocks(TE_adj, block, matchData, dirs, set);
        }
    }

    public abstract int getMatchingDataPattern(TEBase var1);

    public abstract ForgeDirection[] getLocateDirs(TEBase var1);
}

