/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import mcp.mobius.waila.api.IWailaCommonAccessor;
import mcp.mobius.waila.api.IWailaTooltipRenderer;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.OverlayConfig;
import mcp.mobius.waila.overlay.tooltiprenderers.TTRenderIcon;
import mcp.mobius.waila.overlay.tooltiprenderers.TTRenderString;
import mcp.mobius.waila.utils.Constants;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class Tooltip {
    public static int TabSpacing = 8;
    public static int IconSize = 8;
    ArrayList<ArrayList<String>> lines = new ArrayList();
    ArrayList<ArrayList<Integer>> sizes = new ArrayList();
    ArrayList<Integer> columnsWidth = new ArrayList();
    ArrayList<Integer> columnsPos = new ArrayList();
    ArrayList<Renderable> elements = new ArrayList();
    ArrayList<Renderable> elements2nd = new ArrayList();
    int w;
    int h;
    int x;
    int y;
    int ty;
    int offsetX;
    int maxStringW;
    Point pos;
    boolean hasIcon = false;
    ItemStack stack;
    IWailaCommonAccessor accessor = DataAccessorCommon.instance;

    public Tooltip(List<String> textData, ItemStack stack) {
        this(textData, true);
        this.stack = stack;
    }

    public Tooltip(List<String> textData, boolean hasIcon) {
        this.columnsWidth.add(0);
        this.columnsPos.add(0);
        for (String s : textData) {
            ArrayList<String> line = new ArrayList<String>(Arrays.asList(SpecialChars.patternTab.split(s)));
            ArrayList<Integer> size = new ArrayList<Integer>();
            for (String ss : line) {
                size.add(DisplayUtil.getDisplayWidth(ss));
            }
            if (line.size() > 1) {
                while (this.columnsWidth.size() < line.size()) {
                    this.columnsWidth.add(0);
                    this.columnsPos.add(0);
                }
                for (int i = 0; i < line.size(); ++i) {
                    this.columnsWidth.set(i, Math.max(this.columnsWidth.get(i), (Integer)size.get(i)));
                }
            }
            this.maxStringW = Math.max(this.maxStringW, DisplayUtil.getDisplayWidth(s) + TabSpacing * (line.size() - 1));
            this.lines.add(line);
            this.sizes.add(size);
        }
        if (this.columnsWidth.size() == 1) {
            this.columnsWidth.set(0, this.maxStringW);
        }
        for (int i = 1; i < this.columnsWidth.size(); ++i) {
            this.columnsPos.set(i, this.columnsWidth.get(i - 1) + this.columnsPos.get(i - 1) + TabSpacing);
        }
        this.computeRenderables();
        this.computePositionAndSize(hasIcon);
    }

    private void computeRenderables() {
        int offsetY = 0;
        for (int i = 0; i < this.lines.size(); ++i) {
            int maxHeight = 0;
            for (int c = 0; c < this.lines.get(i).size(); ++c) {
                this.offsetX = this.columnsPos.get(c);
                String currentLine = this.lines.get(i).get(c);
                Matcher lineMatcher = SpecialChars.patternLineSplit.matcher(currentLine);
                while (lineMatcher.find()) {
                    String cs = lineMatcher.group();
                    Renderable renderable = null;
                    Matcher renderMatcher = SpecialChars.patternRender.matcher(cs);
                    Matcher iconMatcher = SpecialChars.patternIcon.matcher(cs);
                    if (renderMatcher.find()) {
                        String renderName = renderMatcher.group("name");
                        IWailaTooltipRenderer renderer = ModuleRegistrar.instance().getTooltipRenderer(renderName);
                        if (renderer != null) {
                            renderable = new Renderable(renderer, new Point(this.offsetX, offsetY), renderMatcher.group("args").split(","));
                            this.elements2nd.add(renderable);
                        }
                    } else if (iconMatcher.find()) {
                        renderable = new Renderable(new TTRenderIcon(iconMatcher.group("type")), new Point(this.offsetX, offsetY));
                        this.elements2nd.add(renderable);
                    } else {
                        if (cs.startsWith(SpecialChars.ALIGNRIGHT)) {
                            this.offsetX += this.columnsWidth.get(c) - DisplayUtil.getDisplayWidth(currentLine.substring(lineMatcher.start()));
                        }
                        if (cs.startsWith(SpecialChars.ALIGNCENTER)) {
                            this.offsetX += (this.columnsWidth.get(c) - DisplayUtil.getDisplayWidth(currentLine.substring(lineMatcher.start()))) / 2;
                        }
                        renderable = new Renderable(new TTRenderString(DisplayUtil.stripWailaSymbols(cs)), new Point(this.offsetX, offsetY));
                        this.elements.add(renderable);
                    }
                    if (renderable == null) continue;
                    this.offsetX += renderable.getSize((IWailaCommonAccessor)this.accessor).width;
                    maxHeight = Math.max(maxHeight, renderable.getSize((IWailaCommonAccessor)this.accessor).height + 2);
                }
            }
            offsetY += maxHeight;
        }
    }

    private int getRenderableTotalHeight() {
        int result = 0;
        for (Renderable r : this.elements) {
            result = Math.max(r.getPos().y + r.getSize((IWailaCommonAccessor)this.accessor).height + 2, result);
        }
        return result;
    }

    private void computePositionAndSize(boolean hasIcon) {
        this.pos = new Point(ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_POSX, 0), ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_POSY, 0));
        this.hasIcon = hasIcon;
        int paddingW = hasIcon ? 29 : 13;
        int paddingH = hasIcon ? 24 : 0;
        this.offsetX = hasIcon ? 24 : 6;
        this.w = this.maxStringW + paddingW;
        this.h = Math.max(paddingH, this.getRenderableTotalHeight() + 8);
        Dimension size = DisplayUtil.displaySize();
        this.x = ((int)((float)size.width / OverlayConfig.scale) - this.w - 1) * this.pos.x / 10000;
        this.y = ((int)((float)size.height / OverlayConfig.scale) - this.h - 1) * this.pos.y / 10000;
        this.ty = (this.h - this.getRenderableTotalHeight()) / 2 + 1;
    }

    public void draw() {
        for (Renderable r : this.elements) {
            r.draw(this.accessor, this.x + this.offsetX, this.y + this.ty);
        }
    }

    public void draw2nd() {
        for (Renderable r : this.elements2nd) {
            r.draw(this.accessor, this.x + this.offsetX, this.y + this.ty);
        }
    }

    private class Renderable {
        final IWailaTooltipRenderer renderer;
        final Point pos;
        final String[] params;

        public Renderable(IWailaTooltipRenderer renderer, Point pos, String[] params) {
            this.renderer = renderer;
            this.pos = pos;
            this.params = params;
        }

        public Renderable(IWailaTooltipRenderer renderer, Point pos) {
            this(renderer, pos, new String[0]);
        }

        public Point getPos() {
            return this.pos;
        }

        public Dimension getSize(IWailaCommonAccessor accessor) {
            Dimension dim = new Dimension(0, 0);
            try {
                dim = this.renderer.getSize(this.params, accessor);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, this.renderer.getClass().getName() + ".getSize()", null);
            }
            return dim;
        }

        public void draw(IWailaCommonAccessor accessor, int x, int y) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + this.pos.x), (float)(y + this.pos.y), (float)0.0f);
            try {
                this.renderer.draw(this.params, accessor);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, this.renderer.getClass().getName() + ".draw()", null);
            }
            GL11.glPopMatrix();
        }

        public String toString() {
            return String.format("Renderable@[%d,%d] | %s", this.pos.x, this.pos.y, this.renderer);
        }
    }
}

