/*
 * Decompiled with CFR 0.152.
 */
package com.ae.additions.utils.asm;

import com.ae.additions.utils.asm.ASMUtils;
import com.ae.additions.utils.asm.MethodDescription;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PrivateMethodInvoker {
    private final String owner;
    private final String name;
    private final MethodDescription desc;
    private final boolean isStatic;

    public PrivateMethodInvoker(String owner, String name, MethodDescription desc, boolean isStatic) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
        this.isStatic = isStatic;
    }

    public PrivateMethodInvoker(String owner, String name, MethodDescription desc) {
        this(owner, name, desc, false);
    }

    public MethodInsnNode getNode() {
        int invoke = this.isStatic ? 184 : 183;
        return new MethodInsnNode(invoke, this.owner, this.name, this.desc.build(), false);
    }

    public MethodNode generate(String name) {
        MethodNode node = new MethodNode(1 | (this.isStatic ? 8 : 0), name, this.desc.build(), null, null);
        InsnList list = node.instructions;
        if (!this.isStatic) {
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        for (int i = 0; i < this.desc.getArgumentsSize(); ++i) {
            list.add((AbstractInsnNode)new VarInsnNode(ASMUtils.getLoadOpcodeFromType(this.desc.getArgument(i)), this.isStatic ? i : i + 1));
        }
        list.add((AbstractInsnNode)this.getNode());
        list.add((AbstractInsnNode)new InsnNode(ASMUtils.getReturnOpcodeFromType(this.desc.getReturnType())));
        return node;
    }

    public MethodNode generate() {
        return this.generate("call" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1));
    }
}

