/*
 * Decompiled with CFR 0.152.
 */
package com.ae.additions.utils.asm;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;

public class MethodDescription {
    private List<Type> arguments;
    private Type returnType;

    public MethodDescription(Type returnType, Type ... arguments) {
        this.returnType = returnType;
        this.arguments = Arrays.asList(arguments);
    }

    public MethodDescription(String returnType, String ... arguments) {
        this.returnType = Type.getType((String)returnType);
        this.arguments = Arrays.stream(arguments).map(Type::getType).collect(Collectors.toList());
    }

    public String build() {
        StringBuilder desc = new StringBuilder("(");
        for (Type t : this.arguments) {
            desc.append(t.getDescriptor());
        }
        desc.append(")");
        desc.append(this.returnType.getDescriptor());
        return desc.toString();
    }

    public int getArgumentsSize() {
        return this.arguments.size();
    }

    public Type getArgument(int index) {
        return this.arguments.get(index);
    }

    public Type getReturnType() {
        return this.returnType;
    }
}

