/*
 * Decompiled with CFR 0.152.
 */
package com.ae.additions.utils.asm;

import com.ae.additions.utils.asm.ASMUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FieldGetter {
    private final String owner;
    private final String name;
    private final Type type;
    private final boolean isStatic;

    public FieldGetter(String owner, String name, Type type, boolean isStatic) {
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
    }

    public FieldGetter(String owner, String name, Type type) {
        this(owner, name, type, false);
    }

    public FieldInsnNode getNode() {
        return new FieldInsnNode(this.isStatic ? 178 : 180, this.owner, this.name, this.type.getDescriptor());
    }

    public MethodNode generateAccessorMethod(String name) {
        MethodNode node = new MethodNode(1 | (this.isStatic ? 8 : 0), name, Type.getMethodDescriptor((Type)this.type, (Type[])new Type[0]), null, null);
        InsnList list = node.instructions;
        if (!this.isStatic) {
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        list.add((AbstractInsnNode)this.getNode());
        list.add((AbstractInsnNode)new InsnNode(ASMUtils.getReturnOpcodeFromType(this.type)));
        return node;
    }

    public MethodNode generateAccessorMethod() {
        return this.generateAccessorMethod("get" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1));
    }
}

