/*
 * Decompiled with CFR 0.152.
 */
package com.ae.additions.utils;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import com.ae.additions.utils.IDualityInterface;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class THybridDualityInterface
extends DualityInterface
implements IDualityInterface {
    public static final int NUMBER_OF_PATTERN_SLOTS = 27;
    private final AppEngInternalInventory patterns = new AppEngInternalInventory((IAEAppEngInventory)this, 27);

    public THybridDualityInterface(AENetworkProxy networkProxy, IInterfaceHost ih) {
        super(networkProxy, ih);
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.getIsWorking()) {
            return;
        }
        if (inv == this.getConfig()) {
            this.callReadConfig();
        } else if (inv == this.patterns && (removed != null || added != null)) {
            this.callUpdateCraftingList();
        } else if (inv == this.getStorage() && slot >= 0) {
            boolean had = this.callHasWorkToDo();
            this.callUpdatePlan(slot);
            boolean now = this.callHasWorkToDo();
            if (had != now) {
                try {
                    if (now) {
                        this.getProxy().getTick().alertDevice(this.getProxy().getNode());
                    } else {
                        this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
                    }
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.patterns.writeToNBT(data, "patterns1");
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.patterns.readFromNBT(data, "patterns1");
    }

    public AppEngInternalInventory getPatterns() {
        return this.patterns;
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("patterns")) {
            return this.patterns;
        }
        return super.getInventoryByName(name);
    }

    public void addDrops(List<ItemStack> drops) {
        for (ItemStack is : this.patterns) {
            if (is == null) continue;
            drops.add(is);
        }
        super.addDrops(drops);
    }

    @Override
    public boolean isOverrideDefault() {
        return true;
    }

    @Override
    public void updateCraftingListProxy() {
        Object[] accountedFor = new Boolean[27];
        Arrays.fill(accountedFor, (Object)false);
        assert (accountedFor.length == this.patterns.func_70302_i_());
        if (!this.getProxy().isReady()) {
            return;
        }
        if (this.getCraftingList() != null) {
            Iterator i = this.getCraftingList().iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = (ICraftingPatternDetails)i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.patterns.func_70301_a(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (((Boolean)accountedFor[x]).booleanValue()) continue;
            this.callAddToCraftingList(this.patterns.func_70301_a(x));
        }
        try {
            AENetworkProxy proxy = this.getProxy();
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, proxy.getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }
}

