/*
 * Decompiled with CFR 0.152.
 */
package com.ae.additions.parts;

import appeng.api.config.Upgrades;
import appeng.parts.AEBasePart;
import com.ae.additions.AAModItems;
import com.ae.additions.parts.PartAdvancedInterface;
import com.ae.additions.parts.PartHybridInterface;
import com.ae.additions.parts.PartUltimateInterface;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public enum EnumParts {
    PART_ADV_INTERFACE("item.part_adv_interface", PartAdvancedInterface.class),
    PART_HYBRID_INTERFACE("item.part_hybrid_interface", PartHybridInterface.class),
    PART_ULTIMATE_INTERFACE("item.part_ultimate_interface", PartUltimateInterface.class);

    public static final EnumParts[] VALUES;
    private final String unlocalizedName;
    private final Class<? extends AEBasePart> partClass;
    private final String groupName;
    private final Map<Upgrades, Integer> upgrades = new HashMap<Upgrades, Integer>();

    private EnumParts(String unlocalizedName, Class<? extends AEBasePart> partClass) {
        this(unlocalizedName, partClass, null);
    }

    private EnumParts(String unlocalizedName, Class<? extends AEBasePart> partClass, String groupName) {
        this.unlocalizedName = unlocalizedName;
        this.partClass = partClass;
        this.groupName = groupName;
    }

    private EnumParts(String unlocalizedName, Class<? extends AEBasePart> partClass, String groupName, Pair<Upgrades, Integer> ... upgrades) {
        this(unlocalizedName, partClass, groupName);
        for (Pair<Upgrades, Integer> pair : upgrades) {
            this.upgrades.put((Upgrades)pair.getKey(), (Integer)pair.getValue());
        }
    }

    private static Pair<Upgrades, Integer> generatePair(Upgrades upgrade, int maximum) {
        return new ImmutablePair((Object)upgrade, (Object)maximum);
    }

    public static EnumParts getPartFromDamageValue(ItemStack itemStack) {
        int clamped = MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)(VALUES.length - 1));
        return VALUES[clamped];
    }

    public static int getPartID(Class<? extends AEBasePart> partClass) {
        int id = -1;
        for (int i = 0; i < VALUES.length; ++i) {
            if (!VALUES[i].getPartClass().equals(partClass)) continue;
            id = i;
            break;
        }
        return id;
    }

    public AEBasePart createPartInstance(ItemStack itemStack) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        AEBasePart part = this.partClass.getConstructor(ItemStack.class).newInstance(itemStack);
        return part;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.unlocalizedName, (Object[])new Object[0]);
    }

    public Class<? extends AEBasePart> getPartClass() {
        return this.partClass;
    }

    public ItemStack getStack() {
        return new ItemStack((Item)AAModItems.ITEM_PARTS, 1, this.ordinal());
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public Map<Upgrades, Integer> getUpgrades() {
        return this.upgrades;
    }

    static {
        VALUES = EnumParts.values();
    }
}

