/*
 * Decompiled with CFR 0.152.
 */
package com.ae.additions.asm;

import com.ae.additions.utils.asm.ASMUtils;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class AEClassTransformer
implements IClassTransformer {
    public static final boolean IS_DEV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");

    private static byte[] transformGuiPriority(byte[] basicClass) {
        AbstractInsnNode point;
        ClassNode classNode = ASMUtils.readClass(basicClass);
        MethodNode methodNode = ASMUtils.findMethod(classNode, "initGui", "func_73866_w_");
        if (methodNode != null && (point = ASMUtils.findSequence(methodNode.instructions, true, 25, 180, 198, 25, 198)) != null) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 6));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "appeng/client/gui/implementations/GuiPriority", "OriginalGui", "Lappeng/core/sync/GuiBridge;"));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "com/ae/additions/asm/AEHooks", "getGui", "(Ljava/lang/Object;Lappeng/core/sync/GuiBridge;)Lappeng/core/sync/GuiBridge;", false));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new InsnNode(95));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "appeng/client/gui/implementations/GuiPriority", "OriginalGui", "Lappeng/core/sync/GuiBridge;"));
            list.add((AbstractInsnNode)new VarInsnNode(25, 6));
            list.add((AbstractInsnNode)new VarInsnNode(25, 5));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "com/ae/additions/asm/AEHooks", "getItem", "(Ljava/lang/Object;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", false));
            list.add((AbstractInsnNode)new VarInsnNode(58, 5));
            methodNode.instructions.insertBefore(point, list);
        }
        return ASMUtils.writeClass(classNode);
    }

    private static byte[] transformContainerInterfaceTerminal(byte[] basicClass) {
        ClassNode classNode = ASMUtils.readClass(basicClass);
        MethodNode methodNode = ASMUtils.findMethod(classNode, "addItems");
        if (methodNode == null) {
            return basicClass;
        }
        AbstractInsnNode point = ASMUtils.findSequence(methodNode.instructions, true, 25, 18, 25, 184, 182);
        if (point == null) {
            return null;
        }
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 6));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)"invSize"));
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "appeng/container/implementations/ContainerInterfaceTerminal$InvTracker", "access$100", "(Lappeng/container/implementations/ContainerInterfaceTerminal$InvTracker;)Lnet/minecraft/inventory/IInventory;", false));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/inventory/IInventory", IS_DEV ? "getSizeInventory" : "func_70302_i_", "()I", true));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/nbt/NBTTagCompound", IS_DEV ? "setInteger" : "func_74768_a", "(Ljava/lang/String;I)V", false));
        methodNode.instructions.insertBefore(point, list);
        return ASMUtils.writeClass(classNode);
    }

    private static byte[] transformGrid(byte[] basicClass) {
        ClassNode classNode = ASMUtils.readClass(basicClass);
        MethodNode methodNode = ASMUtils.findMethod(classNode, "getMachines");
        if (methodNode == null) {
            return basicClass;
        }
        List<AbstractInsnNode> points = ASMUtils.findAllOpcodes(methodNode.instructions, 176);
        if (points.isEmpty()) {
            return basicClass;
        }
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "com/ae/additions/asm/AEHooks", "getMachines", "(Lappeng/me/MachineSet;Lappeng/me/Grid;)Lappeng/api/networking/IMachineSet;", false));
        points.forEach(point -> methodNode.instructions.insertBefore(point, ASMUtils.copy(list)));
        MethodNode generated = new MethodNode(1, "getMachinesSafe", "(Ljava/lang/Class;)Lappeng/api/networking/IMachineSet;", null, null);
        LabelNode label = new LabelNode();
        InsnList l = generated.instructions;
        l.add((AbstractInsnNode)new VarInsnNode(25, 0));
        l.add((AbstractInsnNode)new FieldInsnNode(180, "appeng/me/Grid", "machines", "Ljava/util/Map;"));
        l.add((AbstractInsnNode)new VarInsnNode(25, 1));
        l.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true));
        l.add((AbstractInsnNode)new TypeInsnNode(192, "appeng/me/MachineSet"));
        l.add((AbstractInsnNode)new VarInsnNode(58, 2));
        l.add((AbstractInsnNode)new VarInsnNode(25, 2));
        l.add((AbstractInsnNode)new JumpInsnNode(199, label));
        l.add((AbstractInsnNode)new TypeInsnNode(187, "appeng/me/MachineSet"));
        l.add((AbstractInsnNode)new InsnNode(89));
        l.add((AbstractInsnNode)new VarInsnNode(25, 1));
        l.add((AbstractInsnNode)new MethodInsnNode(183, "appeng/me/MachineSet", "<init>", "(Ljava/lang/Class;)V", false));
        l.add((AbstractInsnNode)new InsnNode(176));
        l.add((AbstractInsnNode)label);
        l.add((AbstractInsnNode)new VarInsnNode(25, 2));
        l.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(generated);
        return ASMUtils.writeClass(classNode);
    }

    private static byte[] transformCraftingCPUCluster(byte[] basicClass) {
        ClassNode classNode = ASMUtils.readClass(basicClass);
        MethodNode methodNode = ASMUtils.findMethod(classNode, "addTile");
        if (methodNode == null) {
            return basicClass;
        }
        AbstractInsnNode point = ASMUtils.findSequenceLast(methodNode.instructions, true, 25, 89, 180, 4, 96, 181);
        if (point == null) {
            return null;
        }
        InsnList list = new InsnList();
        LabelNode label = new LabelNode();
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new TypeInsnNode(193, "com/ae/additions/utils/IAdvancedAccelerator"));
        list.add((AbstractInsnNode)new JumpInsnNode(153, label));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new TypeInsnNode(192, "com/ae/additions/utils/IAdvancedAccelerator"));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "com/ae/additions/utils/IAdvancedAccelerator", "getAcceleratorCount", "()I", true));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "appeng/me/cluster/implementations/CraftingCPUCluster", "accelerator", "I"));
        list.add((AbstractInsnNode)new InsnNode(96));
        list.add((AbstractInsnNode)new InsnNode(2));
        list.add((AbstractInsnNode)new InsnNode(96));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new InsnNode(95));
        list.add((AbstractInsnNode)new FieldInsnNode(181, "appeng/me/cluster/implementations/CraftingCPUCluster", "accelerator", "I"));
        list.add((AbstractInsnNode)label);
        methodNode.instructions.insert(point, list);
        return ASMUtils.writeClass(classNode);
    }

    private static byte[] transformDualityInterface(byte[] basicClass) {
        ClassNode classNode = ASMUtils.readClass(basicClass);
        MethodNode methodNode = ASMUtils.findMethod(classNode, "updateCraftingList");
        if (methodNode == null) {
            return basicClass;
        }
        classNode.interfaces.add("com/ae/additions/utils/IDualityInterface");
        InsnList list = new InsnList();
        LabelNode label = new LabelNode();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new TypeInsnNode(192, "com/ae/additions/utils/IDualityInterface"));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "com/ae/additions/utils/IDualityInterface", "isOverrideDefault", "()Z", true));
        list.add((AbstractInsnNode)new JumpInsnNode(153, label));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new TypeInsnNode(192, "com/ae/additions/utils/IDualityInterface"));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "com/ae/additions/utils/IDualityInterface", "updateCraftingListProxy", "()V", true));
        list.add((AbstractInsnNode)new InsnNode(177));
        list.add((AbstractInsnNode)label);
        methodNode.instructions.insert(list);
        classNode.methods.add(ASMUtils.generateGetter("getProxy", "Lappeng/me/helpers/AENetworkProxy;", 180, "appeng/helpers/DualityInterface", "gridProxy", 176));
        classNode.methods.add(ASMUtils.generateGetter("getCraftingList", "Ljava/util/List;", 180, "appeng/helpers/DualityInterface", "craftingList", 176));
        classNode.methods.add(ASMUtils.generateGetter("getIsWorking", "Z", 180, "appeng/helpers/DualityInterface", "isWorking", 172));
        MethodNode generated = new MethodNode(327680, 1, "callAddToCraftingList", "(Lnet/minecraft/item/ItemStack;)V", null, null);
        list = generated.instructions;
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "appeng/helpers/DualityInterface", "addToCraftingList", "(Lnet/minecraft/item/ItemStack;)V", false));
        list.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(generated);
        generated = new MethodNode(327680, 1, "callReadConfig", "()V", null, null);
        list = generated.instructions;
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "appeng/helpers/DualityInterface", "readConfig", "()V", false));
        list.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(generated);
        generated = new MethodNode(327680, 1, "callUpdateCraftingList", "()V", null, null);
        list = generated.instructions;
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "appeng/helpers/DualityInterface", "updateCraftingList", "()V", false));
        list.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(generated);
        generated = new MethodNode(327680, 1, "callUpdatePlan", "(I)V", null, null);
        list = generated.instructions;
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(21, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "appeng/helpers/DualityInterface", "updatePlan", "(I)V", false));
        list.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(generated);
        generated = new MethodNode(327680, 1, "callHasWorkToDo", "()Z", null, null);
        list = generated.instructions;
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "appeng/helpers/DualityInterface", "hasWorkToDo", "()Z", false));
        list.add((AbstractInsnNode)new InsnNode(172));
        classNode.methods.add(generated);
        return ASMUtils.writeClass(classNode);
    }

    private static byte[] transformTileInterface(byte[] basicClass) {
        ClassNode classNode = ASMUtils.readClass(basicClass);
        classNode.interfaces.add("com/ae/additions/utils/ITileInterface");
        MethodNode generated = new MethodNode(327680, 1, "setDuality", "(Lappeng/helpers/DualityInterface;)V", null, null);
        InsnList list = generated.instructions;
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new FieldInsnNode(181, "appeng/tile/misc/TileInterface", "duality", "Lappeng/helpers/DualityInterface;"));
        list.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(generated);
        return ASMUtils.writeClass(classNode);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        switch (name) {
            case "appeng.client.gui.implementations.GuiPriority": {
                return AEClassTransformer.transformGuiPriority(basicClass);
            }
            case "appeng.container.implementations.ContainerInterfaceTerminal": {
                return AEClassTransformer.transformContainerInterfaceTerminal(basicClass);
            }
            case "appeng.me.Grid": {
                return AEClassTransformer.transformGrid(basicClass);
            }
            case "appeng.me.cluster.implementations.CraftingCPUCluster": {
                return AEClassTransformer.transformCraftingCPUCluster(basicClass);
            }
            case "appeng.helpers.DualityInterface": {
                return AEClassTransformer.transformDualityInterface(basicClass);
            }
            case "appeng.tile.misc.TileInterface": {
                return AEClassTransformer.transformTileInterface(basicClass);
            }
            case "appeng.client.gui.implementations.GuiInterfaceTerminal": {
                return AEClassTransformer.transformGuiInterfaceTerminal(basicClass);
            }
            case "appeng.me.NetworkEventBus": {
                return AEClassTransformer.transformNetworkEventBus(basicClass);
            }
            case "appeng.me.MachineSet": {
                return AEClassTransformer.transformMachineSet(basicClass);
            }
        }
        return basicClass;
    }

    private static byte[] transformGuiInterfaceTerminal(byte[] basicClass) {
        ClassNode classNode = ASMUtils.readClass(basicClass);
        MethodNode methodNode = ASMUtils.findMethod(classNode, "refreshList");
        if (methodNode == null) {
            return basicClass;
        }
        List<AbstractInsnNode> points = ASMUtils.findAllOpcodes(methodNode.instructions, 177);
        if (points.isEmpty()) {
            return basicClass;
        }
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "appeng/client/gui/implementations/GuiInterfaceTerminal", "refreshListMixin", "()V", false));
        points.forEach(point -> methodNode.instructions.insertBefore(point, ASMUtils.copy(list)));
        classNode.fields.add(new FieldNode(18, "counts", "Ljava/util/HashMap;", "Ljava/util/HashMap<Ljava/lang/Integer;Ljava/lang/Integer;>;", null));
        ClassWriter classWriter = new ClassWriter(3);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "(Lnet/minecraft/inventory/Container;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitInsn(177);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "postUpdate", "(Lnet/minecraft/nbt/NBTTagCompound;)V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        Object label1 = new Label();
        Label label2 = new Label();
        methodVisitor.visitTryCatchBlock(label0, (Label)label1, label2, "java/lang/NumberFormatException");
        Label label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLineNumber(61, label3);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitLdcInsn((Object)"clear");
        methodVisitor.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", IS_DEV ? "getBoolean" : "func_74767_n", "(Ljava/lang/String;)Z", false);
        Label label4 = new Label();
        methodVisitor.visitJumpInsn(153, label4);
        Label label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitLineNumber(62, label5);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "byId", "Ljava/util/HashMap;");
        methodVisitor.visitMethodInsn(182, "java/util/HashMap", "clear", "()V", false);
        Label label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitLineNumber(63, label6);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(4);
        methodVisitor.visitFieldInsn(181, "appeng/client/gui/implementations/GuiInterfaceTerminal", "refreshList", "Z");
        methodVisitor.visitLabel(label4);
        methodVisitor.visitLineNumber(66, label4);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", "func_150296_c", "()Ljava/util/Set;", false);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;", true);
        methodVisitor.visitVarInsn(58, 2);
        Label label7 = new Label();
        methodVisitor.visitLabel(label7);
        methodVisitor.visitFrame(1, 1, new Object[]{"java/util/Iterator"}, 0, null);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        Label label8 = new Label();
        methodVisitor.visitJumpInsn(153, label8);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        methodVisitor.visitVarInsn(58, 3);
        Label label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitLineNumber(67, label9);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitTypeInsn(192, "java/lang/String");
        methodVisitor.visitVarInsn(58, 4);
        Label label10 = new Label();
        methodVisitor.visitLabel(label10);
        methodVisitor.visitLineNumber(68, label10);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitLdcInsn((Object)"=");
        methodVisitor.visitMethodInsn(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false);
        Label label11 = new Label();
        methodVisitor.visitJumpInsn(153, label11);
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(70, label0);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitInsn(4);
        methodVisitor.visitMethodInsn(182, "java/lang/String", "substring", "(I)Ljava/lang/String;", false);
        methodVisitor.visitIntInsn(16, 36);
        methodVisitor.visitMethodInsn(184, "java/lang/Long", "parseLong", "(Ljava/lang/String;I)J", false);
        methodVisitor.visitVarInsn(55, 5);
        Label label12 = new Label();
        methodVisitor.visitLabel(label12);
        methodVisitor.visitLineNumber(71, label12);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", IS_DEV ? "getCompoundTag" : "func_74775_l", "(Ljava/lang/String;)Lnet/minecraft/nbt/NBTTagCompound;", false);
        methodVisitor.visitVarInsn(58, 7);
        Label label13 = new Label();
        methodVisitor.visitLabel(label13);
        methodVisitor.visitLineNumber(72, label13);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(22, 5);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/implementations/GuiInterfaceTerminal", "getByIdExtended", "(JLnet/minecraft/nbt/NBTTagCompound;)Lappeng/client/me/ClientDCInternalInv;", false);
        methodVisitor.visitVarInsn(58, 8);
        Label label14 = new Label();
        methodVisitor.visitLabel(label14);
        methodVisitor.visitLineNumber(74, label14);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 9);
        Label label15 = new Label();
        methodVisitor.visitLabel(label15);
        methodVisitor.visitFrame(0, 9, new Object[]{"appeng/client/gui/implementations/GuiInterfaceTerminal", "net/minecraft/nbt/NBTTagCompound", "java/util/Iterator", "java/lang/Object", "java/lang/String", Opcodes.LONG, "net/minecraft/nbt/NBTTagCompound", "appeng/client/me/ClientDCInternalInv", Opcodes.INTEGER}, 0, new Object[0]);
        methodVisitor.visitVarInsn(21, 9);
        methodVisitor.visitVarInsn(25, 8);
        methodVisitor.visitMethodInsn(182, "appeng/client/me/ClientDCInternalInv", "getInventory", "()Lappeng/tile/inventory/AppEngInternalInventory;", false);
        methodVisitor.visitMethodInsn(182, "appeng/tile/inventory/AppEngInternalInventory", IS_DEV ? "getSizeInventory" : "func_70302_i_", "()I", false);
        methodVisitor.visitJumpInsn(162, (Label)label1);
        Label label16 = new Label();
        methodVisitor.visitLabel(label16);
        methodVisitor.visitLineNumber(75, label16);
        methodVisitor.visitVarInsn(21, 9);
        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "toString", "(I)Ljava/lang/String;", false);
        methodVisitor.visitVarInsn(58, 10);
        Label label17 = new Label();
        methodVisitor.visitLabel(label17);
        methodVisitor.visitLineNumber(76, label17);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitVarInsn(25, 10);
        methodVisitor.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", IS_DEV ? "hasKey" : "func_74764_b", "(Ljava/lang/String;)Z", false);
        Label label18 = new Label();
        methodVisitor.visitJumpInsn(153, label18);
        Label label19 = new Label();
        methodVisitor.visitLabel(label19);
        methodVisitor.visitLineNumber(77, label19);
        methodVisitor.visitVarInsn(25, 8);
        methodVisitor.visitMethodInsn(182, "appeng/client/me/ClientDCInternalInv", "getInventory", "()Lappeng/tile/inventory/AppEngInternalInventory;", false);
        methodVisitor.visitVarInsn(21, 9);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitVarInsn(25, 10);
        methodVisitor.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", IS_DEV ? "getCompoundTag" : "func_74775_l", "(Ljava/lang/String;)Lnet/minecraft/nbt/NBTTagCompound;", false);
        methodVisitor.visitMethodInsn(184, "net/minecraft/item/ItemStack", IS_DEV ? "loadItemStackFromNBT" : "func_77949_a", "(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/item/ItemStack;", false);
        methodVisitor.visitMethodInsn(182, "appeng/tile/inventory/AppEngInternalInventory", IS_DEV ? "setInventorySlotContents" : "func_70299_a", "(ILnet/minecraft/item/ItemStack;)V", false);
        methodVisitor.visitLabel(label18);
        methodVisitor.visitLineNumber(74, label18);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitIincInsn(9, 1);
        methodVisitor.visitJumpInsn(167, label15);
        methodVisitor.visitLabel((Label)label1);
        methodVisitor.visitLineNumber(81, (Label)label1);
        methodVisitor.visitFrame(0, 5, new Object[]{"appeng/client/gui/implementations/GuiInterfaceTerminal", "net/minecraft/nbt/NBTTagCompound", "java/util/Iterator", "java/lang/Object", "java/lang/String"}, 0, new Object[0]);
        methodVisitor.visitJumpInsn(167, label11);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitLineNumber(80, label2);
        methodVisitor.visitFrame(4, 0, null, 1, new Object[]{"java/lang/NumberFormatException"});
        methodVisitor.visitVarInsn(58, 5);
        methodVisitor.visitLabel(label11);
        methodVisitor.visitLineNumber(83, label11);
        methodVisitor.visitFrame(2, 2, null, 0, null);
        methodVisitor.visitJumpInsn(167, label7);
        methodVisitor.visitLabel(label8);
        methodVisitor.visitLineNumber(85, label8);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "refreshList", "Z");
        Label label20 = new Label();
        methodVisitor.visitJumpInsn(153, label20);
        Label label21 = new Label();
        methodVisitor.visitLabel(label21);
        methodVisitor.visitLineNumber(86, label21);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(3);
        methodVisitor.visitFieldInsn(181, "appeng/client/gui/implementations/GuiInterfaceTerminal", "refreshList", "Z");
        Label label22 = new Label();
        methodVisitor.visitLabel(label22);
        methodVisitor.visitLineNumber(87, label22);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "cachedSearches", "Ljava/util/Map;");
        methodVisitor.visitMethodInsn(185, "java/util/Map", "clear", "()V", true);
        Label label23 = new Label();
        methodVisitor.visitLabel(label23);
        methodVisitor.visitLineNumber(88, label23);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/implementations/GuiInterfaceTerminal", "refreshList", "()V", false);
        methodVisitor.visitLabel(label20);
        methodVisitor.visitLineNumber(90, label20);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitInsn(177);
        Label label24 = new Label();
        methodVisitor.visitLabel(label24);
        methodVisitor.visitLocalVariable("which", "Ljava/lang/String;", null, label17, label18, 10);
        methodVisitor.visitLocalVariable("x", "I", null, label15, (Label)label1, 9);
        methodVisitor.visitLocalVariable("id", "J", null, label12, (Label)label1, 5);
        methodVisitor.visitLocalVariable("invData", "Lnet/minecraft/nbt/NBTTagCompound;", null, label13, (Label)label1, 7);
        methodVisitor.visitLocalVariable("current", "Lappeng/client/me/ClientDCInternalInv;", null, label14, (Label)label1, 8);
        methodVisitor.visitLocalVariable("key", "Ljava/lang/String;", null, label10, label11, 4);
        methodVisitor.visitLocalVariable("oKey", "Ljava/lang/Object;", null, label9, label11, 3);
        methodVisitor.visitLocalVariable("this", "Lappeng/client/gui/implementations/GuiInterfaceTerminal;", null, label3, label24, 0);
        methodVisitor.visitLocalVariable("in", "Lnet/minecraft/nbt/NBTTagCompound;", null, label3, label24, 1);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "getByIdExtended", "(JLnet/minecraft/nbt/NBTTagCompound;)Lappeng/client/me/ClientDCInternalInv;", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(93, label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "byId", "Ljava/util/HashMap;");
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        methodVisitor.visitMethodInsn(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
        methodVisitor.visitTypeInsn(192, "appeng/client/me/ClientDCInternalInv");
        methodVisitor.visitVarInsn(58, 4);
        label1 = new Label();
        methodVisitor.visitLabel((Label)label1);
        methodVisitor.visitLineNumber(95, (Label)label1);
        methodVisitor.visitVarInsn(25, 4);
        label2 = new Label();
        methodVisitor.visitJumpInsn(199, label2);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLineNumber(96, label3);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitLdcInsn((Object)"invSize");
        methodVisitor.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", IS_DEV ? "hasKey" : "func_74764_b", "(Ljava/lang/String;)Z", false);
        label4 = new Label();
        methodVisitor.visitJumpInsn(153, label4);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitLdcInsn((Object)"invSize");
        methodVisitor.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", IS_DEV ? "getInteger" : "func_74762_e", "(Ljava/lang/String;)I", false);
        label5 = new Label();
        methodVisitor.visitJumpInsn(167, label5);
        methodVisitor.visitLabel(label4);
        methodVisitor.visitFrame(1, 1, new Object[]{"appeng/client/me/ClientDCInternalInv"}, 0, null);
        methodVisitor.visitIntInsn(16, 9);
        methodVisitor.visitLabel(label5);
        methodVisitor.visitFrame(4, 0, null, 1, new Object[]{Opcodes.INTEGER});
        methodVisitor.visitVarInsn(54, 5);
        label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitLineNumber(97, label6);
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitIntInsn(16, 9);
        methodVisitor.visitInsn(112);
        label7 = new Label();
        methodVisitor.visitJumpInsn(154, label7);
        label8 = new Label();
        methodVisitor.visitLabel(label8);
        methodVisitor.visitLineNumber(98, label8);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "counts", "Ljava/util/HashMap;");
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitIntInsn(16, 9);
        methodVisitor.visitInsn(108);
        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        methodVisitor.visitInsn(3);
        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        methodVisitor.visitMethodInsn(182, "java/util/HashMap", "getOrDefault", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
        methodVisitor.visitTypeInsn(192, "java/lang/Integer");
        methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
        methodVisitor.visitVarInsn(54, 6);
        label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitLineNumber(99, label9);
        methodVisitor.visitIincInsn(6, 1);
        label10 = new Label();
        methodVisitor.visitLabel(label10);
        methodVisitor.visitLineNumber(100, label10);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "counts", "Ljava/util/HashMap;");
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitIntInsn(16, 9);
        methodVisitor.visitInsn(108);
        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        methodVisitor.visitVarInsn(21, 6);
        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        methodVisitor.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
        methodVisitor.visitInsn(87);
        methodVisitor.visitLabel(label7);
        methodVisitor.visitLineNumber(103, label7);
        methodVisitor.visitFrame(1, 1, new Object[]{Opcodes.INTEGER}, 0, null);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitLdcInsn((Object)"sortBy");
        methodVisitor.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", IS_DEV ? "getLong" : "func_74763_f", "(Ljava/lang/String;)J", false);
        methodVisitor.visitVarInsn(55, 6);
        label11 = new Label();
        methodVisitor.visitLabel(label11);
        methodVisitor.visitLineNumber(104, label11);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitLdcInsn((Object)"un");
        methodVisitor.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", IS_DEV ? "getString" : "func_74779_i", "(Ljava/lang/String;)Ljava/lang/String;", false);
        methodVisitor.visitVarInsn(58, 8);
        label12 = new Label();
        methodVisitor.visitLabel(label12);
        methodVisitor.visitLineNumber(105, label12);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "byId", "Ljava/util/HashMap;");
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        methodVisitor.visitTypeInsn(187, "appeng/client/me/ClientDCInternalInv");
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitVarInsn(22, 6);
        methodVisitor.visitVarInsn(25, 8);
        methodVisitor.visitMethodInsn(183, "appeng/client/me/ClientDCInternalInv", "<init>", "(IJJLjava/lang/String;)V", false);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(58, 4);
        methodVisitor.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
        methodVisitor.visitInsn(87);
        label13 = new Label();
        methodVisitor.visitLabel(label13);
        methodVisitor.visitLineNumber(106, label13);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(4);
        methodVisitor.visitFieldInsn(181, "appeng/client/gui/implementations/GuiInterfaceTerminal", "refreshList", "Z");
        methodVisitor.visitLabel(label2);
        methodVisitor.visitLineNumber(109, label2);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitInsn(176);
        label14 = new Label();
        methodVisitor.visitLabel(label14);
        methodVisitor.visitLocalVariable("count", "I", null, label9, label7, 6);
        methodVisitor.visitLocalVariable("size", "I", null, label6, label2, 5);
        methodVisitor.visitLocalVariable("sortBy", "J", null, label11, label2, 6);
        methodVisitor.visitLocalVariable("string", "Ljava/lang/String;", null, label12, label2, 8);
        methodVisitor.visitLocalVariable("this", "Lappeng/client/gui/implementations/GuiInterfaceTerminal;", null, label0, label14, 0);
        methodVisitor.visitLocalVariable("id", "J", null, label0, label14, 1);
        methodVisitor.visitLocalVariable("data", "Lnet/minecraft/nbt/NBTTagCompound;", null, label0, label14, 3);
        methodVisitor.visitLocalVariable("o", "Lappeng/client/me/ClientDCInternalInv;", null, (Label)label1, label14, 4);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "drawFG", "(IIII)V", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(115, label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "net/minecraft/client/gui/GuiScreen", IS_DEV ? "fontRendererObj" : "field_146289_q", "Lnet/minecraft/client/gui/FontRenderer;");
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(178, "appeng/core/localization/GuiText", "InterfaceTerminal", "Lappeng/core/localization/GuiText;");
        methodVisitor.visitMethodInsn(182, "appeng/core/localization/GuiText", "getLocal", "()Ljava/lang/String;", false);
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/implementations/GuiInterfaceTerminal", "getGuiDisplayName", "(Ljava/lang/String;)Ljava/lang/String;", false);
        methodVisitor.visitIntInsn(16, 8);
        methodVisitor.visitIntInsn(16, 6);
        methodVisitor.visitLdcInsn((Object)new Integer(0x404040));
        methodVisitor.visitMethodInsn(182, "net/minecraft/client/gui/FontRenderer", IS_DEV ? "drawString" : "func_78276_b", "(Ljava/lang/String;III)I", false);
        methodVisitor.visitInsn(87);
        label1 = new Label();
        methodVisitor.visitLabel((Label)label1);
        methodVisitor.visitLineNumber(116, (Label)label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "net/minecraft/client/gui/GuiScreen", IS_DEV ? "fontRendererObj" : "field_146289_q", "Lnet/minecraft/client/gui/FontRenderer;");
        methodVisitor.visitFieldInsn(178, "appeng/core/localization/GuiText", "inventory", "Lappeng/core/localization/GuiText;");
        methodVisitor.visitMethodInsn(182, "appeng/core/localization/GuiText", "getLocal", "()Ljava/lang/String;", false);
        methodVisitor.visitIntInsn(16, 8);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "net/minecraft/client/gui/inventory/GuiContainer", IS_DEV ? "ySize" : "field_147000_g", "I");
        methodVisitor.visitIntInsn(16, 96);
        methodVisitor.visitInsn(100);
        methodVisitor.visitInsn(6);
        methodVisitor.visitInsn(96);
        methodVisitor.visitLdcInsn((Object)new Integer(0x404040));
        methodVisitor.visitMethodInsn(182, "net/minecraft/client/gui/FontRenderer", IS_DEV ? "drawString" : "func_78276_b", "(Ljava/lang/String;III)I", false);
        methodVisitor.visitInsn(87);
        label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitLineNumber(118, label2);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/AEBaseGui", "getScrollBar", "()Lappeng/client/gui/widgets/GuiScrollbar;", false);
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/widgets/GuiScrollbar", "getCurrentScroll", "()I", false);
        methodVisitor.visitVarInsn(54, 5);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLineNumber(120, label3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "net/minecraft/client/gui/inventory/GuiContainer", IS_DEV ? "inventorySlots" : "field_147002_h", "Lnet/minecraft/inventory/Container;");
        methodVisitor.visitFieldInsn(180, "net/minecraft/inventory/Container", IS_DEV ? "inventorySlots" : "field_75151_b", "Ljava/util/List;");
        methodVisitor.visitMethodInsn(185, "java/util/List", "iterator", "()Ljava/util/Iterator;", true);
        methodVisitor.visitVarInsn(58, 6);
        label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitLineNumber(121, label4);
        methodVisitor.visitFrame(1, 2, new Object[]{Opcodes.INTEGER, "java/util/Iterator"}, 0, null);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        label5 = new Label();
        methodVisitor.visitJumpInsn(153, label5);
        label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitLineNumber(122, label6);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        methodVisitor.visitVarInsn(58, 7);
        label7 = new Label();
        methodVisitor.visitLabel(label7);
        methodVisitor.visitLineNumber(123, label7);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitTypeInsn(193, "appeng/client/me/SlotDisconnected");
        label8 = new Label();
        methodVisitor.visitJumpInsn(153, label8);
        label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitLineNumber(124, label9);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "remove", "()V", true);
        methodVisitor.visitLabel(label8);
        methodVisitor.visitLineNumber(126, label8);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitJumpInsn(167, label4);
        methodVisitor.visitLabel(label5);
        methodVisitor.visitLineNumber(127, label5);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 7);
        label10 = new Label();
        methodVisitor.visitLabel(label10);
        methodVisitor.visitLineNumber(128, label10);
        methodVisitor.visitIntInsn(16, 17);
        methodVisitor.visitVarInsn(54, 8);
        label11 = new Label();
        methodVisitor.visitLabel(label11);
        methodVisitor.visitLineNumber(129, label11);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 9);
        label12 = new Label();
        methodVisitor.visitLabel(label12);
        methodVisitor.visitFrame(1, 3, new Object[]{Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER}, 0, null);
        methodVisitor.visitVarInsn(21, 9);
        methodVisitor.visitVarInsn(21, 7);
        methodVisitor.visitInsn(96);
        methodVisitor.visitFieldInsn(178, "appeng/client/gui/implementations/GuiInterfaceTerminal", "LINES_ON_PAGE", "I");
        label13 = new Label();
        methodVisitor.visitJumpInsn(162, label13);
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitVarInsn(21, 9);
        methodVisitor.visitInsn(96);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "lines", "Ljava/util/ArrayList;");
        methodVisitor.visitMethodInsn(182, "java/util/ArrayList", "size", "()I", false);
        methodVisitor.visitJumpInsn(162, label13);
        label14 = new Label();
        methodVisitor.visitLabel(label14);
        methodVisitor.visitLineNumber(130, label14);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "lines", "Ljava/util/ArrayList;");
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitVarInsn(21, 9);
        methodVisitor.visitInsn(96);
        methodVisitor.visitMethodInsn(182, "java/util/ArrayList", "get", "(I)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(58, 10);
        label15 = new Label();
        methodVisitor.visitLabel(label15);
        methodVisitor.visitLineNumber(131, label15);
        methodVisitor.visitVarInsn(25, 10);
        methodVisitor.visitTypeInsn(193, "appeng/client/me/ClientDCInternalInv");
        label16 = new Label();
        methodVisitor.visitJumpInsn(153, label16);
        label17 = new Label();
        methodVisitor.visitLabel(label17);
        methodVisitor.visitLineNumber(132, label17);
        methodVisitor.visitVarInsn(25, 10);
        methodVisitor.visitTypeInsn(192, "appeng/client/me/ClientDCInternalInv");
        methodVisitor.visitVarInsn(58, 11);
        label18 = new Label();
        methodVisitor.visitLabel(label18);
        methodVisitor.visitLineNumber(133, label18);
        methodVisitor.visitVarInsn(25, 11);
        methodVisitor.visitMethodInsn(182, "appeng/client/me/ClientDCInternalInv", "getInventory", "()Lappeng/tile/inventory/AppEngInternalInventory;", false);
        methodVisitor.visitMethodInsn(182, "appeng/tile/inventory/AppEngInternalInventory", IS_DEV ? "getSizeInventory" : "func_70302_i_", "()I", false);
        methodVisitor.visitVarInsn(54, 12);
        label19 = new Label();
        methodVisitor.visitLabel(label19);
        methodVisitor.visitLineNumber(134, label19);
        methodVisitor.visitVarInsn(21, 12);
        methodVisitor.visitIntInsn(16, 9);
        methodVisitor.visitInsn(112);
        label20 = new Label();
        methodVisitor.visitJumpInsn(154, label20);
        label21 = new Label();
        methodVisitor.visitLabel(label21);
        methodVisitor.visitLineNumber(135, label21);
        methodVisitor.visitVarInsn(21, 12);
        methodVisitor.visitIntInsn(16, 9);
        methodVisitor.visitInsn(108);
        methodVisitor.visitVarInsn(54, 13);
        label22 = new Label();
        methodVisitor.visitLabel(label22);
        methodVisitor.visitLineNumber(136, label22);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 14);
        label23 = new Label();
        methodVisitor.visitLabel(label23);
        methodVisitor.visitFrame(0, 15, new Object[]{"appeng/client/gui/implementations/GuiInterfaceTerminal", Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, "java/util/Iterator", Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, "java/lang/Object", "appeng/client/me/ClientDCInternalInv", Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER}, 0, new Object[0]);
        methodVisitor.visitVarInsn(21, 14);
        methodVisitor.visitVarInsn(21, 13);
        label24 = new Label();
        methodVisitor.visitJumpInsn(162, label24);
        Label label25 = new Label();
        methodVisitor.visitLabel(label25);
        methodVisitor.visitLineNumber(137, label25);
        methodVisitor.visitVarInsn(21, 9);
        methodVisitor.visitVarInsn(21, 7);
        methodVisitor.visitInsn(96);
        methodVisitor.visitFieldInsn(178, "appeng/client/gui/implementations/GuiInterfaceTerminal", "LINES_ON_PAGE", "I");
        Label label26 = new Label();
        methodVisitor.visitJumpInsn(161, label26);
        Label label27 = new Label();
        methodVisitor.visitLabel(label27);
        methodVisitor.visitLineNumber(138, label27);
        methodVisitor.visitJumpInsn(167, label24);
        methodVisitor.visitLabel(label26);
        methodVisitor.visitLineNumber(139, label26);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 15);
        Label label28 = new Label();
        methodVisitor.visitLabel(label28);
        methodVisitor.visitFrame(1, 1, new Object[]{Opcodes.INTEGER}, 0, null);
        methodVisitor.visitVarInsn(21, 15);
        methodVisitor.visitIntInsn(16, 9);
        Label label29 = new Label();
        methodVisitor.visitJumpInsn(162, label29);
        Label label30 = new Label();
        methodVisitor.visitLabel(label30);
        methodVisitor.visitLineNumber(140, label30);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "net/minecraft/client/gui/inventory/GuiContainer", IS_DEV ? "inventorySlots" : "field_147002_h", "Lnet/minecraft/inventory/Container;");
        methodVisitor.visitFieldInsn(180, "net/minecraft/inventory/Container", IS_DEV ? "inventorySlots" : "field_75151_b", "Ljava/util/List;");
        methodVisitor.visitTypeInsn(187, "appeng/client/me/SlotDisconnected");
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 11);
        methodVisitor.visitVarInsn(21, 14);
        methodVisitor.visitIntInsn(16, 9);
        methodVisitor.visitInsn(104);
        methodVisitor.visitVarInsn(21, 15);
        methodVisitor.visitInsn(96);
        methodVisitor.visitVarInsn(21, 15);
        methodVisitor.visitIntInsn(16, 18);
        methodVisitor.visitInsn(104);
        methodVisitor.visitIntInsn(16, 8);
        methodVisitor.visitInsn(96);
        methodVisitor.visitInsn(4);
        methodVisitor.visitVarInsn(21, 8);
        methodVisitor.visitInsn(96);
        methodVisitor.visitMethodInsn(183, "appeng/client/me/SlotDisconnected", "<init>", "(Lappeng/client/me/ClientDCInternalInv;III)V", false);
        methodVisitor.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
        methodVisitor.visitInsn(87);
        Label label31 = new Label();
        methodVisitor.visitLabel(label31);
        methodVisitor.visitLineNumber(139, label31);
        methodVisitor.visitIincInsn(15, 1);
        methodVisitor.visitJumpInsn(167, label28);
        methodVisitor.visitLabel(label29);
        methodVisitor.visitLineNumber(142, label29);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitIincInsn(7, 1);
        Label label32 = new Label();
        methodVisitor.visitLabel(label32);
        methodVisitor.visitLineNumber(143, label32);
        methodVisitor.visitIincInsn(8, 18);
        Label label33 = new Label();
        methodVisitor.visitLabel(label33);
        methodVisitor.visitLineNumber(136, label33);
        methodVisitor.visitIincInsn(14, 1);
        methodVisitor.visitJumpInsn(167, label23);
        methodVisitor.visitLabel(label24);
        methodVisitor.visitLineNumber(145, label24);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitIincInsn(7, -1);
        Label label34 = new Label();
        methodVisitor.visitLabel(label34);
        methodVisitor.visitLineNumber(146, label34);
        methodVisitor.visitIincInsn(8, -18);
        methodVisitor.visitLabel(label20);
        methodVisitor.visitLineNumber(148, label20);
        methodVisitor.visitFrame(2, 3, null, 0, null);
        Label label35 = new Label();
        methodVisitor.visitJumpInsn(167, label35);
        methodVisitor.visitLabel(label16);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 10);
        methodVisitor.visitTypeInsn(193, "java/lang/String");
        methodVisitor.visitJumpInsn(153, label35);
        Label label36 = new Label();
        methodVisitor.visitLabel(label36);
        methodVisitor.visitLineNumber(149, label36);
        methodVisitor.visitVarInsn(25, 10);
        methodVisitor.visitTypeInsn(192, "java/lang/String");
        methodVisitor.visitVarInsn(58, 11);
        Label label37 = new Label();
        methodVisitor.visitLabel(label37);
        methodVisitor.visitLineNumber(150, label37);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "byName", "Lcom/google/common/collect/HashMultimap;");
        methodVisitor.visitVarInsn(25, 11);
        methodVisitor.visitMethodInsn(182, "com/google/common/collect/HashMultimap", "get", "(Ljava/lang/Object;)Ljava/util/Set;", false);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "size", "()I", true);
        methodVisitor.visitVarInsn(54, 12);
        Label label38 = new Label();
        methodVisitor.visitLabel(label38);
        methodVisitor.visitLineNumber(151, label38);
        methodVisitor.visitVarInsn(21, 12);
        methodVisitor.visitInsn(4);
        Label label39 = new Label();
        methodVisitor.visitJumpInsn(164, label39);
        Label label40 = new Label();
        methodVisitor.visitLabel(label40);
        methodVisitor.visitLineNumber(152, label40);
        methodVisitor.visitTypeInsn(187, "java/lang/StringBuilder");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        methodVisitor.visitVarInsn(25, 11);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        methodVisitor.visitLdcInsn((Object)" (");
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        methodVisitor.visitVarInsn(21, 12);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        methodVisitor.visitIntInsn(16, 41);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(C)Ljava/lang/StringBuilder;", false);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        methodVisitor.visitVarInsn(58, 11);
        methodVisitor.visitLabel(label39);
        methodVisitor.visitLineNumber(155, label39);
        methodVisitor.visitFrame(1, 2, new Object[]{"java/lang/String", Opcodes.INTEGER}, 0, null);
        methodVisitor.visitVarInsn(25, 11);
        methodVisitor.visitMethodInsn(182, "java/lang/String", "length", "()I", false);
        methodVisitor.visitInsn(5);
        Label label41 = new Label();
        methodVisitor.visitJumpInsn(164, label41);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "net/minecraft/client/gui/GuiScreen", IS_DEV ? "fontRendererObj" : "field_146289_q", "Lnet/minecraft/client/gui/FontRenderer;");
        methodVisitor.visitVarInsn(25, 11);
        methodVisitor.visitMethodInsn(182, "net/minecraft/client/gui/FontRenderer", IS_DEV ? "getStringWidth" : "func_78256_a", "(Ljava/lang/String;)I", false);
        methodVisitor.visitIntInsn(17, 155);
        methodVisitor.visitJumpInsn(164, label41);
        Label label42 = new Label();
        methodVisitor.visitLabel(label42);
        methodVisitor.visitLineNumber(156, label42);
        methodVisitor.visitVarInsn(25, 11);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(25, 11);
        methodVisitor.visitMethodInsn(182, "java/lang/String", "length", "()I", false);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(100);
        methodVisitor.visitMethodInsn(182, "java/lang/String", "substring", "(II)Ljava/lang/String;", false);
        methodVisitor.visitVarInsn(58, 11);
        methodVisitor.visitJumpInsn(167, label39);
        methodVisitor.visitLabel(label41);
        methodVisitor.visitLineNumber(159, label41);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "net/minecraft/client/gui/GuiScreen", IS_DEV ? "fontRendererObj" : "field_146289_q", "Lnet/minecraft/client/gui/FontRenderer;");
        methodVisitor.visitVarInsn(25, 11);
        methodVisitor.visitIntInsn(16, 10);
        methodVisitor.visitIntInsn(16, 6);
        methodVisitor.visitVarInsn(21, 8);
        methodVisitor.visitInsn(96);
        methodVisitor.visitLdcInsn((Object)new Integer(0x404040));
        methodVisitor.visitMethodInsn(182, "net/minecraft/client/gui/FontRenderer", IS_DEV ? "drawString" : "func_78276_b", "(Ljava/lang/String;III)I", false);
        methodVisitor.visitInsn(87);
        methodVisitor.visitLabel(label35);
        methodVisitor.visitLineNumber(161, label35);
        methodVisitor.visitFrame(2, 2, null, 0, null);
        methodVisitor.visitIincInsn(8, 18);
        Label label43 = new Label();
        methodVisitor.visitLabel(label43);
        methodVisitor.visitLineNumber(129, label43);
        methodVisitor.visitIincInsn(9, 1);
        methodVisitor.visitJumpInsn(167, label12);
        methodVisitor.visitLabel(label13);
        methodVisitor.visitLineNumber(163, label13);
        methodVisitor.visitFrame(2, 2, null, 0, null);
        methodVisitor.visitInsn(177);
        Label label44 = new Label();
        methodVisitor.visitLabel(label44);
        methodVisitor.visitLocalVariable("slot", "Ljava/lang/Object;", null, label7, label8, 7);
        methodVisitor.visitLocalVariable("z", "I", null, label28, label29, 15);
        methodVisitor.visitLocalVariable("a", "I", null, label23, label24, 14);
        methodVisitor.visitLocalVariable("y", "I", null, label22, label20, 13);
        methodVisitor.visitLocalVariable("inv", "Lappeng/client/me/ClientDCInternalInv;", null, label18, label20, 11);
        methodVisitor.visitLocalVariable("size", "I", null, label19, label20, 12);
        methodVisitor.visitLocalVariable("name", "Ljava/lang/String;", null, label37, label35, 11);
        methodVisitor.visitLocalVariable("rows", "I", null, label38, label35, 12);
        methodVisitor.visitLocalVariable("lineObj", "Ljava/lang/Object;", null, label15, label43, 10);
        methodVisitor.visitLocalVariable("x", "I", null, label12, label13, 9);
        methodVisitor.visitLocalVariable("this", "Lappeng/client/gui/implementations/GuiInterfaceTerminal;", null, label0, label44, 0);
        methodVisitor.visitLocalVariable("offsetX", "I", null, label0, label44, 1);
        methodVisitor.visitLocalVariable("offsetY", "I", null, label0, label44, 2);
        methodVisitor.visitLocalVariable("mouseX", "I", null, label0, label44, 3);
        methodVisitor.visitLocalVariable("mouseY", "I", null, label0, label44, 4);
        methodVisitor.visitLocalVariable("ex", "I", null, label3, label44, 5);
        methodVisitor.visitLocalVariable("iterator", "Ljava/util/Iterator;", null, label4, label44, 6);
        methodVisitor.visitLocalVariable("over", "I", null, label10, label44, 7);
        methodVisitor.visitLocalVariable("offset", "I", null, label11, label44, 8);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "drawBG", "(IIII)V", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(166, label0);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn((Object)"guis/interfaceterminal.png");
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/AEBaseGui", "bindTexture", "(Ljava/lang/String;)V", false);
        label1 = new Label();
        methodVisitor.visitLabel((Label)label1);
        methodVisitor.visitLineNumber(167, (Label)label1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "net/minecraft/client/gui/inventory/GuiContainer", IS_DEV ? "xSize" : "field_146999_f", "I");
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "net/minecraft/client/gui/inventory/GuiContainer", IS_DEV ? "ySize" : "field_147000_g", "I");
        methodVisitor.visitMethodInsn(182, "net/minecraft/client/gui/Gui", IS_DEV ? "drawTexturedModalRect" : "func_73729_b", "(IIIIII)V", false);
        label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitLineNumber(169, label2);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 5);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLineNumber(170, label3);
        methodVisitor.visitIntInsn(16, 17);
        methodVisitor.visitVarInsn(54, 6);
        label4 = new Label();
        methodVisitor.visitLabel(label4);
        methodVisitor.visitLineNumber(171, label4);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/AEBaseGui", "getScrollBar", "()Lappeng/client/gui/widgets/GuiScrollbar;", false);
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/widgets/GuiScrollbar", "getCurrentScroll", "()I", false);
        methodVisitor.visitVarInsn(54, 7);
        label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitLineNumber(172, label5);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 8);
        label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitFrame(0, 9, new Object[]{"appeng/client/gui/implementations/GuiInterfaceTerminal", Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER}, 0, new Object[0]);
        methodVisitor.visitVarInsn(21, 8);
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitInsn(96);
        methodVisitor.visitFieldInsn(178, "appeng/client/gui/implementations/GuiInterfaceTerminal", "LINES_ON_PAGE", "I");
        label7 = new Label();
        methodVisitor.visitJumpInsn(162, label7);
        methodVisitor.visitVarInsn(21, 7);
        methodVisitor.visitVarInsn(21, 8);
        methodVisitor.visitInsn(96);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "lines", "Ljava/util/ArrayList;");
        methodVisitor.visitMethodInsn(182, "java/util/ArrayList", "size", "()I", false);
        methodVisitor.visitJumpInsn(162, label7);
        label8 = new Label();
        methodVisitor.visitLabel(label8);
        methodVisitor.visitLineNumber(174, label8);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "lines", "Ljava/util/ArrayList;");
        methodVisitor.visitVarInsn(21, 7);
        methodVisitor.visitVarInsn(21, 8);
        methodVisitor.visitInsn(96);
        methodVisitor.visitMethodInsn(182, "java/util/ArrayList", "get", "(I)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(58, 9);
        label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitLineNumber(175, label9);
        methodVisitor.visitVarInsn(25, 9);
        methodVisitor.visitTypeInsn(193, "appeng/client/me/ClientDCInternalInv");
        label10 = new Label();
        methodVisitor.visitJumpInsn(153, label10);
        label11 = new Label();
        methodVisitor.visitLabel(label11);
        methodVisitor.visitLineNumber(176, label11);
        methodVisitor.visitVarInsn(25, 9);
        methodVisitor.visitTypeInsn(192, "appeng/client/me/ClientDCInternalInv");
        methodVisitor.visitVarInsn(58, 10);
        label12 = new Label();
        methodVisitor.visitLabel(label12);
        methodVisitor.visitLineNumber(178, label12);
        methodVisitor.visitInsn(12);
        methodVisitor.visitInsn(12);
        methodVisitor.visitInsn(12);
        methodVisitor.visitInsn(12);
        methodVisitor.visitMethodInsn(184, "org/lwjgl/opengl/GL11", "glColor4f", "(FFFF)V", false);
        label13 = new Label();
        methodVisitor.visitLabel(label13);
        methodVisitor.visitLineNumber(179, label13);
        methodVisitor.visitVarInsn(25, 10);
        methodVisitor.visitMethodInsn(182, "appeng/client/me/ClientDCInternalInv", "getInventory", "()Lappeng/tile/inventory/AppEngInternalInventory;", false);
        methodVisitor.visitMethodInsn(182, "appeng/tile/inventory/AppEngInternalInventory", IS_DEV ? "getSizeInventory" : "func_70302_i_", "()I", false);
        methodVisitor.visitIntInsn(16, 9);
        methodVisitor.visitInsn(112);
        methodVisitor.visitJumpInsn(154, label10);
        label14 = new Label();
        methodVisitor.visitLabel(label14);
        methodVisitor.visitLineNumber(180, label14);
        methodVisitor.visitVarInsn(25, 10);
        methodVisitor.visitMethodInsn(182, "appeng/client/me/ClientDCInternalInv", "getInventory", "()Lappeng/tile/inventory/AppEngInternalInventory;", false);
        methodVisitor.visitMethodInsn(182, "appeng/tile/inventory/AppEngInternalInventory", IS_DEV ? "getSizeInventory" : "func_70302_i_", "()I", false);
        methodVisitor.visitIntInsn(16, 9);
        methodVisitor.visitInsn(108);
        methodVisitor.visitVarInsn(54, 11);
        label15 = new Label();
        methodVisitor.visitLabel(label15);
        methodVisitor.visitLineNumber(181, label15);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 12);
        label16 = new Label();
        methodVisitor.visitLabel(label16);
        methodVisitor.visitFrame(0, 13, new Object[]{"appeng/client/gui/implementations/GuiInterfaceTerminal", Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, Opcodes.INTEGER, "java/lang/Object", "appeng/client/me/ClientDCInternalInv", Opcodes.INTEGER, Opcodes.INTEGER}, 0, new Object[0]);
        methodVisitor.visitVarInsn(21, 12);
        methodVisitor.visitVarInsn(21, 11);
        label17 = new Label();
        methodVisitor.visitJumpInsn(162, label17);
        label18 = new Label();
        methodVisitor.visitLabel(label18);
        methodVisitor.visitLineNumber(182, label18);
        methodVisitor.visitVarInsn(21, 8);
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitInsn(96);
        methodVisitor.visitFieldInsn(178, "appeng/client/gui/implementations/GuiInterfaceTerminal", "LINES_ON_PAGE", "I");
        label19 = new Label();
        methodVisitor.visitJumpInsn(161, label19);
        label20 = new Label();
        methodVisitor.visitLabel(label20);
        methodVisitor.visitLineNumber(183, label20);
        methodVisitor.visitJumpInsn(167, label17);
        methodVisitor.visitLabel(label19);
        methodVisitor.visitLineNumber(184, label19);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitIntInsn(17, 162);
        methodVisitor.visitVarInsn(54, 13);
        label21 = new Label();
        methodVisitor.visitLabel(label21);
        methodVisitor.visitLineNumber(185, label21);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitIntInsn(16, 7);
        methodVisitor.visitInsn(96);
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitVarInsn(21, 6);
        methodVisitor.visitInsn(96);
        methodVisitor.visitIntInsn(16, 7);
        methodVisitor.visitIntInsn(17, 139);
        methodVisitor.visitIntInsn(17, 162);
        methodVisitor.visitIntInsn(16, 18);
        methodVisitor.visitMethodInsn(182, "net/minecraft/client/gui/Gui", IS_DEV ? "drawTexturedModalRect" : "func_73729_b", "(IIIIII)V", false);
        label22 = new Label();
        methodVisitor.visitLabel(label22);
        methodVisitor.visitLineNumber(186, label22);
        methodVisitor.visitIincInsn(6, 18);
        label23 = new Label();
        methodVisitor.visitLabel(label23);
        methodVisitor.visitLineNumber(187, label23);
        methodVisitor.visitIincInsn(5, 1);
        label24 = new Label();
        methodVisitor.visitLabel(label24);
        methodVisitor.visitLineNumber(181, label24);
        methodVisitor.visitIincInsn(12, 1);
        methodVisitor.visitJumpInsn(167, label16);
        methodVisitor.visitLabel(label17);
        methodVisitor.visitLineNumber(189, label17);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        methodVisitor.visitIincInsn(5, -1);
        label25 = new Label();
        methodVisitor.visitLabel(label25);
        methodVisitor.visitLineNumber(190, label25);
        methodVisitor.visitIincInsn(6, -18);
        methodVisitor.visitLabel(label10);
        methodVisitor.visitLineNumber(193, label10);
        methodVisitor.visitFrame(2, 2, null, 0, null);
        methodVisitor.visitIincInsn(6, 18);
        label26 = new Label();
        methodVisitor.visitLabel(label26);
        methodVisitor.visitLineNumber(172, label26);
        methodVisitor.visitIincInsn(8, 1);
        methodVisitor.visitJumpInsn(167, label6);
        methodVisitor.visitLabel(label7);
        methodVisitor.visitLineNumber(196, label7);
        methodVisitor.visitFrame(2, 2, null, 0, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "searchField", "Lappeng/client/gui/widgets/MEGuiTextField;");
        label27 = new Label();
        methodVisitor.visitJumpInsn(198, label27);
        label28 = new Label();
        methodVisitor.visitLabel(label28);
        methodVisitor.visitLineNumber(197, label28);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "searchField", "Lappeng/client/gui/widgets/MEGuiTextField;");
        methodVisitor.visitMethodInsn(182, "net/minecraft/client/gui/GuiTextField", IS_DEV ? "drawTextBox" : "func_146194_f", "()V", false);
        methodVisitor.visitLabel(label27);
        methodVisitor.visitLineNumber(199, label27);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitInsn(177);
        label29 = new Label();
        methodVisitor.visitLabel(label29);
        methodVisitor.visitLocalVariable("width", "I", null, label21, label24, 13);
        methodVisitor.visitLocalVariable("i", "I", null, label16, label17, 12);
        methodVisitor.visitLocalVariable("y", "I", null, label15, label10, 11);
        methodVisitor.visitLocalVariable("inv", "Lappeng/client/me/ClientDCInternalInv;", null, label12, label10, 10);
        methodVisitor.visitLocalVariable("lineObj", "Ljava/lang/Object;", null, label9, label26, 9);
        methodVisitor.visitLocalVariable("x", "I", null, label6, label7, 8);
        methodVisitor.visitLocalVariable("this", "Lappeng/client/gui/implementations/GuiInterfaceTerminal;", null, label0, label29, 0);
        methodVisitor.visitLocalVariable("offsetX", "I", null, label0, label29, 1);
        methodVisitor.visitLocalVariable("offsetY", "I", null, label0, label29, 2);
        methodVisitor.visitLocalVariable("mouseX", "I", null, label0, label29, 3);
        methodVisitor.visitLocalVariable("mouseY", "I", null, label0, label29, 4);
        methodVisitor.visitLocalVariable("over", "I", null, label3, label29, 5);
        methodVisitor.visitLocalVariable("offset", "I", null, label4, label29, 6);
        methodVisitor.visitLocalVariable("ex", "I", null, label5, label29, 7);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(2, "refreshListMixin", "()V", null, null);
        methodVisitor.visitCode();
        label0 = new Label();
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLineNumber(203, label0);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 2);
        label1 = new Label();
        methodVisitor.visitLabel((Label)label1);
        methodVisitor.visitLineNumber(204, (Label)label1);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(54, 3);
        label2 = new Label();
        methodVisitor.visitLabel(label2);
        methodVisitor.visitLineNumber(205, label2);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "counts", "Ljava/util/HashMap;");
        methodVisitor.visitMethodInsn(182, "java/util/HashMap", "entrySet", "()Ljava/util/Set;", false);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;", true);
        methodVisitor.visitVarInsn(58, 4);
        label3 = new Label();
        methodVisitor.visitLabel(label3);
        methodVisitor.visitFrame(1, 3, new Object[]{Opcodes.INTEGER, Opcodes.INTEGER, "java/util/Iterator"}, 0, null);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z", true);
        label4 = new Label();
        methodVisitor.visitJumpInsn(153, label4);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/util/Map$Entry");
        methodVisitor.visitVarInsn(58, 5);
        label5 = new Label();
        methodVisitor.visitLabel(label5);
        methodVisitor.visitLineNumber(206, label5);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getKey", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/lang/Integer");
        methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getValue", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/lang/Integer");
        methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
        methodVisitor.visitInsn(104);
        methodVisitor.visitInsn(135);
        methodVisitor.visitLdcInsn((Object)new Double("3.0"));
        methodVisitor.visitInsn(111);
        methodVisitor.visitMethodInsn(184, "java/lang/Math", "ceil", "(D)D", false);
        methodVisitor.visitInsn(142);
        methodVisitor.visitVarInsn(54, 6);
        label6 = new Label();
        methodVisitor.visitLabel(label6);
        methodVisitor.visitLineNumber(207, label6);
        methodVisitor.visitVarInsn(21, 3);
        methodVisitor.visitVarInsn(21, 6);
        methodVisitor.visitInsn(6);
        methodVisitor.visitInsn(104);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getKey", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/lang/Integer");
        methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitMethodInsn(185, "java/util/Map$Entry", "getValue", "()Ljava/lang/Object;", true);
        methodVisitor.visitTypeInsn(192, "java/lang/Integer");
        methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
        methodVisitor.visitInsn(104);
        methodVisitor.visitInsn(100);
        methodVisitor.visitInsn(96);
        methodVisitor.visitVarInsn(54, 3);
        label7 = new Label();
        methodVisitor.visitLabel(label7);
        methodVisitor.visitLineNumber(208, label7);
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitVarInsn(21, 6);
        methodVisitor.visitInsn(96);
        methodVisitor.visitVarInsn(54, 2);
        label8 = new Label();
        methodVisitor.visitLabel(label8);
        methodVisitor.visitLineNumber(209, label8);
        methodVisitor.visitJumpInsn(167, label3);
        methodVisitor.visitLabel(label4);
        methodVisitor.visitLineNumber(210, label4);
        methodVisitor.visitFrame(2, 1, null, 0, null);
        label9 = new Label();
        methodVisitor.visitLabel(label9);
        methodVisitor.visitLineNumber(211, label9);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/AEBaseGui", "getScrollBar", "()Lappeng/client/gui/widgets/GuiScrollbar;", false);
        methodVisitor.visitInsn(3);
        methodVisitor.visitVarInsn(21, 2);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, "appeng/client/gui/implementations/GuiInterfaceTerminal", "names", "Ljava/util/ArrayList;");
        methodVisitor.visitMethodInsn(182, "java/util/ArrayList", "size", "()I", false);
        methodVisitor.visitInsn(96);
        methodVisitor.visitInsn(5);
        methodVisitor.visitMethodInsn(182, "appeng/client/gui/widgets/GuiScrollbar", "setRange", "(III)V", false);
        label10 = new Label();
        methodVisitor.visitLabel(label10);
        methodVisitor.visitLineNumber(212, label10);
        methodVisitor.visitInsn(177);
        label11 = new Label();
        methodVisitor.visitLabel(label11);
        methodVisitor.visitLocalVariable("c", "I", null, label6, label8, 6);
        methodVisitor.visitLocalVariable("entry", "Ljava/util/Map$Entry;", "Ljava/util/Map$Entry<Ljava/lang/Integer;Ljava/lang/Integer;>;", label5, label8, 5);
        methodVisitor.visitLocalVariable("this", "Lappeng/client/gui/implementations/GuiInterfaceTerminal;", null, label0, label11, 0);
        methodVisitor.visitLocalVariable("size", "I", null, (Label)label1, label11, 2);
        methodVisitor.visitLocalVariable("unused", "I", null, label2, label11, 3);
        methodVisitor.visitEnd();
        ClassNode generatedNode = ASMUtils.readClass(classWriter.toByteArray());
        for (MethodNode node : generatedNode.methods) {
            if (node.name.equals("<init>")) continue;
            MethodNode original = ASMUtils.findMethod(classNode, node.name);
            if (original != null) {
                classNode.methods.remove(original);
            }
            classNode.methods.add(node);
        }
        MethodNode methodNodeC = ASMUtils.findMethod(classNode, "<init>");
        if (methodNodeC == null) {
            return basicClass;
        }
        List<AbstractInsnNode> pointsC = ASMUtils.findAllOpcodes(methodNodeC.instructions, 177);
        if (pointsC.isEmpty()) {
            return basicClass;
        }
        InsnList listC = new InsnList();
        listC.add((AbstractInsnNode)new VarInsnNode(25, 0));
        listC.add((AbstractInsnNode)new TypeInsnNode(187, "java/util/HashMap"));
        listC.add((AbstractInsnNode)new InsnNode(89));
        listC.add((AbstractInsnNode)new MethodInsnNode(183, "java/util/HashMap", "<init>", "()V", false));
        listC.add((AbstractInsnNode)new FieldInsnNode(181, "appeng/client/gui/implementations/GuiInterfaceTerminal", "counts", "Ljava/util/HashMap;"));
        pointsC.forEach(point -> methodNodeC.instructions.insertBefore(point, ASMUtils.copy(listC)));
        return ASMUtils.writeClass(classNode);
    }

    private static byte[] transformNetworkEventBus(byte[] basicClass) {
        ClassNode classNode = ASMUtils.readClass(basicClass);
        MethodNode methodNode = ASMUtils.findMethod(classNode, "postEvent");
        if (methodNode == null) {
            return basicClass;
        }
        for (AbstractInsnNode node : methodNode.instructions.toArray()) {
            if (node.getType() != 5 || node.getOpcode() != 182) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (!methodInsnNode.owner.equals("appeng/me/Grid") || !methodInsnNode.name.equals("getMachines")) continue;
            methodInsnNode.name = "getMachinesSafe";
        }
        return ASMUtils.writeClass(classNode);
    }

    private static byte[] transformMachineSet(byte[] basicClass) {
        ClassNode classNode = ASMUtils.readClass(basicClass);
        classNode.interfaces.add("com/ae/additions/utils/IMachineSetAccessor");
        MethodNode generated = new MethodNode(1, "create", "(Ljava/lang/Class;)Lappeng/me/MachineSet;", null, null);
        InsnList list = generated.instructions;
        list.add((AbstractInsnNode)new TypeInsnNode(187, "appeng/me/MachineSet"));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "appeng/me/MachineSet", "<init>", "(Ljava/lang/Class;)V", false));
        list.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(generated);
        return ASMUtils.writeClass(classNode);
    }
}

