/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.tile;

import ab.client.core.ClientHelper;
import ab.common.core.handler.ConfigABHandler;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileMod;

public class TileManaContainer
extends TileMod
implements IManaPool,
ISparkAttachable {
    protected int mana = 0;
    int knownMana = -1;

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            double particleChance = 1.0 - (double)(this.getCurrentMana() / this.getMaxMana()) * 0.1;
            Color color = new Color(50943);
            if (Math.random() > particleChance) {
                Botania.proxy.wispFX(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f) + (Math.random() - 0.5) * (double)0.4f, (double)this.field_145848_d + 0.81 + Math.random() * 0.05, (double)((float)this.field_145849_e + 0.5f) + (Math.random() - 0.5) * (double)0.4f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random() / 4.2f, (float)(-Math.random()) / 50.0f, 2.0f);
            }
        }
    }

    public void onWanded(EntityPlayer player, ItemStack wand) {
        if (player == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.writeCustomNBT(nbttagcompound);
            nbttagcompound.func_74768_a("knownMana", this.getCurrentMana());
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound));
            }
        }
        this.field_145850_b.func_72956_a((Entity)player, "botania:ding", 0.11f, 1.0f);
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        String name = StatCollector.func_74838_a((String)("ab.manaContainer." + this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) + ".hud"));
        int color = 3205841;
        ClientHelper.drawPoolManaHUD(res, name, this.knownMana, this.getMaxMana(), color);
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public int getMaxMana() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return ConfigABHandler.maxContainerMana[Math.min(Math.max(meta, 0), ConfigABHandler.maxContainerMana.length)];
    }

    public boolean isFull() {
        return this.mana == this.getMaxMana();
    }

    public void recieveMana(int mana) {
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, this.getMaxMana()));
    }

    public void writeCustomNBT(NBTTagCompound nbtt) {
        nbtt.func_74768_a("mana", this.mana);
    }

    public void readCustomNBT(NBTTagCompound nbtt) {
        this.mana = nbtt.func_74762_e("mana");
        if (nbtt.func_74764_b("knownMana")) {
            this.knownMana = nbtt.func_74762_e("knownMana");
        }
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    public void attachSpark(ISparkEntity entity) {
    }

    public boolean canAttachSpark(ItemStack arg0) {
        return true;
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_72872_a(ISparkEntity.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public int getAvailableSpaceForMana() {
        return Math.max(0, this.getMaxMana() - this.getCurrentMana());
    }

    public boolean isOutputtingPower() {
        return false;
    }
}

