/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.tile;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.relics.ItemThaumonomicon;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.tiles.TileMagicWorkbench;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.item.ModItems;

public class TileMagicCraftCrate
extends TileMagicWorkbench
implements ISidedInventory,
IInventory {
    private static final String WAITING_TAG = "waitingStack";
    private static final String PATTERN_TAG = "pattern";
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private boolean[][] pattern;
    private EntityPlayer player;
    int signal = 0;
    private ItemStack waitingStack;
    ItemStack[] inventorySlots = new ItemStack[this.func_70302_i_()];

    public TileMagicCraftCrate() {
        this.pattern = new boolean[][]{{true, true, true}, {true, true, true}, {true, true, true}};
    }

    public void func_145845_h() {
        int newSignal;
        if (!this.field_145850_b.field_72995_K && (this.craft(true) && this.canEject() || this.isFull() && !this.isWaiting())) {
            this.ejectAll();
        }
        for (newSignal = 0; newSignal < 9 && (this.isLocked(newSignal) || this.func_70301_a(newSignal) != null); ++newSignal) {
        }
        if (this.isWaiting()) {
            newSignal = 14;
        }
        if (newSignal != this.signal) {
            this.signal = newSignal;
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    boolean craft(boolean fullCheck) {
        if (fullCheck && !this.isFull()) {
            return false;
        }
        if (this.player == null) {
            return false;
        }
        TileMagicWorkbench craft = new TileMagicWorkbench(){

            public void func_70299_a(int par1, ItemStack par2ItemStack) {
                this.stackList[par1] = par2ItemStack;
            }

            public ItemStack func_70298_a(int par1, int par2) {
                if (this.stackList[par1] == null) {
                    return null;
                }
                if (this.stackList[par1].field_77994_a <= par2) {
                    ItemStack var3 = this.stackList[par1];
                    this.stackList[par1] = null;
                    return var3;
                }
                ItemStack var3 = this.stackList[par1].func_77979_a(par2);
                if (this.stackList[par1].field_77994_a == 0) {
                    this.stackList[par1] = null;
                }
                return var3;
            }
        };
        for (int i = 0; i < 10; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || this.isLocked(i) || stack.func_77973_b() == ModItems.manaResource && stack.func_77960_j() == 11) continue;
            craft.func_70299_a(i, stack.func_77946_l());
        }
        ItemStack result = ThaumcraftCraftingManager.findMatchingArcaneRecipe((IInventory)craft, (EntityPlayer)this.player);
        if (result != null) {
            AspectList aspects = ThaumcraftCraftingManager.findMatchingArcaneRecipeAspects((IInventory)craft, (EntityPlayer)this.player);
            if (aspects.size() > 0 && this.func_70301_a(10) != null) {
                ItemWandCasting wand = (ItemWandCasting)this.func_70301_a(10).func_77973_b();
                if (wand.consumeAllVisCrafting(this.func_70301_a(10), this.player, aspects, true)) {
                    for (int var2 = 0; var2 < 9; ++var2) {
                        ItemStack var3 = craft.func_70301_a(var2);
                        if (var3 == null) continue;
                        craft.func_70298_a(var2, 1);
                    }
                    for (int i = 0; i < 9; ++i) {
                        this.func_70299_a(i, craft.func_70301_a(i));
                    }
                    this.func_70299_a(9, result);
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemCraftedEvent(this.player, result, (IInventory)craft));
                    this.waitingStack = null;
                    return true;
                }
                this.waitingStack = result;
                this.func_70296_d();
            }
        } else {
            this.waitingStack = null;
        }
        return false;
    }

    boolean isFull() {
        for (int i = 0; i < 9; ++i) {
            if (this.isLocked(i) || this.func_70301_a(i) != null) continue;
            return false;
        }
        return true;
    }

    public boolean[][] getPattern() {
        return this.pattern;
    }

    public void setPattern(boolean[][] pattern) {
        this.pattern = pattern;
    }

    public int func_70302_i_() {
        return 12;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    public int getSignal() {
        return this.signal;
    }

    public ItemStack getWaitingStack() {
        return this.waitingStack;
    }

    private boolean isWaiting() {
        return this.waitingStack != null;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i < 9 && !this.isLocked(i)) {
            return true;
        }
        if (i == 9) {
            return false;
        }
        if (i == 10) {
            if (!(itemstack.func_77973_b() instanceof ItemWandCasting)) {
                return false;
            }
            ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
            return !wand.isStaff(itemstack);
        }
        return itemstack.func_77973_b() instanceof ItemThaumonomicon;
    }

    private boolean isLocked(int slot) {
        return this.pattern != null && !this.pattern[slot / 3][slot % 3];
    }

    public void readCustomNBT(NBTTagCompound nbtt) {
        super.readCustomNBT(nbtt);
        NBTTagList var2 = nbtt.func_150295_c("Items", 10);
        this.inventorySlots = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.inventorySlots.length) continue;
            this.inventorySlots[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.pattern[i][j] = nbtt.func_74767_n(PATTERN_TAG + i * 3 + j);
            }
        }
        NBTTagCompound nbtt1 = nbtt.func_74775_l(WAITING_TAG);
        if (nbtt1 != null) {
            this.waitingStack = ItemStack.func_77949_a((NBTTagCompound)nbtt1);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbtt) {
        super.writeCustomNBT(nbtt);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.inventorySlots.length; ++var3) {
            if (this.inventorySlots[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.inventorySlots[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbtt.func_74782_a("Items", (NBTBase)var2);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                nbtt.func_74757_a(PATTERN_TAG + i * 3 + j, this.pattern[i][j]);
            }
        }
        NBTTagCompound nbtt1 = new NBTTagCompound();
        if (this.waitingStack != null) {
            this.waitingStack.func_77955_b(nbtt1);
            nbtt.func_74782_a(WAITING_TAG, (NBTBase)nbtt1);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(manager, packet);
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 10, compound);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 9;
    }

    public int[] func_94128_d(int side) {
        return ACCESSIBLE_SLOTS;
    }

    public boolean func_102007_a(int i, ItemStack stack, int j) {
        return i < 9;
    }

    public int func_70297_j_() {
        return 1;
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        return 0;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        this.player = player;
        return wandstack;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    public void ejectAll() {
        for (int i = 0; i < 10; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack != null) {
                this.eject(stack, false);
            }
            this.func_70299_a(i, null);
        }
        this.waitingStack = null;
        this.func_70296_d();
    }

    public void eject(ItemStack stack, boolean redstone) {
        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.5, (double)this.field_145849_e + 0.5, stack);
        item.field_70159_w = 0.0;
        item.field_70181_x = 0.0;
        item.field_70179_y = 0.0;
        if (redstone) {
            item.field_70292_b = -200;
        }
        this.func_70299_a(0, null);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    public boolean canEject() {
        Block blockBelow = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return blockBelow.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) || blockBelow.func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == null;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventorySlots[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventorySlots[i] != null) {
            if (this.inventorySlots[i].field_77994_a <= j) {
                ItemStack stackAt = this.inventorySlots[i];
                this.inventorySlots[i] = null;
                return stackAt;
            }
            ItemStack stackAt = this.inventorySlots[i].func_77979_a(j);
            if (this.inventorySlots[i].field_77994_a == 0) {
                this.inventorySlots[i] = null;
            }
            return stackAt;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventorySlots[i] = itemstack;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

