/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block;

import ab.api.AdvancedBotanyAPI;
import ab.api.TerraFarmlandList;
import ab.common.lib.register.RecipeListAB;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;

public class BlockTerraFarmland
extends Block
implements ILexiconable {
    private IIcon icon;

    public BlockTerraFarmland() {
        super(Material.field_151578_c);
        this.func_149675_a(true);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.func_149663_c("terraFarmland");
        this.func_149713_g(255);
        this.func_149672_a(field_149767_g);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        Block plant = plantable.getPlant(world, x, y + 1, z);
        return plant != Blocks.field_150434_aF && plant != Blocks.field_150436_aH;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        Block block = world.func_147439_a(x, y + 1, z);
        int meta = world.func_72805_g(x, y + 1, z);
        if (block instanceof BlockCrops) {
            if (meta == 7) {
                this.refreshSeed(world, x, y, z, block, meta);
                return;
            }
        } else if (block instanceof IPlantable) {
            for (TerraFarmlandList fSeed : AdvancedBotanyAPI.farmlandList) {
                int meta1 = fSeed.getMeta();
                Block block1 = fSeed.getBlock();
                if (block != block1 || meta != meta1) continue;
                this.refreshSeed(world, x, y, z, block1, meta1);
                return;
            }
        } else {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
    }

    private void refreshSeed(World world, int x, int y, int z, Block block, int meta) {
        List items = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 4), (double)(y - 4), (double)(z - 4), (double)(x + 4), (double)(y + 4), (double)(z + 4)));
        if (!items.isEmpty() && items.size() > 7) {
            return;
        }
        IPlantable seed = (IPlantable)block;
        ArrayList list = block.getDrops(world, x, y + 1, z, meta, 0);
        for (ItemStack stack : list) {
            if (stack == null) continue;
            if (stack.func_77973_b() == seed) {
                if (stack.field_77994_a <= 1) continue;
                --stack.field_77994_a;
                continue;
            }
            stack.field_77994_a = Math.min(64, (int)((float)stack.field_77994_a * 2.5f));
        }
        for (ItemStack stack : list) {
            if (stack == null) continue;
            EntityItem itemEnt = new EntityItem(world, (double)((float)x + 0.5f), (double)(y + 1), (double)((float)z + 0.5f), stack);
            world.func_72838_d((Entity)itemEnt);
        }
        world.func_147465_d(x, y + 1, z, block, 0, 3);
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return AxisAlignedBB.func_72330_a((double)(p_149668_2_ + 0), (double)(p_149668_3_ + 0), (double)(p_149668_4_ + 0), (double)(p_149668_2_ + 1), (double)(p_149668_3_ + 1), (double)(p_149668_4_ + 1));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Blocks.field_150346_d.func_149650_a(0, p_149650_2_, p_149650_3_);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World p_149694_1_, int p_149694_2_, int p_149694_3_, int p_149694_4_) {
        return Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return p_149691_1_ == 1 ? this.icon : Blocks.field_150346_d.func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icon = reg.func_94245_a("ab:terraFarmland");
    }

    public LexiconEntry getEntry(World world, int x, int y, int z, EntityPlayer player, ItemStack lexicon) {
        return RecipeListAB.terraHoe;
    }
}

