/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration.notenoughitems;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import com.jaquadro.minecraft.storagedrawers.integration.notenoughitems.UpgradeItemRecipeHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Optional.Interface(iface="codechicken.nei.api.IConfigureNEI", modid="NotEnoughItems")
public class NEIStorageDrawersConfig
implements IConfigureNEI {
    private static Set<ItemStack> pendingHide = new HashSet<ItemStack>();
    private static boolean loaded;

    @Optional.Method(modid="NotEnoughItems")
    public void loadConfig() {
        for (ItemStack stack : pendingHide) {
            API.hideItem((ItemStack)stack);
        }
        API.registerRecipeHandler((ICraftingHandler)new UpgradeItemRecipeHandler());
        pendingHide.clear();
        loaded = true;
    }

    @Optional.Method(modid="NotEnoughItems")
    public String getName() {
        return "Storage Drawers";
    }

    @Optional.Method(modid="NotEnoughItems")
    public String getVersion() {
        return "1.7.10-1.10.9";
    }

    private static void hideItem(ItemStack stack) {
        API.hideItem((ItemStack)stack);
    }

    public static void hideBlock(String blockID) {
        Block block = (Block)GameData.getBlockRegistry().func_82594_a(blockID);
        if (block != null) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
            if (loaded) {
                NEIStorageDrawersConfig.hideItem(stack);
            } else {
                pendingHide.add(stack);
            }
        }
    }
}

