/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.tools;

import net.fabricmc.loader.util.sat4j.specs.IConstr;
import net.fabricmc.loader.util.sat4j.specs.ISolverService;
import net.fabricmc.loader.util.sat4j.specs.Lbool;
import net.fabricmc.loader.util.sat4j.tools.IVisualizationTool;
import net.fabricmc.loader.util.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeedTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private final IVisualizationTool visuTool;
    private final IVisualizationTool cleanVisuTool;
    private final IVisualizationTool restartVisuTool;
    private long begin;
    private long end;
    private int counter;
    private long index;
    private double maxY;

    public SpeedTracing(IVisualizationTool visuTool, IVisualizationTool cleanVisuTool, IVisualizationTool restartVisuTool) {
        this.visuTool = visuTool;
        this.cleanVisuTool = cleanVisuTool;
        this.restartVisuTool = restartVisuTool;
        visuTool.init();
        cleanVisuTool.init();
        restartVisuTool.init();
        this.begin = System.currentTimeMillis();
        this.counter = 0;
        this.index = 0L;
        this.maxY = 0.0;
    }

    @Override
    public void propagating(int p, IConstr reason) {
        this.end = System.currentTimeMillis();
        if (this.end - this.begin >= 2000L) {
            long tmp = this.end - this.begin;
            this.index += tmp;
            double y = (long)this.counter / tmp * 1000L;
            if (y > this.maxY) {
                this.maxY = y;
            }
            this.visuTool.addPoint((double)this.index / 1000.0, y);
            this.cleanVisuTool.addPoint((double)this.index / 1000.0, 0.0);
            this.restartVisuTool.addPoint((double)this.index / 1000.0, 0.0);
            this.begin = System.currentTimeMillis();
            this.counter = 0;
        }
        ++this.counter;
    }

    @Override
    public void end(Lbool result) {
        this.visuTool.end();
        this.cleanVisuTool.end();
        this.restartVisuTool.end();
    }

    @Override
    public void cleaning() {
        this.end = System.currentTimeMillis();
        long indexClean = this.index + this.end - this.begin;
        this.visuTool.addPoint((double)indexClean / 1000.0, (long)this.counter / (this.end - this.begin) * 1000L);
        this.cleanVisuTool.addPoint((double)indexClean / 1000.0, this.maxY);
        this.restartVisuTool.addInvisiblePoint(indexClean, 0.0);
    }

    @Override
    public void restarting() {
        this.end = System.currentTimeMillis();
        long indexRestart = this.index + this.end - this.begin;
        double y = (long)this.counter / (this.end - this.begin) * 1000L;
        this.visuTool.addPoint((double)indexRestart / 1000.0, y);
        if (y > this.maxY) {
            this.maxY = y;
        }
        this.restartVisuTool.addPoint((double)indexRestart / 1000.0, this.maxY);
        this.cleanVisuTool.addInvisiblePoint(indexRestart, 0.0);
    }

    @Override
    public void start() {
        this.visuTool.init();
        this.cleanVisuTool.init();
        this.restartVisuTool.init();
        this.begin = System.currentTimeMillis();
        this.counter = 0;
        this.index = 0L;
    }
}

