/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.tools;

import java.util.Iterator;
import net.fabricmc.loader.util.sat4j.core.VecInt;
import net.fabricmc.loader.util.sat4j.specs.ContradictionException;
import net.fabricmc.loader.util.sat4j.specs.IConstr;
import net.fabricmc.loader.util.sat4j.specs.ISolver;
import net.fabricmc.loader.util.sat4j.specs.IVecInt;
import net.fabricmc.loader.util.sat4j.specs.TimeoutException;
import net.fabricmc.loader.util.sat4j.tools.AbstractMinimalModel;
import net.fabricmc.loader.util.sat4j.tools.SolutionFoundListener;

public class Minimal4CardinalityModel
extends AbstractMinimalModel {
    private static final long serialVersionUID = 1L;
    private int[] prevfullmodel;

    public Minimal4CardinalityModel(ISolver solver) {
        super(solver);
    }

    public Minimal4CardinalityModel(ISolver solver, IVecInt p, SolutionFoundListener modelListener) {
        super(solver, p, modelListener);
    }

    public Minimal4CardinalityModel(ISolver solver, IVecInt p) {
        super(solver, p);
    }

    public Minimal4CardinalityModel(ISolver solver, SolutionFoundListener modelListener) {
        super(solver, modelListener);
    }

    public int[] model() {
        int[] prevmodel = null;
        IConstr lastOne = null;
        VecInt literals = new VecInt(this.pLiterals.size());
        Iterator iterator = this.pLiterals.iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            literals.push(p);
        }
        try {
            do {
                this.prevfullmodel = super.modelWithInternalVariables();
                prevmodel = super.model();
                int counter = 0;
                for (int q : this.prevfullmodel) {
                    if (!this.pLiterals.contains(q)) continue;
                    ++counter;
                }
                lastOne = this.addAtMost(literals, counter - 1);
            } while (this.isSatisfiable());
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Solver timed out");
        }
        catch (ContradictionException contradictionException) {
            // empty catch block
        }
        if (lastOne != null) {
            this.removeConstr(lastOne);
        }
        return prevmodel;
    }

    public int[] modelWithInternalVariables() {
        this.model();
        return this.prevfullmodel;
    }
}

