/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.block;

import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.block.BlockAltar;
import WayofTime.alchemicalWizardry.common.block.BlockMasterStone;
import WayofTime.alchemicalWizardry.common.bloodAltarUpgrade.AltarComponent;
import WayofTime.alchemicalWizardry.common.bloodAltarUpgrade.AltarUpgradeComponent;
import WayofTime.alchemicalWizardry.common.bloodAltarUpgrade.UpgradedAltars;
import WayofTime.alchemicalWizardry.common.tileEntity.TEAltar;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import com.arc.bloodarsenal.common.block.BlockCompactedMRS;
import com.arc.bloodarsenal.common.block.BlockPortableAltar;
import com.arc.bloodarsenal.common.block.ModBlocks;
import com.arc.bloodarsenal.common.tileentity.TileCompactedMRS;
import com.arc.bloodarsenal.common.tileentity.TileCompacter;
import com.arc.bloodarsenal.common.tileentity.TilePortableAltar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BlockCompacter
extends BlockContainer {
    private String ritualName;
    private int direction;
    private int tier;
    private int lpAmount;
    private int capacity;
    private float consumptionMultiplier;
    private float efficiencyMultiplier;
    private float sacrificeEfficiencyMultiplier;
    private float selfSacrificeEfficiencyMultiplier;
    private float capacityMultiplier;
    private float orbCapacityMultiplier;
    private float dislocationMultiplier;
    private int bufferCapacity;
    private int speedUpgrades = 0;
    private int efficiencyUpgrades = 0;
    private int sacrificeUpgrades = 0;
    private int selfSacrificeUpgrades = 0;
    private int displacementUpgrades = 0;
    private int altarCapacitiveUpgrades = 0;
    private int orbCapacitiveUpgrades = 0;
    private int betterCapacitiveUpgrades = 0;
    private int accelerationUpgrades = 0;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon;

    public BlockCompacter() {
        super(Material.field_151573_f);
        this.func_149711_c(8.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149777_j);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int idk, float what, float these, float are) {
        world.func_147471_g(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && !player.func_70093_af()) {
            ItemStack playerItem = player.func_71045_bC();
            if (playerItem == null) {
                return false;
            }
            Item item = playerItem.func_77973_b();
            if (!(item instanceof IBloodOrb)) {
                return false;
            }
            Block block = world.func_147439_a(x, y + 1, z);
            if (block != null) {
                world.func_147471_g(x, y, z);
                world.func_147471_g(x, y + 1, z);
                String owner = player.func_70005_c_();
                int currentEssence = SoulNetworkHandler.getCurrentEssence((String)owner);
                if (block instanceof BlockMasterStone) {
                    TileEntity tile = world.func_147438_o(x, y + 1, z);
                    this.checkRitual(tile);
                    List ritualList = Rituals.getRitualList((String)this.ritualName);
                    if (ritualList == null) {
                        return false;
                    }
                    float multiplier = 1.0f;
                    for (RitualComponent ritualComponent : ritualList) {
                        int stoneType = ritualComponent.getStoneType();
                        switch (stoneType) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                multiplier *= 1.05f;
                                break;
                            }
                            case 2: {
                                multiplier *= 1.05f;
                                break;
                            }
                            case 3: {
                                multiplier *= 1.05f;
                                break;
                            }
                            case 4: {
                                multiplier *= 1.05f;
                                break;
                            }
                            case 5: {
                                multiplier *= 1.075f;
                            }
                        }
                    }
                    int activationCost = Rituals.getCostForActivation((String)this.ritualName);
                    int cost = activationCost * (int)multiplier / 2;
                    if (cost <= currentEssence) {
                        this.compactRitual(tile);
                        SoulNetworkHandler.syphonFromNetwork((String)owner, (int)cost);
                        --player.field_71071_by.func_70448_g().field_77994_a;
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.compacter.notEnoughLP")));
                        return true;
                    }
                    return true;
                }
                if (block instanceof BlockAltar && world.func_147438_o(x, y + 1, z) != null) {
                    TileEntity tile = world.func_147438_o(x, y + 1, z);
                    TEAltar altar = (TEAltar)tile;
                    this.checkAltar(altar);
                    if (this.tier == 0) {
                        return false;
                    }
                    if (altar.func_70301_a(0) != null) {
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.compacter.itemInAltar")));
                    } else {
                        float multiplier = 1.0f;
                        AltarUpgradeComponent upgradeComponent = UpgradedAltars.getUpgrades((World)world, (int)x, (int)(y + 1), (int)z, (int)this.tier);
                        int speedUpgrades = upgradeComponent.getSpeedUpgrades();
                        int efficiencyUpgrades = upgradeComponent.getEfficiencyUpgrades();
                        int sacrificeUpgrades = upgradeComponent.getSacrificeUpgrades();
                        int selfSacrificeUpgrades = upgradeComponent.getSelfSacrificeUpgrades();
                        int displacementUpgrades = upgradeComponent.getDisplacementUpgrades();
                        int altarCapacitiveUpgrades = upgradeComponent.getAltarCapacitiveUpgrades();
                        int orbCapacitiveUpgrades = upgradeComponent.getOrbCapacitiveUpgrades();
                        int betterCapacitiveUpgrades = upgradeComponent.getBetterCapacitiveUpgrades();
                        int accelerationUpgrades = upgradeComponent.getAccelerationUpgrades();
                        multiplier *= (float)((speedUpgrades + 4) / 4);
                        multiplier *= (float)((efficiencyUpgrades + 3) / 3);
                        multiplier *= (float)((sacrificeUpgrades + 3) / 3);
                        multiplier *= (float)((selfSacrificeUpgrades + 3) / 3);
                        multiplier *= (float)((displacementUpgrades + 3) / 3);
                        multiplier *= (float)((altarCapacitiveUpgrades + 3) / 3);
                        multiplier *= (float)((orbCapacitiveUpgrades + 3) / 3);
                        multiplier *= (float)((betterCapacitiveUpgrades + 2) / 2);
                        multiplier *= (float)((accelerationUpgrades + 3) / 3);
                        IBloodOrb bloodOrb = (IBloodOrb)item;
                        if (bloodOrb.getOrbLevel() >= this.tier) {
                            int cost = this.tier * 10 * (int)(multiplier * 5.0f) + this.capacity;
                            if (cost <= currentEssence) {
                                this.compactAltar(tile);
                                SoulNetworkHandler.syphonFromNetwork((String)owner, (int)cost);
                                --player.field_71071_by.func_70448_g().field_77994_a;
                            } else {
                                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.compacter.notEnoughLP")));
                            }
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.compacter.wrongOrbTier")));
                        }
                    }
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 1 ? this.topIcon : (side == 0 ? this.field_149761_L : this.sideIcon);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a(this.func_149641_N() + "_bottom");
        this.topIcon = p_149651_1_.func_94245_a(this.func_149641_N() + "_top");
        this.sideIcon = p_149651_1_.func_94245_a(this.func_149641_N() + "_side");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileCompacter();
    }

    private void checkRitual(TileEntity tileEntity) {
        TEMasterStone masterStone = (TEMasterStone)tileEntity;
        World world = masterStone.getWorld();
        int x = masterStone.field_145851_c;
        int y = masterStone.field_145848_d;
        int z = masterStone.field_145849_e;
        this.ritualName = Rituals.checkValidRitual((World)world, (int)x, (int)y, (int)z);
        if (this.ritualName.equals("")) {
            return;
        }
        this.direction = Rituals.getDirectionOfRitual((World)world, (int)x, (int)y, (int)z, (String)this.ritualName);
        world.func_147471_g(x, y, z);
        world.func_147471_g(x, y + 1, z);
    }

    private void compactRitual(TileEntity tileEntity) {
        TEMasterStone masterStone = (TEMasterStone)tileEntity;
        World world = masterStone.getWorld();
        int x = masterStone.field_145851_c;
        int y = masterStone.field_145848_d;
        int z = masterStone.field_145849_e;
        List ritualList = Rituals.getRitualList((String)this.ritualName);
        if (ritualList == null) {
            return;
        }
        for (RitualComponent ritualComponent : ritualList) {
            world.func_147468_f(x + ritualComponent.getX(this.direction), y + ritualComponent.getY(), z + ritualComponent.getZ(this.direction));
            world.func_147468_f(x, y, z);
            world.func_147471_g(x + ritualComponent.getX(this.direction), y + ritualComponent.getY(), z + ritualComponent.getZ(this.direction));
        }
        world.func_147449_b(x, y, z, ModBlocks.compacted_mrs);
        Block block = world.func_147439_a(x, y, z);
        this.configureMRS(world, x, y, z, block);
        world.func_147471_g(x, y, z);
    }

    private void configureMRS(World world, int x, int y, int z, Block block) {
        if (block instanceof BlockCompactedMRS && world.func_147439_a(x, y, z) == block) {
            TileCompactedMRS tile = (TileCompactedMRS)world.func_147438_o(x, y, z);
            tile.setRitualName(this.ritualName);
            world.func_147471_g(x, y, z);
            world.func_72942_c((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z));
        }
    }

    private void checkAltar(TEAltar altar) {
        World world = altar.func_145831_w();
        int x = altar.field_145851_c;
        int y = altar.field_145848_d;
        int z = altar.field_145849_e;
        this.tier = altar.getTier();
        if (this.tier == 0) {
            return;
        }
        AltarUpgradeComponent upgrades = UpgradedAltars.getUpgrades((World)world, (int)x, (int)y, (int)z, (int)this.tier);
        if (upgrades == null) {
            this.consumptionMultiplier = 0.0f;
            this.efficiencyMultiplier = 1.0f;
            this.sacrificeEfficiencyMultiplier = 0.0f;
            this.selfSacrificeEfficiencyMultiplier = 0.0f;
            this.capacityMultiplier = 1.0f;
            this.orbCapacityMultiplier = 1.0f;
            this.dislocationMultiplier = 1.0f;
            this.accelerationUpgrades = 0;
            return;
        }
        this.lpAmount = altar.getFluidAmount();
        this.consumptionMultiplier = (float)(0.2 * (double)upgrades.getSpeedUpgrades());
        this.efficiencyMultiplier = (float)Math.pow(0.85, upgrades.getSpeedUpgrades());
        this.sacrificeEfficiencyMultiplier = (float)(0.1 * (double)upgrades.getSacrificeUpgrades());
        this.selfSacrificeEfficiencyMultiplier = (float)(0.1 * (double)upgrades.getSelfSacrificeUpgrades());
        this.capacityMultiplier = (float)(1.0 * Math.pow(1.1, upgrades.getBetterCapacitiveUpgrades()) + 0.2 * (double)upgrades.getAltarCapacitiveUpgrades());
        this.dislocationMultiplier = (float)Math.pow(1.2, upgrades.getDisplacementUpgrades());
        this.orbCapacityMultiplier = (float)(1.0 + 0.02 * (double)upgrades.getOrbCapacitiveUpgrades());
        this.capacity = (int)(10000.0f * this.capacityMultiplier);
        this.bufferCapacity = (int)(1000.0f * this.capacityMultiplier);
        this.speedUpgrades = upgrades.getSpeedUpgrades();
        this.efficiencyUpgrades = upgrades.getEfficiencyUpgrades();
        this.sacrificeUpgrades = upgrades.getSacrificeUpgrades();
        this.selfSacrificeUpgrades = upgrades.getSelfSacrificeUpgrades();
        this.displacementUpgrades = upgrades.getDisplacementUpgrades();
        this.altarCapacitiveUpgrades = upgrades.getAltarCapacitiveUpgrades();
        this.orbCapacitiveUpgrades = upgrades.getOrbCapacitiveUpgrades();
        this.betterCapacitiveUpgrades = upgrades.getBetterCapacitiveUpgrades();
        this.accelerationUpgrades = upgrades.getAccelerationUpgrades();
        world.func_147471_g(x, y, z);
        world.func_147471_g(x, y - 1, z);
    }

    private void compactAltar(TileEntity tileEntity) {
        TEAltar altar = (TEAltar)tileEntity;
        World world = altar.func_145831_w();
        int x = altar.field_145851_c;
        int y = altar.field_145848_d;
        int z = altar.field_145849_e;
        List altarComponents = UpgradedAltars.getAltarUpgradeListForTier((int)this.tier);
        if (altarComponents != null && !world.field_72995_K) {
            for (AltarComponent altarComponent : altarComponents) {
                world.func_147468_f(x + altarComponent.getX(), y + altarComponent.getY(), z + altarComponent.getZ());
                world.func_147468_f(x, y, z);
                world.func_147471_g(x + altarComponent.getX(), y + altarComponent.getY(), z + altarComponent.getZ());
            }
        }
        world.func_147449_b(x, y, z, (Block)ModBlocks.portable_altar);
        Block altarBlock = world.func_147439_a(x, y, z);
        this.configureAltar(world, x, y, z, altarBlock);
        world.func_147471_g(x, y, z);
        world.func_147471_g(x, y - 1, z);
    }

    private void configureAltar(World world, int x, int y, int z, Block block) {
        if (block instanceof BlockPortableAltar && world.func_147439_a(x, y, z) == block) {
            TilePortableAltar altar = (TilePortableAltar)world.func_147438_o(x, y, z);
            altar.setTier(this.tier);
            altar.setCurrentBlood(this.lpAmount);
            altar.setConsumptionMultiplier(this.consumptionMultiplier);
            altar.setEfficiencyMultiplier(this.efficiencyMultiplier);
            altar.setSacrificeMultiplier(this.sacrificeEfficiencyMultiplier);
            altar.setSelfSacrificeMultiplier(this.selfSacrificeEfficiencyMultiplier);
            altar.setOrbMultiplier(this.orbCapacityMultiplier);
            altar.setDislocationMultiplier(this.dislocationMultiplier);
            altar.setCapacityMultiplier(this.capacityMultiplier);
            altar.setCapacity(this.capacity);
            altar.setBufferCapacity(this.bufferCapacity);
            altar.setUpgrades(this.speedUpgrades, this.efficiencyUpgrades, this.sacrificeUpgrades, this.selfSacrificeUpgrades, this.displacementUpgrades, this.altarCapacitiveUpgrades, this.orbCapacitiveUpgrades, this.betterCapacitiveUpgrades, this.accelerationUpgrades);
            world.func_147471_g(x, y, z);
            world.func_72942_c((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z));
        }
    }
}

