/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInvokeDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodHandle;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodType;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Constant
implements Cloneable,
Node {
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            Constant THIS = (Constant)o1;
            Constant THAT = (Constant)o2;
            return THIS.toString().equals(THAT.toString());
        }

        @Override
        public int hashCode(Object o) {
            Constant THIS = (Constant)o;
            return THIS.toString().hashCode();
        }
    };
    private byte tag;

    Constant(byte tag) {
        this.tag = tag;
    }

    @Override
    public abstract void accept(Visitor var1);

    public abstract void dump(DataOutputStream var1) throws IOException;

    public final byte getTag() {
        return this.tag;
    }

    public String toString() {
        return Const.getConstantName(this.tag) + "[" + this.tag + "]";
    }

    public Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    public static Constant readConstant(DataInput input) throws IOException, ClassFormatException {
        byte b = input.readByte();
        switch (b) {
            case 7: {
                return new ConstantClass(input);
            }
            case 9: {
                return new ConstantFieldref(input);
            }
            case 10: {
                return new ConstantMethodref(input);
            }
            case 11: {
                return new ConstantInterfaceMethodref(input);
            }
            case 8: {
                return new ConstantString(input);
            }
            case 3: {
                return new ConstantInteger(input);
            }
            case 4: {
                return new ConstantFloat(input);
            }
            case 5: {
                return new ConstantLong(input);
            }
            case 6: {
                return new ConstantDouble(input);
            }
            case 12: {
                return new ConstantNameAndType(input);
            }
            case 1: {
                return ConstantUtf8.getInstance(input);
            }
            case 15: {
                return new ConstantMethodHandle(input);
            }
            case 16: {
                return new ConstantMethodType(input);
            }
            case 18: {
                return new ConstantInvokeDynamic(input);
            }
        }
        throw new ClassFormatException("Invalid byte tag in constant pool: " + b);
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator comparator) {
        bcelComparator = comparator;
    }

    public boolean equals(Object obj) {
        return bcelComparator.equals(this, obj);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

