/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.Chunk;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkHeader;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkMetadata;
import com.jrockit.mc.flightrecorder.internal.parser.binary.EventParserManager;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LoaderContext;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;

public class ChunkLoader
implements Runnable {
    private final ChunkHeader header;
    private final byte[] data;
    private final LoaderContext context;

    public ChunkLoader(ChunkHeader header, byte[] data, LoaderContext context) {
        this.data = data;
        this.context = context;
        this.header = header;
    }

    @Override
    public void run() {
        try {
            try {
                ChunkMetadata metaData = new ChunkMetadata(this.data, this.header.getMetaDataOffset());
                EventParserManager eventParser = new EventParserManager(metaData, this.data, this.context.getGlobalObjects());
                int nextEventIndex = ChunkHeader.CHUNK_HEAD_SIZE;
                int dataLength = this.header.getMetaDataOffset();
                while (nextEventIndex < dataLength) {
                    Offset offset = new Offset(this.data, nextEventIndex);
                    nextEventIndex = offset.getEnd();
                    int eventTypeId = IntegerParser.readInt(this.data, offset);
                    if (eventTypeId == 0 || eventTypeId == 1) continue;
                    eventParser.loadEvent(this.data, offset, eventTypeId);
                }
                Chunk chunk = new Chunk(this.header, metaData, eventParser.getEvents(), eventParser.getStartTime(), eventParser.getEndTime());
                this.context.chunkLoaded(chunk);
            }
            catch (Throwable e) {
                this.context.setFailed(e);
                this.context.returnBuffer(this.data);
            }
        }
        finally {
            this.context.returnBuffer(this.data);
        }
    }
}

