/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingDefinition;
import appeng.api.parts.IAlphaPassItem;
import appeng.block.solids.OreQuartz;
import appeng.client.render.BusRenderer;
import appeng.core.FacadeConfig;
import appeng.core.features.AEFeature;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemFacade
extends AEBaseItem
implements IFacadeItem,
IAlphaPassItem {
    private List<ItemStack> subTypes = null;

    public ItemFacade() {
        this.setFeature(EnumSet.of(AEFeature.Facades));
        this.func_77627_a(true);
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)BusRenderer.INSTANCE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return AEApi.instance().partHelper().placeBus(is, x, y, z, side, player, w);
    }

    public String func_77653_i(ItemStack is) {
        try {
            ItemStack in = this.getTextureItem(is);
            if (in != null) {
                return super.func_77653_i(is) + " - " + in.func_82833_r();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.func_77653_i(is);
    }

    @Override
    protected void getCheckedSubItems(Item sameItem, CreativeTabs creativeTab, List<ItemStack> itemStacks) {
        this.calculateSubTypes();
        itemStacks.addAll(this.subTypes);
    }

    private void calculateSubTypes() {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList<ItemStack>(1000);
            for (Object blk : Block.field_149771_c) {
                Block b = (Block)blk;
                try {
                    Item item = Item.func_150898_a((Block)b);
                    ArrayList tmpList = new ArrayList(100);
                    b.func_149666_a(item, b.func_149708_J(), tmpList);
                    for (ItemStack l : tmpList) {
                        ItemStack facade = this.createFacadeForItem(l, false);
                        if (facade == null) continue;
                        this.subTypes.add(facade);
                    }
                }
                catch (Throwable throwable) {
                }
            }
            if (FacadeConfig.instance.hasChanged()) {
                FacadeConfig.instance.save();
            }
        }
    }

    public ItemStack createFacadeForItem(ItemStack l, boolean returnItem) {
        boolean defaultValue;
        if (l == null) {
            return null;
        }
        Block b = Block.func_149634_a((Item)l.func_77973_b());
        if (b == null || l.func_77942_o()) {
            return null;
        }
        int metadata = l.func_77973_b().func_77647_b(l.func_77960_j());
        boolean hasTile = b.hasTileEntity(metadata);
        boolean enableGlass = b instanceof BlockGlass || b instanceof BlockStainedGlass;
        boolean disableOre = b instanceof OreQuartz;
        boolean bl = defaultValue = b.func_149662_c() && !b.func_149653_t() && !hasTile && !disableOre || enableGlass;
        if (FacadeConfig.instance.checkEnabled(b, metadata, defaultValue)) {
            if (returnItem) {
                return l;
            }
            ItemStack is = new ItemStack((Item)this);
            NBTTagCompound data = new NBTTagCompound();
            int[] ds = new int[]{Item.func_150891_b((Item)l.func_77973_b()), metadata};
            data.func_74783_a("x", ds);
            GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)l.func_77973_b());
            data.func_74778_a("modid", ui.modId);
            data.func_74778_a("itemname", ui.name);
            is.func_77982_d(data);
            return is;
        }
        return null;
    }

    @Override
    public FacadePart createPartFromItemStack(ItemStack is, ForgeDirection side) {
        ItemStack in = this.getTextureItem(is);
        if (in != null) {
            return new FacadePart(is, side);
        }
        return null;
    }

    @Override
    public ItemStack getTextureItem(ItemStack is) {
        Block blk = this.getBlock(is);
        if (blk != null) {
            return new ItemStack(blk, 1, this.getMeta(is));
        }
        return null;
    }

    @Override
    public int getMeta(ItemStack is) {
        int[] blk;
        NBTTagCompound data = is.func_77978_p();
        if (data != null && (blk = data.func_74759_k("x")) != null && blk.length == 2) {
            return blk[1];
        }
        return 0;
    }

    @Override
    public Block getBlock(ItemStack is) {
        NBTTagCompound data = is.func_77978_p();
        if (data != null) {
            if (data.func_74764_b("modid") && data.func_74764_b("itemname")) {
                return GameRegistry.findBlock((String)data.func_74779_i("modid"), (String)data.func_74779_i("itemname"));
            }
            int[] blk = data.func_74759_k("x");
            if (blk != null && blk.length == 2) {
                return Block.func_149729_e((int)blk[0]);
            }
        }
        return Blocks.field_150359_w;
    }

    public List<ItemStack> getFacades() {
        this.calculateSubTypes();
        return this.subTypes;
    }

    public ItemStack getCreativeTabIcon() {
        this.calculateSubTypes();
        if (this.subTypes.isEmpty()) {
            return new ItemStack(Items.field_151105_aU);
        }
        return this.subTypes.get(0);
    }

    public ItemStack createFromIDs(int[] ids) {
        Iterator i$ = AEApi.instance().definitions().items().facade().maybeStack(1).asSet().iterator();
        if (i$.hasNext()) {
            ItemStack facadeStack = (ItemStack)i$.next();
            NBTTagCompound facadeTag = new NBTTagCompound();
            facadeTag.func_74783_a("x", (int[])ids.clone());
            facadeStack.func_77982_d(facadeTag);
            return facadeStack;
        }
        throw new MissingDefinition("Tried to create a facade, while facades are being deactivated.");
    }

    @Override
    public boolean useAlphaPass(ItemStack is) {
        ItemStack out = this.getTextureItem(is);
        if (out == null || out.func_77973_b() == null) {
            return false;
        }
        Block blk = Block.func_149634_a((Item)out.func_77973_b());
        return blk != null && blk.canRenderInPass(1);
    }
}

