/*
 * Decompiled with CFR 0.152.
 */
package appeng.fmp;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingDefinition;
import appeng.fmp.PartRegistry;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.IRandomDisplayTick;
import codechicken.multipart.minecraft.McBlockPart;
import codechicken.multipart.minecraft.McSidedMetaPart;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class QuartzTorchPart
extends McSidedMetaPart
implements IRandomDisplayTick {
    public QuartzTorchPart() {
        this(ForgeDirection.DOWN.ordinal());
    }

    public QuartzTorchPart(int meta) {
        super(meta);
    }

    public static McBlockPart placement(World world, BlockCoord pos, int side) {
        pos = pos.copy().offset(side);
        if (!world.isSideSolid(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)side))) {
            return null;
        }
        return new QuartzTorchPart(side);
    }

    public boolean doesTick() {
        return false;
    }

    public String getType() {
        return PartRegistry.QuartzTorchPart.getName();
    }

    public Cuboid6 getBounds() {
        return this.getBounds(this.meta);
    }

    private Cuboid6 getBounds(int meta) {
        ForgeDirection up = ForgeDirection.getOrientation((int)meta);
        double xOff = -0.3 * (double)up.offsetX;
        double yOff = -0.3 * (double)up.offsetY;
        double zOff = -0.3 * (double)up.offsetZ;
        return new Cuboid6(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7);
    }

    public int sideForMeta(int meta) {
        return ForgeDirection.getOrientation((int)meta).getOpposite().ordinal();
    }

    public void randomDisplayTick(Random r) {
        this.getBlock().func_149734_b(this.world(), this.x(), this.y(), this.z(), r);
    }

    public Block getBlock() {
        Iterator i$ = AEApi.instance().definitions().blocks().quartzTorch().maybeBlock().asSet().iterator();
        if (i$.hasNext()) {
            Block torchBlock = (Block)i$.next();
            return torchBlock;
        }
        throw new MissingDefinition("Tried to retrieve a quartz torch, even though it is disabled.");
    }
}

