/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.providers.AbstractSampler;

public class SubsamplingBuffer
extends AbstractSampler {
    public SubsamplingBuffer(int size) {
        super(size);
    }

    public void addDataPoint(double normalizedX, double currentY) {
        if (normalizedX < 0.0 || normalizedX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedX);
        }
        double currentX = (double)this.getSize() * normalizedX;
        int currentIndex = normalizedX == 1.0 ? this.getSize() - 1 : this.getIndex(currentX);
        SamplePoint point = this.getSamplePoint(currentIndex);
        point.min = Math.min(point.min, currentY);
        point.max = Math.max(point.max, currentY);
        if (currentX < point.xIn) {
            point.xIn = currentX;
            point.y = currentY;
        }
        if (currentX >= point.xOut) {
            point.xOut = currentX;
            point.yOut = currentY;
        }
        ++point.count;
        this.m_maxY = Math.max(this.m_maxY, point.max);
        this.m_minY = Math.min(this.m_minY, point.min);
    }
}

