/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.data.config;

import com.google.gson.Gson;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;

public class ModData {
    private static final Gson GSON = new Gson();
    private String name;
    private File file;
    private Map<String, Object> data = new HashMap<String, Object>();

    public ModData(String name, File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null!");
        }
        this.name = name;
        this.file = new File(directory, name + ".dat");
    }

    public ModData(String name) {
        this(name, ModData.geDefaultDirectory());
    }

    private static File geDefaultDirectory() {
        File file;
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null && server.func_130014_f_() != null && (file = server.func_130014_f_().func_72860_G().func_75765_b()) != null) {
            return new File(file, "gadomancy");
        }
        return null;
    }

    public <T> T get(String key, T defaultValue) {
        if (this.data.containsKey(key)) {
            return (T)this.data.get(key);
        }
        this.data.put(key, defaultValue);
        return defaultValue;
    }

    public <T> T get(String key) {
        return this.get(key, null);
    }

    public void set(String key, Object value) {
        this.data.put(key, value);
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        if (this.file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.file);
                this.data = (Map)new ObjectInputStream(in).readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        if (!this.file.getParentFile().exists() && !this.file.getParentFile().mkdirs()) {
            FMLLog.warning((String)("Failed to create directory: \"" + this.file.toString() + "\"!"), (Object[])new Object[0]);
            return false;
        }
        FileOutputStream out = null;
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            out = new FileOutputStream(this.file);
            new ObjectOutputStream(out).writeObject(this.data);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

