/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.data;

import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.common.data.AbstractData;
import makeo.gadomancy.common.registration.RegisteredPotions;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.potion.Potion;

public class DataAchromatic
extends AbstractData {
    private List<Integer> achromaticEntities = new ArrayList<Integer>();
    private List<Integer> addClientQueue = new ArrayList<Integer>();
    private List<Integer> removeClientQueue = new ArrayList<Integer>();

    public boolean isAchromatic(EntityPlayer player) {
        return this.achromaticEntities.contains(player.func_145782_y());
    }

    public void handleApplication(EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int entityId = entity.func_145782_y();
        boolean needsUpdate = false;
        if (!this.addClientQueue.contains(entityId) && !this.achromaticEntities.contains(entityId)) {
            this.addClientQueue.add(entityId);
            this.achromaticEntities.add(entityId);
            needsUpdate = true;
        }
        if (this.removeClientQueue.contains(entityId)) {
            this.removeClientQueue.remove((Object)entityId);
            this.addClientQueue.remove((Object)entityId);
            needsUpdate = false;
        }
        if (needsUpdate) {
            this.markDirty();
        }
    }

    public void handleRemoval(EntityLivingBase entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        int entityId = entity.func_145782_y();
        boolean needsUpdate = false;
        if (!this.removeClientQueue.contains(entityId) && this.achromaticEntities.contains(entityId)) {
            this.removeClientQueue.add(entityId);
            this.achromaticEntities.remove((Object)entityId);
            needsUpdate = true;
        }
        if (this.addClientQueue.contains(entityId)) {
            this.addClientQueue.remove((Object)entityId);
            this.removeClientQueue.remove((Object)entityId);
            needsUpdate = false;
        }
        if (needsUpdate) {
            this.markDirty();
        }
    }

    public void checkPotionEffect(EntityPlayerMP p) {
        if (p.func_70644_a((Potion)RegisteredPotions.ACHROMATIC)) {
            this.handleApplication((EntityLivingBase)p);
        }
    }

    @Override
    public boolean needsUpdate() {
        return !this.addClientQueue.isEmpty() || !this.removeClientQueue.isEmpty();
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        int[] array = new int[this.achromaticEntities.size()];
        for (int i = 0; i < this.achromaticEntities.size(); ++i) {
            array[i] = this.achromaticEntities.get(i);
        }
        compound.func_74782_a("additions", (NBTBase)new NBTTagIntArray(array));
        compound.func_74782_a("removals", (NBTBase)new NBTTagIntArray(new int[0]));
    }

    @Override
    public void writeToPacket(NBTTagCompound compound) {
        int i;
        int[] array = new int[this.removeClientQueue.size()];
        for (i = 0; i < this.removeClientQueue.size(); ++i) {
            array[i] = this.removeClientQueue.get(i);
        }
        compound.func_74782_a("removals", (NBTBase)new NBTTagIntArray(array));
        array = new int[this.addClientQueue.size()];
        for (i = 0; i < this.addClientQueue.size(); ++i) {
            array[i] = this.addClientQueue.get(i);
        }
        compound.func_74782_a("additions", (NBTBase)new NBTTagIntArray(array));
        this.removeClientQueue.clear();
        this.addClientQueue.clear();
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        int[] array = compound.func_74759_k("removals");
        if (array != null && array.length > 0) {
            for (int i : array) {
                this.removeClientQueue.add(i);
            }
        }
        if ((array = compound.func_74759_k("additions")) != null && array.length > 0) {
            for (int i : array) {
                this.addClientQueue.add(i);
            }
        }
    }

    @Override
    public void handleIncomingData(AbstractData serverData) {
        DataAchromatic achromatic = (DataAchromatic)serverData;
        List<Integer> toRemove = achromatic.removeClientQueue;
        this.achromaticEntities.removeAll(toRemove);
        List<Integer> toAdd = achromatic.addClientQueue;
        this.achromaticEntities.addAll(toAdd);
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataAchromatic> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataAchromatic provideNewInstance() {
            return new DataAchromatic();
        }
    }
}

