/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import makeo.gadomancy.api.GadomancyApi;
import makeo.gadomancy.api.golems.cores.AdditionalGolemCore;
import makeo.gadomancy.client.events.ClientHandler;
import makeo.gadomancy.client.events.FakeArchitectItem;
import makeo.gadomancy.client.events.ResourceReloadListener;
import makeo.gadomancy.client.gui.GuiResearchRecipeAuraEffects;
import makeo.gadomancy.client.util.ExtendedTypeDisplayManager;
import makeo.gadomancy.client.util.FamiliarHandlerClient;
import makeo.gadomancy.client.util.MultiTickEffectDispatcher;
import makeo.gadomancy.common.CommonProxy;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNode;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNodeJar;
import makeo.gadomancy.common.data.DataAchromatic;
import makeo.gadomancy.common.data.SyncDataHolder;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.utils.Injector;
import makeo.gadomancy.common.utils.MiscUtils;
import makeo.gadomancy.common.utils.NBTHelper;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.BlockCoordinates;
import thaumcraft.api.IArchitect;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.gui.GuiGolem;
import thaumcraft.client.gui.GuiResearchRecipe;
import thaumcraft.client.lib.REHWandHandler;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.items.relics.ItemThaumometer;
import thaumcraft.common.items.wands.ItemWandCasting;

public class RenderEventHandler {
    private static final REHWandHandler WAND_HANDLER;
    private static final FakeArchitectItem ARCHITECT_ITEM;
    private Object oldGolemblurb = null;
    private int blurbId;
    private EntityPlayer current = null;
    private ItemStack[] armor = null;
    private static final IModelCustom obj;
    private static final ResourceLocation tex;
    private static int dList;

    @SubscribeEvent
    public void on(GuiScreenEvent.DrawScreenEvent.Pre e) {
        AdditionalGolemCore core;
        GuiGolem gui;
        EntityGolemBase golem;
        if (e.gui instanceof GuiGolem && (golem = (EntityGolemBase)new Injector(gui = (GuiGolem)e.gui, GuiGolem.class).getField("golem")) != null && (core = GadomancyApi.getAdditionalGolemCore(golem)) != null) {
            this.blurbId = core.getBaseCore();
            String key = "golemblurb." + this.blurbId + ".text";
            this.oldGolemblurb = ResourceReloadListener.languageList.get(key);
            ResourceReloadListener.languageList.put(key, StatCollector.func_74838_a((String)core.getUnlocalizedGuiText()));
        }
    }

    @SubscribeEvent
    public void on(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (this.oldGolemblurb != null) {
            String key = "golemblurb." + this.blurbId + ".text";
            ResourceReloadListener.languageList.put(key, this.oldGolemblurb);
            this.oldGolemblurb = null;
        }
    }

    @SubscribeEvent
    public void on(DrawBlockHighlightEvent e) {
        if (e.currentItem == null) {
            return;
        }
        if (e.currentItem.func_77973_b() instanceof ItemWandCasting) {
            Block block;
            ItemFocusBasic focus = ((ItemWandCasting)e.currentItem.func_77973_b()).getFocus(e.currentItem);
            if (!(focus != null && focus instanceof IArchitect || (block = e.player.field_70170_p.func_147439_a(e.target.field_72311_b, e.target.field_72312_c, e.target.field_72309_d)) == null || block != RegisteredBlocks.blockArcaneDropper)) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(e.player.field_70170_p.func_72805_g(e.target.field_72311_b, e.target.field_72312_c, e.target.field_72309_d) & 7));
                ArrayList<BlockCoordinates> coords = new ArrayList<BlockCoordinates>();
                for (int x = -1; x < 2; ++x) {
                    for (int y = -1; y < 2; ++y) {
                        for (int z = -1; z < 2; ++z) {
                            coords.add(new BlockCoordinates(e.target.field_72311_b + 2 * dir.offsetX + x, e.target.field_72312_c + 2 * dir.offsetY + y, e.target.field_72309_d + 2 * dir.offsetZ + z));
                        }
                    }
                }
                coords.add(new BlockCoordinates(e.target.field_72311_b + dir.offsetX, e.target.field_72312_c + dir.offsetY, e.target.field_72309_d + dir.offsetZ));
                ARCHITECT_ITEM.setCoords(coords);
                GL11.glPushAttrib((int)1048575);
                WAND_HANDLER.handleArchitectOverlay(new ItemStack((Item)ARCHITECT_ITEM), e, e.player.field_70173_aa, e.target);
                GL11.glPopAttrib();
            }
        } else if (e.currentItem.func_77973_b() instanceof ItemThaumometer) {
            if (e.target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            int blockX = e.target.field_72311_b;
            int blockY = e.target.field_72312_c;
            int blockZ = e.target.field_72309_d;
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                TileEntity tile = e.player.field_70170_p.func_147438_o(blockX, blockY, blockZ);
                if (tile instanceof TileExtendedNode) {
                    TileExtendedNode node = (TileExtendedNode)tile;
                    if (node.getExtendedNodeType() == null) {
                        return;
                    }
                    ExtendedTypeDisplayManager.notifyDisplayTick(node.getId(), node.getNodeType(), node.getExtendedNodeType());
                } else if (tile instanceof TileExtendedNodeJar) {
                    TileExtendedNodeJar nodeJar = (TileExtendedNodeJar)tile;
                    if (nodeJar.getExtendedNodeType() == null) {
                        return;
                    }
                    ExtendedTypeDisplayManager.notifyDisplayTick(nodeJar.getId(), nodeJar.getNodeType(), nodeJar.getExtendedNodeType());
                }
            }
        }
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.gui != null && event.gui instanceof GuiResearchRecipe) {
            GuiResearchRecipe gui = (GuiResearchRecipe)event.gui;
            ResearchItem research = (ResearchItem)new Injector(gui, GuiResearchRecipe.class).getField("research");
            if (research.key.equals("gadomancy".toUpperCase() + ".AURA_EFFECTS") && !(gui instanceof GuiResearchRecipeAuraEffects)) {
                event.gui = GuiResearchRecipeAuraEffects.create(gui);
            }
        }
    }

    @SubscribeEvent
    public void worldRenderEvent(RenderWorldLastEvent event) {
        ExtendedTypeDisplayManager.notifyRenderTick();
        MultiTickEffectDispatcher.notifyRenderTick((World)Minecraft.func_71410_x().field_71441_e, event.partialTicks);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderEntityPre(RenderLivingEvent.Pre event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)event.entity;
            if (((DataAchromatic)SyncDataHolder.getDataClient("AchromaticData")).isAchromatic((EntityPlayer)event.entity)) {
                this.current = p;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
            }
            this.armor = p.field_71071_by.field_70460_b;
            p.field_71071_by.field_70460_b = new ItemStack[this.armor.length];
            System.arraycopy(this.armor, 0, p.field_71071_by.field_70460_b, 0, this.armor.length);
            boolean changed = false;
            for (int i = 0; i < this.armor.length; ++i) {
                NBTTagCompound compound;
                if (this.armor[i] == null || !NBTHelper.hasPersistentData(this.armor[i]) || !(compound = NBTHelper.getPersistentData(this.armor[i])).func_74764_b("disguise")) continue;
                NBTBase base = compound.func_74781_a("disguise");
                p.field_71071_by.field_70460_b[i] = base instanceof NBTTagCompound ? ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)base)) : null;
                changed = true;
            }
            if (!changed) {
                p.field_71071_by.field_70460_b = this.armor;
                this.armor = null;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void renderPost(RenderLivingEvent.Post event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)event.entity;
            if (this.armor != null) {
                p.field_71071_by.field_70460_b = this.armor;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onSetArmor(RenderPlayerEvent.SetArmorModel event) {
        if (event.entityPlayer == this.current) {
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDepthMask((boolean)true);
        }
    }

    @SubscribeEvent
    public void onRender(RenderPlayerEvent.Specials.Post event) {
        if (event.entityPlayer == null) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (!CommonProxy.serverOnlineState) {
            return;
        }
        if (!MiscUtils.isMisunderstood(event.entityPlayer)) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(tex);
        boolean f = event.entityPlayer.field_71075_bZ.field_75100_b;
        double ma = f ? 15.0 : 5.0;
        double r = ma * ((double)Math.abs(ClientHandler.ticks % 80 - 40) / 40.0) + (65.0 - ma) * Math.max(0.0, Math.min(1.0, new Vector3(event.entityPlayer.field_70159_w, 0.0, event.entityPlayer.field_70179_y).length()));
        GL11.glScaled((double)0.07, (double)0.07, (double)0.07);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)0.0, (double)-12.7, (double)(0.7 - (double)((float)(r / ma)) * (f ? 0.5 : 0.2)));
        if (dList == -1) {
            dList = GLAllocation.func_74526_a((int)2);
            GL11.glNewList((int)dList, (int)4864);
            obj.renderOnly(new String[]{"wR"});
            GL11.glEndList();
            GL11.glNewList((int)(dList + 1), (int)4864);
            obj.renderOnly(new String[]{"wL"});
            GL11.glEndList();
        }
        GL11.glPushMatrix();
        GL11.glRotated((double)(20.0 + r), (double)0.0, (double)-1.0, (double)0.0);
        GL11.glCallList((int)dList);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)(20.0 + r), (double)0.0, (double)1.0, (double)0.0);
        GL11.glCallList((int)(dList + 1));
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void playerRenderEvent(RenderPlayerEvent.Post renderEvent) {
        FamiliarHandlerClient.playerRenderEvent(renderEvent.entityPlayer, renderEvent.partialRenderTick);
    }

    static {
        WavefrontObject buf;
        WAND_HANDLER = new REHWandHandler();
        ARCHITECT_ITEM = new FakeArchitectItem();
        ResourceLocation mod = new ResourceLocation("gadomancy".toLowerCase() + new String(new byte[]{58, 116, 101, 120, 116, 117, 114, 101, 115, 47, 109, 111, 100, 101, 108, 115, 47, 109, 111, 100, 101, 108, 65, 115, 115, 101, 99, 46, 111, 98, 106}, Charset.forName("UTF-8")));
        try {
            buf = new WavefrontObject("gadomancy:wRender", (InputStream)new GZIPInputStream(Minecraft.func_71410_x().func_110442_L().func_110536_a(mod).func_110527_b()));
        }
        catch (Exception exc) {
            buf = null;
        }
        obj = buf;
        tex = new ResourceLocation(new String(new byte[]{103, 97, 100, 111, 109, 97, 110, 99, 121, 58, 116, 101, 120, 116, 117, 114, 101, 115, 47, 109, 105, 115, 99, 47, 116, 101, 120, 87, 46, 112, 110, 103}, Charset.forName("UTF-8")));
        dList = -1;
    }
}

