/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.io;

import com.jrockit.mc.common.io.IOResource;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class IOResourceSet
implements Iterable<IOResource> {
    private final List<IOResource> m_resources;

    public IOResourceSet(IOResource ... resources) {
        this.m_resources = Arrays.asList(resources);
    }

    public IOResourceSet(List<IOResource> resources) {
        this.m_resources = resources;
    }

    public List<IOResource> getResources() {
        return this.m_resources;
    }

    public IOResource getResource(int index) {
        return this.m_resources.get(index);
    }

    @Override
    public Iterator<IOResource> iterator() {
        return this.m_resources.iterator();
    }

    public IOResource findWithPrefix(String namePrefix) {
        for (IOResource file : this.m_resources) {
            if (!file.getName().startsWith(namePrefix)) continue;
            return file;
        }
        return null;
    }

    public IOResource findWithPostfix(String namePostfix) {
        for (IOResource file : this.m_resources) {
            if (!file.getName().endsWith(namePostfix)) continue;
            return file;
        }
        return null;
    }

    public void close() {
        for (IOResource resource : this.m_resources) {
            resource.close();
        }
    }
}

