/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.gui;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import info.jbcs.minecraft.vending.General;
import info.jbcs.minecraft.vending.GeneralClient;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class HintGui
extends Gui {
    private Minecraft mc;
    RenderItem render = new RenderItem();

    public HintGui(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderInfo(RenderGameOverlayEvent.Post event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (this.mc == null || this.mc.field_71439_g == null || this.mc.field_71441_e == null) {
            return;
        }
        WorldClient world = this.mc.field_71441_e;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        MovingObjectPosition mop = General.getMovingObjectPositionFromPlayer((World)world, (EntityPlayer)player, false);
        if (mop == null) {
            return;
        }
        TileEntity te = world.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        if (te == null) {
            return;
        }
        if (!(te instanceof TileEntityVendingMachine)) {
            return;
        }
        TileEntityVendingMachine tileEntity = (TileEntityVendingMachine)te;
        this.draw(tileEntity.ownerName, tileEntity.getSoldItems(), tileEntity.getBoughtItems());
        GeneralClient.bind("textures/gui/icons.png");
    }

    void drawNumberForItem(FontRenderer fontRenderer, ItemStack stack, int ux, int uy) {
        if (stack == null || stack.field_77994_a < 2) {
            return;
        }
        String line = "" + stack.field_77994_a;
        int x = ux + 19 - 2 - fontRenderer.func_78256_a(line);
        int y = uy + 6 + 3;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)50.0f);
        this.func_73731_b(fontRenderer, line, x + 1, y + 1, 0x888888);
        this.func_73731_b(fontRenderer, line, x, y, 0xFFFFFF);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-50.0f);
    }

    void drawItemsWithLabel(FontRenderer fontRenderer, String label, int x, int y, int colour, ItemStack[] itemStacks, boolean drawDescription, int descWidth) {
        ItemStack itemStack;
        int w = fontRenderer.func_78256_a(StatCollector.func_74838_a((String)label)) + 2;
        int numOfItems = General.countNotNull(itemStacks);
        int witdth = drawDescription ? Math.max(w + 18 * numOfItems, descWidth) : w + 18 * numOfItems;
        this.func_73731_b(fontRenderer, StatCollector.func_74838_a((String)label), x -= witdth / 2, y, colour);
        for (ItemStack itemStack2 : itemStacks) {
            if (itemStack2 == null) continue;
            this.drawNumberForItem(fontRenderer, itemStack2, x + w, y - 4);
            this.render.func_77015_a(fontRenderer, this.mc.field_71446_o, itemStack2, x + w, y - 4);
            GL11.glDisable((int)2896);
            w += 18;
        }
        y += 20;
        if (drawDescription && (itemStack = General.getNotNull(itemStacks, (int)this.mc.field_71439_g.field_70170_p.func_72820_D() / 50 % numOfItems)) != null) {
            for (Object object : itemStack.func_82840_a((EntityPlayer)this.mc.field_71439_g, false).toArray()) {
                String line = object.toString();
                if (line.isEmpty()) continue;
                this.func_73731_b(fontRenderer, line, x, y, 0xA0A0A0);
                y += 16;
            }
        }
    }

    void draw(String seller, ItemStack[] soldItems, ItemStack[] boughtItems) {
        String tooltip;
        int i;
        int c;
        boolean isBoughtEmpty;
        boolean isSoldEmpty = General.countNotNull(soldItems) == 0;
        boolean bl = isBoughtEmpty = General.countNotNull(boughtItems) == 0;
        if (isBoughtEmpty && isSoldEmpty) {
            return;
        }
        ScaledResolution resolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int screenwidth = resolution.func_78326_a();
        FontRenderer fontRenderer = this.mc.field_71466_p;
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        int linesBought = 0;
        int lengthBought = 0;
        int linesSold = 0;
        int lengthSold = 0;
        for (ItemStack bought : boughtItems) {
            if (bought == null) continue;
            c = 0;
            for (i = 0; i < bought.func_82840_a((EntityPlayer)this.mc.field_71439_g, false).size(); ++i) {
                tooltip = bought.func_82840_a((EntityPlayer)this.mc.field_71439_g, false).get(i).toString();
                if (!tooltip.isEmpty()) {
                    ++c;
                }
                if (tooltip.length() <= lengthBought) continue;
                lengthBought = fontRenderer.func_78256_a(tooltip);
            }
            linesBought = Math.max(linesBought, c);
        }
        for (ItemStack sold : soldItems) {
            if (sold == null) continue;
            c = 0;
            for (i = 0; i < sold.func_82840_a((EntityPlayer)this.mc.field_71439_g, false).size(); ++i) {
                tooltip = sold.func_82840_a((EntityPlayer)this.mc.field_71439_g, false).get(i).toString();
                if (!tooltip.isEmpty()) {
                    ++c;
                }
                if (tooltip.length() <= lengthSold) continue;
                lengthSold = fontRenderer.func_78256_a(tooltip);
            }
            linesSold = Math.max(linesBought, c);
            linesBought = Math.max(linesBought, c);
        }
        boolean drawDesc = this.mc.field_71439_g.func_70093_af();
        int descHeight = Math.max(linesBought, linesSold) * 16;
        int w = 120;
        if (drawDesc) {
            w = !isBoughtEmpty && !isSoldEmpty ? 340 : 140;
        }
        int h = 44 + (drawDesc ? descHeight : 0) + (!isBoughtEmpty && !isSoldEmpty ? 16 : 0);
        int centerYOff = -80 + (drawDesc ? descHeight / 2 : 0) + (!isBoughtEmpty && !isSoldEmpty ? 8 : 0);
        if (drawDesc && !isBoughtEmpty && !isSoldEmpty) {
            h -= 16;
            centerYOff -= 8;
        }
        int cx = width / 2;
        int x = cx - w / 2;
        int y = height / 2 - h / 2 + centerYOff;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
        GL11.glDisable((int)2896);
        this.func_73733_a(x, y, x + w, y + h, -1072689136, -804253680);
        this.func_73732_a(fontRenderer, seller, cx, y + 8, 0xFFFFFF);
        if (!isBoughtEmpty && !isSoldEmpty) {
            this.drawItemsWithLabel(fontRenderer, "gui.vendingBlock.isSelling", cx - (drawDesc ? 100 : 0), y + 26, 0xA0A0A0, soldItems, drawDesc, lengthSold);
            this.drawItemsWithLabel(fontRenderer, "gui.vendingBlock.for", cx + (drawDesc ? 100 : 0), y + (drawDesc ? 26 : 46), 0xA0A0A0, boughtItems, drawDesc, lengthBought);
        } else if (!isBoughtEmpty) {
            this.drawItemsWithLabel(fontRenderer, "gui.vendingBlock.isAccepting", cx, y + 26, 0xA0A0A0, boughtItems, drawDesc, lengthBought);
        } else {
            this.drawItemsWithLabel(fontRenderer, "gui.vendingBlock.isGivingAway", cx, y + 26, 0xA0A0A0, soldItems, drawDesc, lengthSold);
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }
}

