/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.block;

import info.jbcs.minecraft.vending.General;
import info.jbcs.minecraft.vending.Vending;
import info.jbcs.minecraft.vending.renderer.BlockVendingMachineRenderer;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockVendingMachine
extends BlockContainer {
    Block[] supportBlocks;
    boolean isAdvanced;
    boolean isMultiple;
    IIcon IIconTop;
    IIcon IIconSide;

    public BlockVendingMachine(Block[] supports, boolean advanced, boolean multiple) {
        super(Material.field_151592_s);
        this.func_149663_c("vendingMachine");
        this.supportBlocks = supports;
        this.func_149672_a(Block.field_149778_k);
        this.func_149647_a(Vending.tabVending);
        this.func_149711_c(0.3f);
        this.func_149752_b(6000000.0f);
        this.func_149722_s();
        this.func_149672_a(Block.field_149778_k);
        this.func_149676_a(0.0625f, 0.125f, 0.0625f, 0.9375f, 0.9375f, 0.9375f);
        this.isAdvanced = advanced;
        this.isMultiple = multiple;
    }

    void vend(World world, int i, int j, int k, EntityPlayer entityplayer) {
        TileEntityVendingMachine tileEntity = (TileEntityVendingMachine)world.func_147438_o(i, j, k);
        if (tileEntity == null) {
            return;
        }
        ItemStack[] soldItems = tileEntity.getSoldItems();
        ItemStack bought = tileEntity.getBoughtItems()[0];
        ItemStack offered = entityplayer.field_71071_by.func_70448_g();
        boolean fits = true;
        if (bought == null) {
            offered = null;
            if (soldItems == null) {
                fits = false;
            }
        } else if (!tileEntity.doesStackFit(bought)) {
            fits = false;
        } else if (offered == null) {
            fits = false;
        } else if (bought.func_77973_b() != offered.func_77973_b()) {
            fits = false;
        } else if (bought.func_77942_o() || offered.func_77942_o()) {
            if (bought.func_77942_o() && offered.func_77942_o()) {
                if (!bought.func_77978_p().equals((Object)offered.func_77978_p())) {
                    fits = false;
                }
            } else {
                fits = false;
            }
        } else if (bought.func_77960_j() != offered.func_77960_j()) {
            fits = false;
        } else if (offered.field_77994_a < bought.field_77994_a) {
            fits = false;
        }
        if (fits) {
            if (!world.field_72995_K) {
                if (General.countNotNull(soldItems) != 0) {
                    for (ItemStack sold : soldItems) {
                        if (sold == null) continue;
                        NBTTagCompound tag = new NBTTagCompound();
                        sold.func_77955_b(tag);
                        ItemStack vended = ItemStack.func_77949_a((NBTTagCompound)tag);
                        if (!tileEntity.infinite) {
                            tileEntity.inventory.takeItems(sold, sold.func_77960_j(), sold.field_77994_a);
                        }
                        EntityItem entityitem = new EntityItem(world, (double)i + 0.5, (double)j + 1.2, (double)k + 0.5, vended);
                        General.propelTowards((Entity)entityitem, (Entity)entityplayer, 0.2);
                        entityitem.field_70181_x = 0.2;
                        entityitem.field_145804_b = 10;
                        world.func_72838_d((Entity)entityitem);
                    }
                }
                world.func_72908_a((double)i, (double)j, (double)k, "vending:cha-ching", 0.3f, 0.6f);
                if (offered != null) {
                    ItemStack paid = offered.func_77979_a(bought.field_77994_a);
                    if (offered.field_77994_a == 0) {
                        entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = null;
                    }
                    if (!tileEntity.infinite) {
                        tileEntity.inventory.addItemStackToInventory(paid, 0, 8);
                    }
                }
                if (!tileEntity.infinite) {
                    tileEntity.inventory.onInventoryChanged();
                }
            }
        } else {
            world.func_72908_a((double)i, (double)j, (double)k, "vending:forbidden", 1.0f, 1.0f);
        }
    }

    public void func_149699_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        TileEntityVendingMachine tileEntity = (TileEntityVendingMachine)world.func_147438_o(i, j, k);
        if (tileEntity == null) {
            return;
        }
        if (!entityplayer.getDisplayName().equals(tileEntity.ownerName) || !tileEntity.inventory.isEmpty()) {
            this.vend(world, i, j, k, entityplayer);
            return;
        }
        this.func_149697_b(world, i, j, k, world.func_72805_g(i, j, k), 0);
        world.func_147449_b(i, j, k, Blocks.field_150350_a);
        world.func_72908_a((double)i, (double)j, (double)k, "vending:cha-ching", 0.3f, 0.6f);
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int a, float b, float x, float y) {
        TileEntityVendingMachine tileEntity = (TileEntityVendingMachine)world.func_147438_o(i, j, k);
        if (tileEntity == null) {
            return false;
        }
        if (entityplayer.field_71071_by.func_70448_g() != null && entityplayer.field_71071_by.func_70448_g().func_77973_b() == Vending.itemWrench) {
            Vending.guiWrench.open(entityplayer, world, i, j, k);
            return true;
        }
        if (entityplayer.getDisplayName().equals(tileEntity.ownerName) && !entityplayer.func_70093_af()) {
            Vending.guiVending.open(entityplayer, world, i, j, k);
            return true;
        }
        if (entityplayer.field_71075_bZ.field_75098_d && !entityplayer.func_70093_af()) {
            Vending.guiVending.open(entityplayer, world, i, j, k);
            return true;
        }
        this.vend(world, i, j, k, entityplayer);
        return true;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntityVendingMachine e = new TileEntityVendingMachine();
        e.advanced = this.isAdvanced;
        e.multiple = this.isMultiple;
        if (entityliving != null) {
            EntityPlayer player = (EntityPlayer)entityliving;
            e.ownerName = player.getDisplayName();
            world.func_147455_a(i, j, k, (TileEntity)e);
        }
    }

    public int func_149701_w() {
        return 0;
    }

    public IIcon func_149691_a(int side, int meta) {
        return side < 2 ? this.IIconTop : this.IIconSide;
    }

    public TileEntity func_149915_a(World var1, int metadata) {
        TileEntityVendingMachine e = new TileEntityVendingMachine();
        e.advanced = this.isAdvanced;
        e.multiple = this.isMultiple;
        return e;
    }

    public void func_149749_a(World world, int i, int j, int k, Block a, int b) {
        TileEntityVendingMachine tileentitychest = (TileEntityVendingMachine)world.func_147438_o(i, j, k);
        if (tileentitychest == null) {
            return;
        }
        for (int l = 0; l < tileentitychest.func_70302_i_(); ++l) {
            ItemStack itemstack = tileentitychest.func_70301_a(l);
            if (itemstack == null) continue;
            float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int i1 = world.field_73012_v.nextInt(21) + 10;
                if (i1 > itemstack.field_77994_a) {
                    i1 = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= i1;
                EntityItem entityitem = new EntityItem(world, (double)((float)i + f), (double)((float)j + f1), (double)((float)k + f2), new ItemStack(itemstack.func_77973_b(), i1, itemstack.func_77960_j()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.func_149749_a(world, i, j, k, a, b);
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149692_a(int i) {
        return i;
    }

    public void func_149651_a(IIconRegister register) {
        this.IIconTop = register.func_94245_a("Vending:vendor-top");
        this.IIconSide = register.func_94245_a("Vending:vendor-side");
    }

    public int func_149645_b() {
        return BlockVendingMachineRenderer.id;
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        for (int i = 0; i < this.supportBlocks.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }
}

