/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.registry.GameRegistry;
import info.jbcs.minecraft.vending.block.BlockVendingMachine;
import info.jbcs.minecraft.vending.gui.GuiAdvancedVendingMachine;
import info.jbcs.minecraft.vending.gui.GuiHandler;
import info.jbcs.minecraft.vending.gui.GuiMultipleVendingMachine;
import info.jbcs.minecraft.vending.gui.GuiVendingMachine;
import info.jbcs.minecraft.vending.gui.GuiWrenchVendingMachine;
import info.jbcs.minecraft.vending.inventory.ContainerAdvancedVendingMachine;
import info.jbcs.minecraft.vending.inventory.ContainerMultipleVendingMachine;
import info.jbcs.minecraft.vending.inventory.ContainerVendingMachine;
import info.jbcs.minecraft.vending.inventory.DummyContainer;
import info.jbcs.minecraft.vending.item.ItemMetaBlock;
import info.jbcs.minecraft.vending.network.MessagePipeline;
import info.jbcs.minecraft.vending.proxy.CommonProxy;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="vending", name="vending", version="1.2.3")
public class Vending {
    public static final String MOD_ID = "vending";
    public static final String MOD_NAME = "vending";
    public static final String VERSION = "1.2.3";
    @Mod.Instance(value="vending")
    public static Vending instance;
    public static FMLEventChannel Channel;
    public static Block blockVendingMachine;
    public static Block blockAdvancedVendingMachine;
    public static Block blockMultipleVendingMachine;
    public static Item itemWrench;
    public static GuiHandler guiVending;
    public static GuiHandler guiWrench;
    public static CreativeTabs tabVending;
    static Configuration config;
    public MessagePipeline messagePipeline = new MessagePipeline();
    public static Block[] supports;
    static Object[] reagents;
    @SidedProxy(clientSide="info.jbcs.minecraft.vending.proxy.ClientProxy", serverSide="info.jbcs.minecraft.vending.proxy.CommonProxy")
    public static CommonProxy commonProxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        commonProxy.registerPackets(this.messagePipeline);
        commonProxy.registerEventHandlers();
        commonProxy.registerRenderers();
        tabVending = config.get("general", "use custom creative tab", true, "Add a new tab to creative mode and put all vending blocks there.").getBoolean(true) ? new CreativeTabs("tabVending"){

            public ItemStack func_151244_d() {
                return new ItemStack(blockVendingMachine, 1, 4);
            }

            public Item func_78016_d() {
                return new ItemStack(blockVendingMachine, 1, 4).func_77973_b();
            }
        } : CreativeTabs.field_78031_c;
        blockVendingMachine = new BlockVendingMachine(supports, false, false);
        GameRegistry.registerBlock((Block)blockVendingMachine, ItemMetaBlock.class, (String)"vendingMachine");
        blockAdvancedVendingMachine = new BlockVendingMachine(supports, true, false).func_149663_c("vendingMachineAdvanced");
        GameRegistry.registerBlock((Block)blockAdvancedVendingMachine, ItemMetaBlock.class, (String)"vendingMachineAdvanced");
        blockMultipleVendingMachine = new BlockVendingMachine(supports, false, true).func_149663_c("vendingMachineMultiple");
        GameRegistry.registerBlock((Block)blockMultipleVendingMachine, ItemMetaBlock.class, (String)"vendingMachineMultiple");
        itemWrench = new Item().func_77655_b("vendingMachineWrench").func_77637_a(tabVending).func_111206_d("Vending:wrench");
        GameRegistry.registerItem((Item)itemWrench, (String)"vendingMachineWrench");
        GameRegistry.registerTileEntity(TileEntityVendingMachine.class, (String)"containerVendingMachine");
        for (int i = 0; i < supports.length; ++i) {
            CraftingManager.func_77594_a().func_92103_a(new ItemStack(blockVendingMachine, 1, i), new Object[]{"XXX", "XGX", "*R*", Character.valueOf('X'), Blocks.field_150359_w, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('*'), reagents[i]});
            CraftingManager.func_77594_a().func_92103_a(new ItemStack(blockAdvancedVendingMachine, 1, i), new Object[]{"XXX", "XGX", "*R*", Character.valueOf('X'), Blocks.field_150359_w, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('R'), Items.field_151107_aW, Character.valueOf('*'), reagents[i]});
            CraftingManager.func_77594_a().func_92103_a(new ItemStack(blockMultipleVendingMachine, 1, i), new Object[]{"XXX", "XGX", "*R*", Character.valueOf('X'), Blocks.field_150359_w, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('R'), Blocks.field_150367_z, Character.valueOf('*'), reagents[i]});
        }
        guiVending = new GuiHandler("vending"){

            @Override
            public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityVendingMachine)) {
                    return null;
                }
                TileEntityVendingMachine e = (TileEntityVendingMachine)tileEntity;
                if (e.advanced) {
                    return new ContainerAdvancedVendingMachine((IInventory)player.field_71071_by, e);
                }
                if (e.multiple) {
                    return new ContainerMultipleVendingMachine((IInventory)player.field_71071_by, e);
                }
                return new ContainerVendingMachine((IInventory)player.field_71071_by, e);
            }

            @Override
            public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityVendingMachine)) {
                    return null;
                }
                TileEntityVendingMachine e = (TileEntityVendingMachine)tileEntity;
                if (e.advanced) {
                    return new GuiAdvancedVendingMachine(player.field_71071_by, e);
                }
                if (e.multiple) {
                    return new GuiMultipleVendingMachine(player.field_71071_by, e);
                }
                return new GuiVendingMachine(player.field_71071_by, e);
            }
        };
        guiWrench = new GuiHandler("wrench"){

            @Override
            public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                return new DummyContainer();
            }

            @Override
            public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                return new GuiWrenchVendingMachine(world, x, y, z, player);
            }
        };
        GuiHandler.register(this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        supports = new Block[]{Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150417_aV, Blocks.field_150344_f, Blocks.field_150462_ai, Blocks.field_150351_n, Blocks.field_150323_B, Blocks.field_150322_A, Blocks.field_150340_R, Blocks.field_150339_S, Blocks.field_150336_V, Blocks.field_150341_Y, Blocks.field_150343_Z, Blocks.field_150484_ah, Blocks.field_150475_bE, Blocks.field_150368_y};
        reagents = new Object[]{Blocks.field_150348_b, Blocks.field_150347_e, Blocks.field_150417_aV, Blocks.field_150344_f, Blocks.field_150462_ai, Blocks.field_150351_n, Blocks.field_150323_B, Blocks.field_150322_A, Items.field_151043_k, Items.field_151042_j, Blocks.field_150336_V, Blocks.field_150341_Y, Blocks.field_150343_Z, Items.field_151045_i, Items.field_151166_bC, Blocks.field_150368_y};
    }
}

